<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Commune
 *
 * @ORM\Table(name="commune")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\CommuneRepository")
 */
class Commune
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="libelle", type="string", length=255)
     */
    private $libelle;

    /**
     * @ORM\OneToMany(targetEntity="Fournissseur", mappedBy="commune")
     */
    private $fournisseur;

    /** 
     * @ORM\ManyToOne(targetEntity="Ville", inversedBy="communes", cascade={"persist"})
     * @ORM\JoinColumn(name="ville_id", referencedColumnName="id")
     */
    private $ville;

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set code
     *
     * @param string $code
     *
     * @return Commune
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * Get code
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set libelle
     *
     * @param string $libelle
     *
     * @return Commune
     */
    public function setLibelle($libelle)
    {
        $this->libelle = $libelle;

        return $this;
    }

    /**
     * Get libelle
     *
     * @return string
     */
    public function getLibelle()
    {
        return $this->libelle;
    }

    /**
     * Set statut
     *
     * @param string $statut
     *
     * @return Commune
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return string
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return Commune
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Constructor
     */
    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); 
        $this->fournisseur = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Add fournisseur
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseur
     *
     * @return Commune
     */
    public function addFournisseur(\AMLA\SqrBundle\Entity\Fournissseur $fournisseur)
    {
        $this->fournisseur[] = $fournisseur;

        return $this;
    }

    /**
     * Remove fournisseur
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseur
     */
    public function removeFournisseur(\AMLA\SqrBundle\Entity\Fournissseur $fournisseur)
    {
        $this->fournisseur->removeElement($fournisseur);
    }

    /**
     * Get fournisseur
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFournisseur()
    {
        return $this->fournisseur;
    }

    /**
     * Set ville
     *
     * @param \AMLA\SqrBundle\Entity\Ville $ville
     *
     * @return Commune
     */
    public function setVille(\AMLA\SqrBundle\Entity\Ville $ville = null)
    {
        $this->ville = $ville;

        return $this;
    }

    /**
     * Get ville
     *
     * @return \AMLA\SqrBundle\Entity\Ville
     */
    public function getVille()
    {
        return $this->ville;
    }
}
