<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;


/**
 * ParkQr
 *
 * @ORM\Table(name="check_qr")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\CheckQrRepository")
 */
class CheckQr
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="libelle", type="string", length=50)
     */
    private $libelle;

    /**
     * @var string
     *
     * @ORM\Column(name="numero", type="string", length=50)
     */
    private $numero;

    /**
     * @var string
     *
     * @ORM\Column(name="chemin", type="string", length=50)
     */
    private $chemin;

    /**
     * @ORM\OneToMany(targetEntity="BonCommande", mappedBy="qrCode",cascade={"persist"}, orphanRemoval=true)
    */
    private $bonCommandes;

    /**
     * @ORM\OneToMany(targetEntity="Atd", mappedBy="qrCode",cascade={"persist"}, orphanRemoval=true)
    */
    private $atd;

    /**
     * @ORM\OneToMany(targetEntity="MouvementAtd", mappedBy="qrCode",cascade={"persist"}, orphanRemoval=true)
    */
    private $mouvementAtd;

    /**
     * @ORM\OneToMany(targetEntity="AttestationVerification", mappedBy="qrCode",cascade={"persist"}, orphanRemoval=true)
    */
    private $attestations;

    /**
     * @ORM\OneToMany(targetEntity="PaiementValidation", mappedBy="qrCode",cascade={"persist"}, orphanRemoval=true)
    */
    private $paiements;

    /**
     * @ORM\OneToMany(targetEntity="Facture", mappedBy="qrCode",cascade={"persist"}, orphanRemoval=true)
    */
    private $factures;

    /**
     * @ORM\OneToMany(targetEntity="ReceptionTravaux", mappedBy="qrCode",cascade={"persist"}, orphanRemoval=true)
    */
    private $receptionTravaux;

    /**
     * @ORM\OneToMany(targetEntity="ProcesVerbal", mappedBy="qrCode",cascade={"persist"}, orphanRemoval=true)
    */
    private $pverbaux;    

    /**
     * @ORM\OneToMany(targetEntity="ImpotVerify", mappedBy="qrCode",cascade={"persist"}, orphanRemoval=true)
    */
    private $impotVerify;
    
    /**
     * @ORM\OneToMany(targetEntity="FactureSpontane", mappedBy="qrCode",cascade={"persist"}, orphanRemoval=true)
    */
    private $factureSpontane;

    /**
     * @ORM\OneToMany(targetEntity="FactureSimple", mappedBy="qrCode",cascade={"persist"}, orphanRemoval=true)
    */
    private $factureSimple;
    
    /**
     * @ORM\OneToMany(targetEntity="MTN", mappedBy="qrCode",cascade={"persist"}, orphanRemoval=true)
    */
    private $mtn;
    
    /**
     * @ORM\OneToMany(targetEntity="EnregistrementPm", mappedBy="qrCode",cascade={"persist"}, orphanRemoval=true)
    */
    private $enregistrementPm;
    
    /**
     * @ORM\OneToMany(targetEntity="FournisseurHabilite", mappedBy="qrCode",cascade={"persist"}, orphanRemoval=true)
    */
    private $fournisseurHabilite;
    
    /**
     * @ORM\OneToMany(targetEntity="Debour", mappedBy="qrCode",cascade={"persist"}, orphanRemoval=true)
    */
    private $debour;
    
    /**
     * @ORM\OneToMany(targetEntity="NoteAvoir", mappedBy="qrCode",cascade={"persist"}, orphanRemoval=true)
    */
    private $noteAvoir;
    
    /**
     * @ORM\OneToMany(targetEntity="EnregistrementPp", mappedBy="qrCode",cascade={"persist"}, orphanRemoval=true)
    */
    private $enregistrementPp;
    
    /**
     * @ORM\OneToMany(targetEntity="Moratoire", mappedBy="qrCode",cascade={"persist"}, orphanRemoval=true)
    */
    private $moratoire;
    
    /**
     * @ORM\OneToMany(targetEntity="Fine", mappedBy="transactionNumber",cascade={"persist"}, orphanRemoval=true)
    */
    private $fine;
    
    /**
     * @ORM\OneToMany(targetEntity="Service", mappedBy="transactionNumber",cascade={"persist"}, orphanRemoval=true)
    */
    private $service;
    
    /**
     * @ORM\OneToMany(targetEntity="Quittance", mappedBy="transactionNumber",cascade={"persist"}, orphanRemoval=true)
    */
    private $quittance;
    
    /**
     * @ORM\OneToMany(targetEntity="TvaHistory", mappedBy="qrCode",cascade={"persist"}, orphanRemoval=true)
    */
    private $tvaHistory;
    
    /**
     * @var \DateTime
     *
     * @ORM\Column(name="created_at", type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="updated_at", type="datetime")
     */
    private $updatedAt;

    /**
     * @var boolean
     *
     * @ORM\Column(name="status", type="boolean")
     */
    private $status;    

    public function __construct()
    {
        date_default_timezone_set( 'Africa/Douala' );
        $this->createdAt = new \Datetime();
        $this->updatedAt = new \Datetime();
        $this->status = 0;
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set libelle
     *
     * @param string $libelle
     *
     * @return ParkQr
     */
    public function setLibelle($libelle)
    {
        $this->libelle = $libelle;

        return $this;
    }

    /**
     * Get libelle
     *
     * @return string
     */
    public function getLibelle()
    {
        return $this->libelle;
    }

    /**
     * Set chemin
     *
     * @param string $chemin
     *
     * @return ParkQr
     */
    public function setChemin($chemin)
    {
        $this->chemin = $chemin;

        return $this;
    }

    /**
     * Get chemin
     *
     * @return string
     */
    public function getChemin()
    {
        return  $this->getUploadDir().'/'.$this->chemin;
    }

    /**
     * Get cheminC
     *
     * @return string
     */
    public function getCheminC()
    {
        return  $this->chemin;
    }

    /**
     * Set createdAt
     *
     * @param \DateTime $createdAt
     *
     * @return ParkQr
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Set updatedAt
     *
     * @param \DateTime $updatedAt
     *
     * @return ParkQr
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * Set status
     *
     * @param \DateTime $status
     *
     * @return ParkQr
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return \DateTime
     */
    public function getStatus()
    {
        return $this->status;
    }

    public function getUploadDir()
	{
		// Upload directory
		return 'qrcode';
		// This means /qrcode/documents/
    }

    public function getUploadRootDir()
	{
		// On retourne le chemin relatif vers l'image pour notre code PHP
		// Image location (PHP)
		return __DIR__.'/../../../../web/'.$this->getUploadDir();
	}


    /**
     * Set numero.
     *
     * @param string $numero
     *
     * @return ParkQr
     */
    public function setNumero($numero)
    {
        $this->numero = $numero;

        return $this;
    }

    /**
     * Get numero.
     *
     * @return string
     */
    public function getNumero()
    {
        return $this->numero;
    }


    /**
     * Add bonCommande
     *
     * @param \AMLA\SqrBundle\Entity\BonCommande $bonCommande
     *
     * @return CheckQr
     */
    public function addBonCommande(\AMLA\SqrBundle\Entity\BonCommande $bonCommande)
    {
        $this->bonCommandes[] = $bonCommande;

        return $this;
    }

    /**
     * Remove bonCommande
     *
     * @param \AMLA\SqrBundle\Entity\BonCommande $bonCommande
     */
    public function removeBonCommande(\AMLA\SqrBundle\Entity\BonCommande $bonCommande)
    {
        $this->bonCommandes->removeElement($bonCommande);
    }

    /**
     * Get bonCommandes
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getBonCommandes()
    {
        return $this->bonCommandes;
    }

    /**
     * Add attestation
     *
     * @param \AMLA\SqrBundle\Entity\AttestationVerification $attestation
     *
     * @return CheckQr
     */
    public function addAttestation(\AMLA\SqrBundle\Entity\AttestationVerification $attestation)
    {
        $this->attestations[] = $attestation;

        return $this;
    }

    /**
     * Remove attestation
     *
     * @param \AMLA\SqrBundle\Entity\AttestationVerification $attestation
     */
    public function removeAttestation(\AMLA\SqrBundle\Entity\AttestationVerification $attestation)
    {
        $this->attestations->removeElement($attestation);
    }

    /**
     * Get attestations
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAttestations()
    {
        return $this->attestations;
    }

    /**
     * Add paiement
     *
     * @param \AMLA\SqrBundle\Entity\PaiementValidation $paiement
     *
     * @return CheckQr
     */
    public function addPaiement(\AMLA\SqrBundle\Entity\PaiementValidation $paiement)
    {
        $this->paiements[] = $paiement;

        return $this;
    }

    /**
     * Remove paiement
     *
     * @param \AMLA\SqrBundle\Entity\PaiementValidation $paiement
     */
    public function removePaiement(\AMLA\SqrBundle\Entity\PaiementValidation $paiement)
    {
        $this->paiements->removeElement($paiement);
    }

    /**
     * Get paiements
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPaiements()
    {
        return $this->paiements;
    }

    /**
     * Add facture
     *
     * @param \AMLA\SqrBundle\Entity\Facture $facture
     *
     * @return CheckQr
     */
    public function addFacture(\AMLA\SqrBundle\Entity\Facture $facture)
    {
        $this->factures[] = $facture;

        return $this;
    }

    /**
     * Remove facture
     *
     * @param \AMLA\SqrBundle\Entity\Facture $facture
     */
    public function removeFacture(\AMLA\SqrBundle\Entity\Facture $facture)
    {
        $this->factures->removeElement($facture);
    }

    /**
     * Get factures
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFactures()
    {
        return $this->factures;
    }



    /**
     * Add pverbaux
     *
     * @param \AMLA\SqrBundle\Entity\ProcesVerbal $pverbaux
     *
     * @return CheckQr
     */
    public function addPverbaux(\AMLA\SqrBundle\Entity\ProcesVerbal $pverbaux)
    {
        $this->pverbaux[] = $pverbaux;

        return $this;
    }

    /**
     * Remove pverbaux
     *
     * @param \AMLA\SqrBundle\Entity\ProcesVerbal $pverbaux
     */
    public function removePverbaux(\AMLA\SqrBundle\Entity\ProcesVerbal $pverbaux)
    {
        $this->pverbaux->removeElement($pverbaux);
    }

    /**
     * Get pverbaux
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPverbaux()
    {
        return $this->pverbaux;
    }

    /**
     * Add atd
     *
     * @param \AMLA\SqrBundle\Entity\Atd $atd
     *
     * @return CheckQr
     */
    public function addAtd(\AMLA\SqrBundle\Entity\Atd $atd)
    {
        $this->atd[] = $atd;

        return $this;
    }

    /**
     * Remove atd
     *
     * @param \AMLA\SqrBundle\Entity\Atd $atd
     */
    public function removeAtd(\AMLA\SqrBundle\Entity\Atd $atd)
    {
        $this->atd->removeElement($atd);
    }

    /**
     * Get atd
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAtd()
    {
        return $this->atd;
    }

    /**
     * Add mouvementAtd
     *
     * @param \AMLA\SqrBundle\Entity\MouvementAtd $mouvementAtd
     *
     * @return CheckQr
     */
    public function addMouvementAtd(\AMLA\SqrBundle\Entity\MouvementAtd $mouvementAtd)
    {
        $this->mouvementAtd[] = $mouvementAtd;

        return $this;
    }

    /**
     * Remove mouvementAtd
     *
     * @param \AMLA\SqrBundle\Entity\MouvementAtd $mouvementAtd
     */
    public function removeMouvementAtd(\AMLA\SqrBundle\Entity\MouvementAtd $mouvementAtd)
    {
        $this->mouvementAtd->removeElement($mouvementAtd);
    }

    /**
     * Get mouvementAtd
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMouvementAtd()
    {
        return $this->mouvementAtd;
    }

    /**
     * Add receptionTravaux
     *
     * @param \AMLA\SqrBundle\Entity\ReceptionTravaux $receptionTravaux
     *
     * @return CheckQr
     */
    public function addReceptionTravaux(\AMLA\SqrBundle\Entity\ReceptionTravaux $receptionTravaux)
    {
        $this->receptionTravaux[] = $receptionTravaux;

        return $this;
    }

    /**
     * Remove receptionTravaux
     *
     * @param \AMLA\SqrBundle\Entity\ReceptionTravaux $receptionTravaux
     */
    public function removeReceptionTravaux(\AMLA\SqrBundle\Entity\ReceptionTravaux $receptionTravaux)
    {
        $this->receptionTravaux->removeElement($receptionTravaux);
    }

    /**
     * Get receptionTravaux
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getReceptionTravaux()
    {
        return $this->receptionTravaux;
    }

    /**
     * Add impotVerify
     *
     * @param \AMLA\SqrBundle\Entity\ImpotVerify $impotVerify
     *
     * @return CheckQr
     */
    public function addImpotVerify(\AMLA\SqrBundle\Entity\ImpotVerify $impotVerify)
    {
        $this->impotVerify[] = $impotVerify;

        return $this;
    }

    /**
     * Remove impotVerify
     *
     * @param \AMLA\SqrBundle\Entity\ImpotVerify $impotVerify
     */
    public function removeImpotVerify(\AMLA\SqrBundle\Entity\ImpotVerify $impotVerify)
    {
        $this->impotVerify->removeElement($impotVerify);
    }

    /**
     * Get impotVerify
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getImpotVerify()
    {
        return $this->impotVerify;
    }

    /**
     * Add factureSpontane
     *
     * @param \AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane
     *
     * @return CheckQr
     */
    public function addFactureSpontane(\AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane)
    {
        $this->factureSpontane[] = $factureSpontane;

        return $this;
    }

    /**
     * Remove factureSpontane
     *
     * @param \AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane
     */
    public function removeFactureSpontane(\AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane)
    {
        $this->factureSpontane->removeElement($factureSpontane);
    }

    /**
     * Get factureSpontane
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFactureSpontane()
    {
        return $this->factureSpontane;
    }

    /**
     * Add mtn
     *
     * @param \AMLA\SqrBundle\Entity\MTN $mtn
     *
     * @return CheckQr
     */
    public function addMtn(\AMLA\SqrBundle\Entity\MTN $mtn)
    {
        $this->mtn[] = $mtn;

        return $this;
    }

    /**
     * Remove mtn
     *
     * @param \AMLA\SqrBundle\Entity\MTN $mtn
     */
    public function removeMtn(\AMLA\SqrBundle\Entity\MTN $mtn)
    {
        $this->mtn->removeElement($mtn);
    }

    /**
     * Get mtn
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMtn()
    {
        return $this->mtn;
    }

    /**
     * Add enregistrementPm
     *
     * @param \AMLA\SqrBundle\Entity\EnregistrementPm $enregistrementPm
     *
     * @return CheckQr
     */
    public function addEnregistrementPm(\AMLA\SqrBundle\Entity\EnregistrementPm $enregistrementPm)
    {
        $this->enregistrementPm[] = $enregistrementPm;

        return $this;
    }

    /**
     * Remove enregistrementPm
     *
     * @param \AMLA\SqrBundle\Entity\EnregistrementPm $enregistrementPm
     */
    public function removeEnregistrementPm(\AMLA\SqrBundle\Entity\EnregistrementPm $enregistrementPm)
    {
        $this->enregistrementPm->removeElement($enregistrementPm);
    }

    /**
     * Get enregistrementPm
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getEnregistrementPm()
    {
        return $this->enregistrementPm;
    }

    /**
     * Add factureSimple
     *
     * @param \AMLA\SqrBundle\Entity\FactureSimple $factureSimple
     *
     * @return CheckQr
     */
    public function addFactureSimple(\AMLA\SqrBundle\Entity\FactureSimple $factureSimple)
    {
        $this->factureSimple[] = $factureSimple;

        return $this;
    }

    /**
     * Remove factureSimple
     *
     * @param \AMLA\SqrBundle\Entity\FactureSimple $factureSimple
     */
    public function removeFactureSimple(\AMLA\SqrBundle\Entity\FactureSimple $factureSimple)
    {
        $this->factureSimple->removeElement($factureSimple);
    }

    /**
     * Get factureSimple
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFactureSimple()
    {
        return $this->factureSimple;
    }

    /**
     * Add fournisseurHabilite
     *
     * @param \AMLA\SqrBundle\Entity\FournisseurHabilite $fournisseurHabilite
     *
     * @return CheckQr
     */
    public function addFournisseurHabilite(\AMLA\SqrBundle\Entity\FournisseurHabilite $fournisseurHabilite)
    {
        $this->fournisseurHabilite[] = $fournisseurHabilite;

        return $this;
    }

    /**
     * Remove fournisseurHabilite
     *
     * @param \AMLA\SqrBundle\Entity\FournisseurHabilite $fournisseurHabilite
     */
    public function removeFournisseurHabilite(\AMLA\SqrBundle\Entity\FournisseurHabilite $fournisseurHabilite)
    {
        $this->fournisseurHabilite->removeElement($fournisseurHabilite);
    }

    /**
     * Get fournisseurHabilite
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFournisseurHabilite()
    {
        return $this->fournisseurHabilite;
    }

    /**
     * Add debour
     *
     * @param \AMLA\SqrBundle\Entity\Debour $debour
     *
     * @return CheckQr
     */
    public function addDebour(\AMLA\SqrBundle\Entity\Debour $debour)
    {
        $this->debour[] = $debour;

        return $this;
    }

    /**
     * Remove debour
     *
     * @param \AMLA\SqrBundle\Entity\Debour $debour
     */
    public function removeDebour(\AMLA\SqrBundle\Entity\Debour $debour)
    {
        $this->debour->removeElement($debour);
    }

    /**
     * Get debour
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getDebour()
    {
        return $this->debour;
    }

    /**
     * Add noteAvoir
     *
     * @param \AMLA\SqrBundle\Entity\NoteAvoir $noteAvoir
     *
     * @return CheckQr
     */
    public function addNoteAvoir(\AMLA\SqrBundle\Entity\NoteAvoir $noteAvoir)
    {
        $this->noteAvoir[] = $noteAvoir;

        return $this;
    }

    /**
     * Remove noteAvoir
     *
     * @param \AMLA\SqrBundle\Entity\NoteAvoir $noteAvoir
     */
    public function removeNoteAvoir(\AMLA\SqrBundle\Entity\NoteAvoir $noteAvoir)
    {
        $this->noteAvoir->removeElement($noteAvoir);
    }

    /**
     * Get noteAvoir
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getNoteAvoir()
    {
        return $this->noteAvoir;
    }

    /**
     * Add enregistrementPp
     *
     * @param \AMLA\SqrBundle\Entity\EnregistrementPp $enregistrementPp
     *
     * @return CheckQr
     */
    public function addEnregistrementPp(\AMLA\SqrBundle\Entity\EnregistrementPp $enregistrementPp)
    {
        $this->enregistrementPp[] = $enregistrementPp;

        return $this;
    }

    /**
     * Remove enregistrementPp
     *
     * @param \AMLA\SqrBundle\Entity\EnregistrementPp $enregistrementPp
     */
    public function removeEnregistrementPp(\AMLA\SqrBundle\Entity\EnregistrementPp $enregistrementPp)
    {
        $this->enregistrementPp->removeElement($enregistrementPp);
    }

    /**
     * Get enregistrementPp
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getEnregistrementPp()
    {
        return $this->enregistrementPp;
    }

    /**
     * Add moratoire
     *
     * @param \AMLA\SqrBundle\Entity\Moratoire $moratoire
     *
     * @return CheckQr
     */
    public function addMoratoire(\AMLA\SqrBundle\Entity\Moratoire $moratoire)
    {
        $this->moratoire[] = $moratoire;

        return $this;
    }

    /**
     * Remove moratoire
     *
     * @param \AMLA\SqrBundle\Entity\Moratoire $moratoire
     */
    public function removeMoratoire(\AMLA\SqrBundle\Entity\Moratoire $moratoire)
    {
        $this->moratoire->removeElement($moratoire);
    }

    /**
     * Get moratoire
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMoratoire()
    {
        return $this->moratoire;
    }

    /**
     * Add fine
     *
     * @param \AMLA\SqrBundle\Entity\Fine $fine
     *
     * @return CheckQr
     */
    public function addFine(\AMLA\SqrBundle\Entity\Fine $fine)
    {
        $this->fine[] = $fine;

        return $this;
    }

    /**
     * Remove fine
     *
     * @param \AMLA\SqrBundle\Entity\Fine $fine
     */
    public function removeFine(\AMLA\SqrBundle\Entity\Fine $fine)
    {
        $this->fine->removeElement($fine);
    }

    /**
     * Get fine
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFine()
    {
        return $this->fine;
    }

    /**
     * Add service
     *
     * @param \AMLA\SqrBundle\Entity\Service $service
     *
     * @return CheckQr
     */
    public function addService(\AMLA\SqrBundle\Entity\Service $service)
    {
        $this->service[] = $service;

        return $this;
    }

    /**
     * Remove service
     *
     * @param \AMLA\SqrBundle\Entity\Service $service
     */
    public function removeService(\AMLA\SqrBundle\Entity\Service $service)
    {
        $this->service->removeElement($service);
    }

    /**
     * Get service
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getService()
    {
        return $this->service;
    }

    /**
     * Add quittance
     *
     * @param \AMLA\SqrBundle\Entity\Quittance $quittance
     *
     * @return CheckQr
     */
    public function addQuittance(\AMLA\SqrBundle\Entity\Quittance $quittance)
    {
        $this->quittance[] = $quittance;

        return $this;
    }

    /**
     * Remove quittance
     *
     * @param \AMLA\SqrBundle\Entity\Quittance $quittance
     */
    public function removeQuittance(\AMLA\SqrBundle\Entity\Quittance $quittance)
    {
        $this->quittance->removeElement($quittance);
    }

    /**
     * Get quittance
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getQuittance()
    {
        return $this->quittance;
    }
}
