<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * CelluleEnregistrement
 *
 * @ORM\Table(name="cellule_enregistrement")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\CelluleEnregistrementRepository")
 */
class CelluleEnregistrement
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="code", type="string", length=255)
     */
    private $code;

    /**
     * @var string
     *
     * @ORM\Column(name="idunitegestion", type="string", length=255)
     */
    private $idunitegestion;

    /**
     * @var string
     *
     * @ORM\Column(name="libelle", type="string", length=255)
     */
    private $libelle;

    /**
     * @ORM\OneToMany(targetEntity="Contrat", mappedBy="idCelluleEnregistrement")
     */
    private $contrat;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set code
     *
     * @param string $code
     *
     * @return CelluleEnregistrement
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * Get code
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set idunitegestion
     *
     * @param string $idunitegestion
     *
     * @return CelluleEnregistrement
     */
    public function setIdunitegestion($idunitegestion)
    {
        $this->idunitegestion = $idunitegestion;

        return $this;
    }

    /**
     * Get idunitegestion
     *
     * @return string
     */
    public function getIdunitegestion()
    {
        return $this->idunitegestion;
    }

    /**
     * Set libelle
     *
     * @param string $libelle
     *
     * @return CelluleEnregistrement
     */
    public function setLibelle($libelle)
    {
        $this->libelle = $libelle;

        return $this;
    }

    /**
     * Get libelle
     *
     * @return string
     */
    public function getLibelle()
    {
        return $this->libelle;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->contrat = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Add contrat
     *
     * @param \AMLA\SqrBundle\Entity\Contrat $contrat
     *
     * @return CelluleEnregistrement
     */
    public function addContrat(\AMLA\SqrBundle\Entity\Contrat $contrat)
    {
        $this->contrat[] = $contrat;

        return $this;
    }

    /**
     * Remove contrat
     *
     * @param \AMLA\SqrBundle\Entity\Contrat $contrat
     */
    public function removeContrat(\AMLA\SqrBundle\Entity\Contrat $contrat)
    {
        $this->contrat->removeElement($contrat);
    }

    /**
     * Get contrat
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getContrat()
    {
        return $this->contrat;
    }
}
