<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Caution
 *
 * @ORM\Table(name="caution")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\CautionRepository")
 */
class Caution
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="pj", type="string", length=255)
     */
    private $pj;

    /**
     * @ORM\ManyToOne(targetEntity="Account", inversedBy="caution")
     * @ORM\JoinColumn(name="account_id", referencedColumnName="id")
     */
    private $account;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateDebutCaution", type="datetime")
     */
    private $dateDebutCaution;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateFinCaution", type="datetime")
     */
    private $dateFinCaution;

    /**
     * @var float
     *
     * @ORM\Column(name="montantCaution", type="float")
     */
    private $montantCaution;

    /**
     * @var string
     *
     * @ORM\Column(name="typeCaution", type="string", length=255)
     */
    private $typeCaution;

    /**
     * @var string
     *
     * @ORM\Column(name="contenuNumeric", type="text")
     */
    private $contenuNumeric;

    /**
     * @var string
     *
     * @ORM\Column(name="reference_marche", type="string", length=255)
     */
    private $referenceMarche;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set pj
     *
     * @param string $pj
     *
     * @return Caution
     */
    public function setPj($pj)
    {
        $this->pj = $pj;

        return $this;
    }

    /**
     * Get pj
     *
     * @return string
     */
    public function getPj()
    {
        return $this->pj;
    }

    /**
     * Set dateDebutCaution
     *
     * @param \DateTime $dateDebutCaution
     *
     * @return Caution
     */
    public function setDateDebutCaution($dateDebutCaution)
    {
        $this->dateDebutCaution = $dateDebutCaution;

        return $this;
    }

    /**
     * Get dateDebutCaution
     *
     * @return \DateTime
     */
    public function getDateDebutCaution()
    {
        return $this->dateDebutCaution;
    }

    /**
     * Set dateFinCaution
     *
     * @param \DateTime $dateFinCaution
     *
     * @return Caution
     */
    public function setDateFinCaution($dateFinCaution)
    {
        $this->dateFinCaution = $dateFinCaution;

        return $this;
    }

    /**
     * Get dateFinCaution
     *
     * @return \DateTime
     */
    public function getDateFinCaution()
    {
        return $this->dateFinCaution;
    }

    /**
     * Set montantCaution
     *
     * @param float $montantCaution
     *
     * @return Caution
     */
    public function setMontantCaution($montantCaution)
    {
        $this->montantCaution = $montantCaution;

        return $this;
    }

    /**
     * Get montantCaution
     *
     * @return float
     */
    public function getMontantCaution()
    {
        return $this->montantCaution;
    }

    /**
     * Set typeCaution
     *
     * @param string $typeCaution
     *
     * @return Caution
     */
    public function setTypeCaution($typeCaution)
    {
        $this->typeCaution = $typeCaution;

        return $this;
    }

    /**
     * Get typeCaution
     *
     * @return string
     */
    public function getTypeCaution()
    {
        return $this->typeCaution;
    }

    /**
     * Set contenuNumeric
     *
     * @param string $contenuNumeric
     *
     * @return Caution
     */
    public function setContenuNumeric($contenuNumeric)
    {
        $this->contenuNumeric = $contenuNumeric;

        return $this;
    }

    /**
     * Get contenuNumeric
     *
     * @return string
     */
    public function getContenuNumeric()
    {
        return $this->contenuNumeric;
    }

    /**
     * Set reference
     *
     * @param string $reference
     *
     * @return Caution
     */
    public function setReference($reference)
    {
        $this->reference = $reference;

        return $this;
    }

    /**
     * Get reference
     *
     * @return string
     */
    public function getReference()
    {
        return $this->reference;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return Caution
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set account
     *
     * @param \AMLA\SqrBundle\Entity\Account $account
     *
     * @return Caution
     */
    public function setAccount(\AMLA\SqrBundle\Entity\Account $account = null)
    {
        $this->account = $account;

        return $this;
    }

    /**
     * Get account
     *
     * @return \AMLA\SqrBundle\Entity\Account
     */
    public function getAccount()
    {
        return $this->account;
    }

    /**
     * Set referenceMarche
     *
     * @param string $referenceMarche
     *
     * @return Caution
     */
    public function setReferenceMarche($referenceMarche)
    {
        $this->referenceMarche = $referenceMarche;

        return $this;
    }

    /**
     * Get referenceMarche
     *
     * @return string
     */
    public function getReferenceMarche()
    {
        return $this->referenceMarche;
    }
}
