<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * BonCommande
 *
 * @ORM\Table(name="bon_commande")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\BonCommandeRepository")
 */
class BonCommande
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="reference", type="string", length=255)
     */
    private $reference;

    /**
     * @ORM\ManyToOne(targetEntity="SoummissionOffre", inversedBy="bonCommande")
     * @ORM\JoinColumn(name="soummision_offre_id", referencedColumnName="id")
     */
    private $soummissionOffre;

    /**
     * @ORM\ManyToOne(targetEntity="CheckQr", inversedBy="bonCommandes")
     * @ORM\JoinColumn(name="qrcode_id", referencedColumnName="id")
     */
    private $qrCode;

    /**
     * @var int
     *
     * @ORM\Column(name="prix_cautionnement", type="integer")
     */
    private $prixCautionnement;

    /**
     * @var int
     *
     * @ORM\Column(name="montant", type="integer")
     */
    private $montant;

    /**
     * @var int
     *
     * @ORM\Column(name="reste_paye", type="integer")
     */
    private $restePaye;

    /**
     * @var int
     *
     * @ORM\Column(name="taux_recu", type="integer")
     */
    private $tauxRecu;

    /**
     * @var int
     *
     * @ORM\Column(name="retenue_garantie", type="integer")
     */
    private $retenueGarantie;

    /**
     * @var boolean
     *
     * @ORM\Column(name="statut", type="smallint")
     * {0 = en cours, 1 = cloturé}
     */
    private $statut;

    /**
     * @var boolean
     *
     * @ORM\Column(name="cautionnement", type="smallint")
     */
    private $cautionnement;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    /**
     * @ORM\OneToMany(targetEntity="ReceptionTravaux", mappedBy="bonCommande")
     */
    private $receptiontravaux;

    /**
     * @ORM\OneToMany(targetEntity="HistoriqueTravaux", mappedBy="bonCommande")
     */
    private $historiquetravaux;

    /**
     * @ORM\OneToMany(targetEntity="ProcesVerbal", mappedBy="bonCommande")
     */
    private $procesVerbal;

    /**
     * @ORM\OneToMany(targetEntity="CertificatAvancement", mappedBy="bonCommande")
     */
    private $certificatAvance;
    
    /**
     * @ORM\OneToMany(targetEntity="CertificatReception", mappedBy="bonCommande")
     */
    private $certificatRecept;
    
    /**
     * Constructor
     */
    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->statut = 1;// 1=crée; 0=Cloturé
        $this->reference = 'BC_'.$this->randomString();
        $this->tauxRecu= 0;
    }

    /*
     * Create a random string
     * @author	Cedric Rio
     * @param $length the length of the string to create
     * @return $str the string
     */
    function randomString($length = 3)
    {
        $str = "";
        //$characters = array_merge(range('A','Z'), range('a','z'), range('0','9'));
        $characters = array_merge(range('A','Z'), range('0','9'));
        $max = count($characters) - 1;

        date_default_timezone_set('Africa/Douala');
        $date = date('hiy', time());

        for ($i = 0; $i < $length; $i++)
        {
            $rand = mt_rand(0, $max);
            $str .= $characters[$rand];
        }
        $codeUnique=$str.''.$date;
        return $codeUnique;
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }


    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return BonCommande
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return BonCommande
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return integer
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set soummissionOffre
     *
     * @param \AMLA\SqrBundle\Entity\SoummissionOffre $soummissionOffre
     *
     * @return BonCommande
     */
    public function setSoummissionOffre(\AMLA\SqrBundle\Entity\SoummissionOffre $soummissionOffre = null)
    {
        $this->soummissionOffre = $soummissionOffre;

        return $this;
    }

    /**
     * Get soummissionOffre
     *
     * @return \AMLA\SqrBundle\Entity\SoummissionOffre
     */
    public function getSoummissionOffre()
    {
        return $this->soummissionOffre;
    }

    /**
     * Add receptiontravaux
     *
     * @param \AMLA\SqrBundle\Entity\ReceptionTravaux $receptiontravaux
     *
     * @return BonCommande
     */
    public function addReceptiontravaux(\AMLA\SqrBundle\Entity\ReceptionTravaux $receptiontravaux)
    {
        $this->receptiontravaux[] = $receptiontravaux;

        return $this;
    }

    /**
     * Remove receptiontravaux
     *
     * @param \AMLA\SqrBundle\Entity\ReceptionTravaux $receptiontravaux
     */
    public function removeReceptiontravaux(\AMLA\SqrBundle\Entity\ReceptionTravaux $receptiontravaux)
    {
        $this->receptiontravaux->removeElement($receptiontravaux);
    }

    /**
     * Get receptiontravaux
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getReceptiontravaux()
    {
        return $this->receptiontravaux;
    }

    /**
     * Set reference
     *
     * @param string $reference
     *
     * @return BonCommande
     */
    public function setReference($reference)
    {
        $this->reference = $reference;

        return $this;
    }

    /**
     * Get reference
     *
     * @return string
     */
    public function getReference()
    {
        return $this->reference;
    }

    /**
     * Add historiquetravaux
     *
     * @param \AMLA\SqrBundle\Entity\HistoriqueTravaux $historiquetravaux
     *
     * @return BonCommande
     */
    public function addHistoriquetravaux(\AMLA\SqrBundle\Entity\HistoriqueTravaux $historiquetravaux)
    {
        $this->historiquetravaux[] = $historiquetravaux;

        return $this;
    }

    /**
     * Remove historiquetravaux
     *
     * @param \AMLA\SqrBundle\Entity\HistoriqueTravaux $historiquetravaux
     */
    public function removeHistoriquetravaux(\AMLA\SqrBundle\Entity\HistoriqueTravaux $historiquetravaux)
    {
        $this->historiquetravaux->removeElement($historiquetravaux);
    }

    /**
     * Get historiquetravaux
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getHistoriquetravaux()
    {
        return $this->historiquetravaux;
    }

    /**
     * Add procesVerbal
     *
     * @param \AMLA\SqrBundle\Entity\ProcesVerbal $procesVerbal
     *
     * @return BonCommande
     */
    public function addProcesVerbal(\AMLA\SqrBundle\Entity\ProcesVerbal $procesVerbal)
    {
        $this->procesVerbal[] = $procesVerbal;

        return $this;
    }

    /**
     * Remove procesVerbal
     *
     * @param \AMLA\SqrBundle\Entity\ProcesVerbal $procesVerbal
     */
    public function removeProcesVerbal(\AMLA\SqrBundle\Entity\ProcesVerbal $procesVerbal)
    {
        $this->procesVerbal->removeElement($procesVerbal);
    }

    /**
     * Get procesVerbal
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getProcesVerbal()
    {
        return $this->procesVerbal;
    }

    /**
     * Add certificatAvance
     *
     * @param \AMLA\SqrBundle\Entity\CertificatAvancement $certificatAvance
     *
     * @return BonCommande
     */
    public function addCertificatAvance(\AMLA\SqrBundle\Entity\CertificatAvancement $certificatAvance)
    {
        $this->certificatAvance[] = $certificatAvance;

        return $this;
    }

    /**
     * Remove certificatAvance
     *
     * @param \AMLA\SqrBundle\Entity\CertificatAvancement $certificatAvance
     */
    public function removeCertificatAvance(\AMLA\SqrBundle\Entity\CertificatAvancement $certificatAvance)
    {
        $this->certificatAvance->removeElement($certificatAvance);
    }

    /**
     * Get certificatAvance
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getCertificatAvance()
    {
        return $this->certificatAvance;
    }

    /**
     * Add attestationVerif
     *
     * @param \AMLA\SqrBundle\Entity\AttestationVerification $attestationVerif
     *
     * @return BonCommande
     */
    public function addAttestationVerif(\AMLA\SqrBundle\Entity\AttestationVerification $attestationVerif)
    {
        $this->attestationVerif[] = $attestationVerif;

        return $this;
    }

    /**
     * Remove attestationVerif
     *
     * @param \AMLA\SqrBundle\Entity\AttestationVerification $attestationVerif
     */
    public function removeAttestationVerif(\AMLA\SqrBundle\Entity\AttestationVerification $attestationVerif)
    {
        $this->attestationVerif->removeElement($attestationVerif);
    }

    /**
     * Get attestationVerif
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAttestationVerif()
    {
        return $this->attestationVerif;
    }

    /**
     * Add certificatRecept
     *
     * @param \AMLA\SqrBundle\Entity\CertificatReception $certificatRecept
     *
     * @return BonCommande
     */
    public function addCertificatRecept(\AMLA\SqrBundle\Entity\CertificatReception $certificatRecept)
    {
        $this->certificatRecept[] = $certificatRecept;

        return $this;
    }

    /**
     * Remove certificatRecept
     *
     * @param \AMLA\SqrBundle\Entity\CertificatReception $certificatRecept
     */
    public function removeCertificatRecept(\AMLA\SqrBundle\Entity\CertificatReception $certificatRecept)
    {
        $this->certificatRecept->removeElement($certificatRecept);
    }

    /**
     * Get certificatRecept
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getCertificatRecept()
    {
        return $this->certificatRecept;
    }

    /**
     * Add facture
     *
     * @param \AMLA\SqrBundle\Entity\Facture $facture
     *
     * @return BonCommande
     */
    public function addFacture(\AMLA\SqrBundle\Entity\Facture $facture)
    {
        $this->facture[] = $facture;

        return $this;
    }

    /**
     * Remove facture
     *
     * @param \AMLA\SqrBundle\Entity\Facture $facture
     */
    public function removeFacture(\AMLA\SqrBundle\Entity\Facture $facture)
    {
        $this->facture->removeElement($facture);
    }

    /**
     * Get facture
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFacture()
    {
        return $this->facture;
    }

    /**
     * Set cautionnement
     *
     * @param integer $cautionnement
     *
     * @return BonCommande
     */
    public function setCautionnement($cautionnement)
    {
        $this->cautionnement = $cautionnement;

        return $this;
    }

    /**
     * Get cautionnement
     *
     * @return integer
     */
    public function getCautionnement()
    {
        return $this->cautionnement;
    }

    /**
     * Set prixCautionnement
     *
     * @param integer $prixCautionnement
     *
     * @return BonCommande
     */
    public function setPrixCautionnement($prixCautionnement)
    {
        $this->prixCautionnement = $prixCautionnement;

        return $this;
    }

    /**
     * Get prixCautionnement
     *
     * @return integer
     */
    public function getPrixCautionnement()
    {
        return $this->prixCautionnement;
    }

    /**
     * Set retenueGaranti
     *
     * @param integer $retenueGaranti
     *
     * @return BonCommande
     */
    public function setRetenueGaranti($retenueGaranti)
    {
        $this->retenueGaranti = $retenueGaranti;

        return $this;
    }

    /**
     * Get retenueGaranti
     *
     * @return integer
     */
    public function getRetenueGaranti()
    {
        return $this->retenueGaranti;
    }

    /**
     * Set retenueGarantie
     *
     * @param integer $retenueGarantie
     *
     * @return BonCommande
     */
    public function setRetenueGarantie($retenueGarantie)
    {
        $this->retenueGarantie = $retenueGarantie;

        return $this;
    }

    /**
     * Get retenueGarantie
     *
     * @return integer
     */
    public function getRetenueGarantie()
    {
        return $this->retenueGarantie;
    }

    /**
     * Add document
     *
     * @param \AMLA\SqrBundle\Entity\Document $document
     *
     * @return BonCommande
     */
    public function addDocument(\AMLA\SqrBundle\Entity\Document $document)
    {
        $this->documents[] = $document;

        return $this;
    }

    /**
     * Remove document
     *
     * @param \AMLA\SqrBundle\Entity\Document $document
     */
    public function removeDocument(\AMLA\SqrBundle\Entity\Document $document)
    {
        $this->documents->removeElement($document);
    }

    /**
     * Get documents
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getDocuments()
    {
        return $this->documents;
    }

    /**
     * Set montant
     *
     * @param integer $montant
     *
     * @return BonCommande
     */
    public function setMontant($montant)
    {
        $this->montant = $montant;

        return $this;
    }

    /**
     * Get montant
     *
     * @return integer
     */
    public function getMontant()
    {
        return $this->montant;
    }

    /**
     * Set cumulPaye
     *
     * @param integer $cumulPaye
     *
     * @return BonCommande
     */
    public function setCumulPaye($cumulPaye)
    {
        $this->cumulPaye = $cumulPaye;

        return $this;
    }

    /**
     * Get cumulPaye
     *
     * @return integer
     */
    public function getCumulPaye()
    {
        return $this->cumulPaye;
    }

    /**
     * Set restePaye
     *
     * @param integer $restePaye
     *
     * @return BonCommande
     */
    public function setRestePaye($restePaye)
    {
        $this->restePaye = $restePaye;

        return $this;
    }

    /**
     * Get restePaye
     *
     * @return integer
     */
    public function getRestePaye()
    {
        return $this->restePaye;
    }

    /**
     * Set qrCode
     *
     * @param \AMLA\SqrBundle\Entity\CheckQr $qrCode
     *
     * @return BonCommande
     */
    public function setQrCode(\AMLA\SqrBundle\Entity\CheckQr $qrCode = null)
    {
        $this->qrCode = $qrCode;

        return $this;
    }

    /**
     * Get qrCode
     *
     * @return \AMLA\SqrBundle\Entity\CheckQr
     */
    public function getQrCode()
    {
        return $this->qrCode;
    }

    /**
     * Set resteReceptionner
     *
     * @param integer $resteReceptionner
     *
     * @return BonCommande
     */
    public function setResteReceptionner($resteReceptionner)
    {
        $this->resteReceptionner = $resteReceptionner;

        return $this;
    }

    /**
     * Get resteReceptionner
     *
     * @return integer
     */
    public function getResteReceptionner()
    {
        return $this->resteReceptionner;
    }

    /**
     * Set tauxRecu
     *
     * @param integer $tauxRecu
     *
     * @return BonCommande
     */
    public function setTauxRecu($tauxRecu)
    {
        $this->tauxRecu = $tauxRecu;

        return $this;
    }

    /**
     * Get tauxRecu
     *
     * @return integer
     */
    public function getTauxRecu()
    {
        return $this->tauxRecu;
    }
}
