<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * BanqueAssocie
 *
 * @ORM\Table(name="banque_associe")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\BanqueAssocieRepository")
 */
class BanqueAssocie
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="code_banque", type="string", length=20)
     */
    private $codeBanque;

    /**
     * @var string
     *
     * @ORM\Column(name="code_guichet", type="string", length=20)
     */
    private $codeGuichet;

    /**
     * @var string
     *
     * @ORM\Column(name="numero_compte", type="string", length=50)
     */
    private $numeroCompte;

    /**
     * @var string
     *
     * @ORM\Column(name="cle_rib", type="string", length=10)
     */
    private $cleRib;

    /**
     * @var string
     *
     * @ORM\Column(name="numero_iban", type="string", length=255)
     */
    private $numeroIban;

    /**
     * @var string
     *
     * @ORM\Column(name="code_swift", type="string", length=255)
     */
    private $codeSwift;

    /**
     * @ORM\ManyToOne(targetEntity="InstitutionBancaire", inversedBy="banqueAssocie")
     * @ORM\JoinColumn(name="institution_bancaire_id", referencedColumnName="id")
     */
    private $institutionBancaire;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    /**
     * @var boolean
     *
     * @ORM\Column(name="statut", type="smallint")
     */
    private $statut;

    /**
     * @ORM\OneToMany(targetEntity="FournisseurBanque", mappedBy="banque")
     */
    private $fournisseurbanque;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->statut = 0;
    }


    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set codeBanque
     *
     * @param string $codeBanque
     *
     * @return BanqueAssocie
     */
    public function setCodeBanque($codeBanque)
    {
        $this->codeBanque = $codeBanque;

        return $this;
    }

    /**
     * Get codeBanque
     *
     * @return string
     */
    public function getCodeBanque()
    {
        return $this->codeBanque;
    }

    /**
     * Set codeGuichet
     *
     * @param string $codeGuichet
     *
     * @return BanqueAssocie
     */
    public function setCodeGuichet($codeGuichet)
    {
        $this->codeGuichet = $codeGuichet;

        return $this;
    }

    /**
     * Get codeGuichet
     *
     * @return string
     */
    public function getCodeGuichet()
    {
        return $this->codeGuichet;
    }

    /**
     * Set numeroCompte
     *
     * @param string $numeroCompte
     *
     * @return BanqueAssocie
     */
    public function setNumeroCompte($numeroCompte)
    {
        $this->numeroCompte = $numeroCompte;

        return $this;
    }

    /**
     * Get numeroCompte
     *
     * @return string
     */
    public function getNumeroCompte()
    {
        return $this->numeroCompte;
    }

    /**
     * Set cleRib
     *
     * @param string $cleRib
     *
     * @return BanqueAssocie
     */
    public function setCleRib($cleRib)
    {
        $this->cleRib = $cleRib;

        return $this;
    }

    /**
     * Get cleRib
     *
     * @return string
     */
    public function getCleRib()
    {
        return $this->cleRib;
    }

    /**
     * Set numeroIban
     *
     * @param string $numeroIban
     *
     * @return BanqueAssocie
     */
    public function setNumeroIban($numeroIban)
    {
        $this->numeroIban = $numeroIban;

        return $this;
    }

    /**
     * Get numeroIban
     *
     * @return string
     */
    public function getNumeroIban()
    {
        return $this->numeroIban;
    }

    /**
     * Set codeSwift
     *
     * @param string $codeSwift
     *
     * @return BanqueAssocie
     */
    public function setCodeSwift($codeSwift)
    {
        $this->codeSwift = $codeSwift;

        return $this;
    }

    /**
     * Get codeSwift
     *
     * @return string
     */
    public function getCodeSwift()
    {
        return $this->codeSwift;
    }

    /**
     * Set fournisseur
     *
     * @param integer $fournisseur
     *
     * @return BanqueAssocie
     */
    public function setFournisseur($fournisseur)
    {
        $this->fournisseur = $fournisseur;

        return $this;
    }

    /**
     * Get fournisseur
     *
     * @return integer
     */
    public function getFournisseur()
    {
        return $this->fournisseur;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return BanqueAssocie
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set institutionBancaire
     *
     * @param \AMLA\SqrBundle\Entity\InstitutionBancaire $institutionBancaire
     *
     * @return BanqueAssocie
     */
    public function setInstitutionBancaire(\AMLA\SqrBundle\Entity\InstitutionBancaire $institutionBancaire = null)
    {
        $this->institutionBancaire = $institutionBancaire;

        return $this;
    }

    /**
     * Get institutionBancaire
     *
     * @return \AMLA\SqrBundle\Entity\InstitutionBancaire
     */
    public function getInstitutionBancaire()
    {
        return $this->institutionBancaire;
    }

    /**
     * Add fournisseurbanque
     *
     * @param \AMLA\SqrBundle\Entity\FournisseurBanque $fournisseurbanque
     *
     * @return BanqueAssocie
     */
    public function addFournisseurbanque(\AMLA\SqrBundle\Entity\FournisseurBanque $fournisseurbanque)
    {
        $this->fournisseurbanque[] = $fournisseurbanque;

        return $this;
    }

    /**
     * Remove fournisseurbanque
     *
     * @param \AMLA\SqrBundle\Entity\FournisseurBanque $fournisseurbanque
     */
    public function removeFournisseurbanque(\AMLA\SqrBundle\Entity\FournisseurBanque $fournisseurbanque)
    {
        $this->fournisseurbanque->removeElement($fournisseurbanque);
    }

    /**
     * Get fournisseurbanque
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFournisseurbanque()
    {
        return $this->fournisseurbanque;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return BanqueAssocie
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return integer
     */
    public function getStatut()
    {
        return $this->statut;
    }
}
