<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AttestationVerification
 *
 * @ORM\Table(name="attestation_verification")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\AttestationVerificationRepository")
 */
class AttestationVerification
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\OneToMany(targetEntity="Attestation", mappedBy="attestationVerif")
     */
    private $attestation;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="attestationVerif")
     * @ORM\JoinColumn(name="fournisseur_id", referencedColumnName="id")
     */
    private $fournisseur;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="attestationVerifV")
     * @ORM\JoinColumn(name="verificateur_id", referencedColumnName="id")
     */
    private $verificateur;

    /**
     * @ORM\ManyToOne(targetEntity="CheckQr", inversedBy="attestations")
     * @ORM\JoinColumn(name="qrcode_id", referencedColumnName="id")
     */
    private $qrCode;
    
    /**
     * @var string
     *
     * @ORM\Column(name="pdf", type="string", length=150, nullable=true)
     */
    private $pdf;

    /**
     * @var string
     *
     * @ORM\Column(name="reference", type="string", length=255)
     */
    private $reference;

    /**
     * @var int
     *
     * @ORM\Column(name="statut", type="smallint")
     */
    private $statut;
    

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->statut = 0;
        $this->reference = 'ATTES_VERIF_'.$this->randomString();
    }



     /*
     * Create a random string
     * @author	Cedric Rio
     * @param $length the length of the string to create
     * @return $str the string
     */
    function randomString($length = 3)
    {
        $str = "";
        //$characters = array_merge(range('A','Z'), range('a','z'), range('0','9'));
        $characters = array_merge(range('A','Z'), range('0','9'));
        $max = count($characters) - 1;

        date_default_timezone_set('Africa/Douala');
        $date = date('hiy', time());

        for ($i = 0; $i < $length; $i++)
        {
            $rand = mt_rand(0, $max);
            $str .= $characters[$rand];
        }
        $codeUnique=$str.''.$date;
        return $codeUnique;
    }
    
    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set reference
     *
     * @param string $reference
     *
     * @return AttestationVerification
     */
    public function setReference($reference)
    {
        $this->reference = $reference;

        return $this;
    }

    /**
     * Get reference
     *
     * @return string
     */
    public function getReference()
    {
        return $this->reference;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return AttestationVerification
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return int
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return AttestationVerification
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set bonCommande
     *
     * @param \AMLA\SqrBundle\Entity\BonCommande $bonCommande
     *
     * @return AttestationVerification
     */
    public function setBonCommande(\AMLA\SqrBundle\Entity\BonCommande $bonCommande = null)
    {
        $this->bonCommande = $bonCommande;

        return $this;
    }

    /**
     * Get bonCommande
     *
     * @return \AMLA\SqrBundle\Entity\BonCommande
     */
    public function getBonCommande()
    {
        return $this->bonCommande;
    }

    /**
     * Set attestation
     *
     * @param \AMLA\SqrBundle\Entity\Attestation $attestation
     *
     * @return AttestationVerification
     */
    public function setAttestation(\AMLA\SqrBundle\Entity\Attestation $attestation = null)
    {
        $this->attestation = $attestation;

        return $this;
    }

    /**
     * Get attestation
     *
     * @return \AMLA\SqrBundle\Entity\Attestation
     */
    public function getAttestation()
    {
        return $this->attestation;
    }

    /**
     * Add attestation
     *
     * @param \AMLA\SqrBundle\Entity\Attestation $attestation
     *
     * @return AttestationVerification
     */
    public function addAttestation(\AMLA\SqrBundle\Entity\Attestation $attestation)
    {
        $this->attestation[] = $attestation;

        return $this;
    }

    /**
     * Remove attestation
     *
     * @param \AMLA\SqrBundle\Entity\Attestation $attestation
     */
    public function removeAttestation(\AMLA\SqrBundle\Entity\Attestation $attestation)
    {
        $this->attestation->removeElement($attestation);
    }

    /**
     * Set fournisseur
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseur
     *
     * @return AttestationVerification
     */
    public function setFournisseur(\AMLA\SqrBundle\Entity\Fournissseur $fournisseur = null)
    {
        $this->fournisseur = $fournisseur;

        return $this;
    }

    /**
     * Get fournisseur
     *
     * @return \AMLA\SqrBundle\Entity\Fournissseur
     */
    public function getFournisseur()
    {
        return $this->fournisseur;
    }

    /**
     * Set verificateur
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $verificateur
     *
     * @return AttestationVerification
     */
    public function setVerificateur(\AMLA\SqrBundle\Entity\Fournissseur $verificateur = null)
    {
        $this->verificateur = $verificateur;

        return $this;
    }

    /**
     * Get verificateur
     *
     * @return \AMLA\SqrBundle\Entity\Fournissseur
     */
    public function getVerificateur()
    {
        return $this->verificateur;
    }

    /**
     * Set qrCode
     *
     * @param \AMLA\SqrBundle\Entity\CheckQr $qrCode
     *
     * @return AttestationVerification
     */
    public function setQrCode(\AMLA\SqrBundle\Entity\CheckQr $qrCode = null)
    {
        $this->qrCode = $qrCode;

        return $this;
    }

    /**
     * Get qrCode
     *
     * @return \AMLA\SqrBundle\Entity\CheckQr
     */
    public function getQrCode()
    {
        return $this->qrCode;
    }

    /**
     * Set pdf
     *
     * @param string $pdf
     *
     * @return AttestationVerification
     */
    public function setPdf($pdf)
    {
        $this->pdf = $pdf;

        return $this;
    }

    /**
     * Get pdf
     *
     * @return string
     */
    public function getPdf()
    {
        return $this->pdf;
    }
}
