<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Attestation
 *
 * @ORM\Table(name="attestation")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\AttestationRepository")
 */
class Attestation
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;


    /**
     * @var string
     *
     * @ORM\Column(name="path", type="string", length=255)
     */
    private $path;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255)
     */
    private $name;

    /**
     * @var int
     *
     * @ORM\Column(name="size", type="integer")
     */
    private $size;

    /**
     * @var string
     *
     * @ORM\Column(name="thumb", type="string", length=255)
     */
    private $thumb;

    /**
     * @ORM\ManyToOne(targetEntity="AttestationVerification", inversedBy="attestation")
     * @ORM\JoinColumn(name="attestation_verification_id", referencedColumnName="id")
     */
    private $attestationVerif;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->statut = 0;
        $this->attestationVerif = new \Doctrine\Common\Collections\ArrayCollection();
    }


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set path
     *
     * @param string $path
     *
     * @return Attestation
     */
    public function setPath($path)
    {
        $this->path = $path;

        return $this;
    }

    /**
     * Get path
     *
     * @return string
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * Set name
     *
     * @param string $name
     *
     * @return Attestation
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set size
     *
     * @param integer $size
     *
     * @return Attestation
     */
    public function setSize($size)
    {
        $this->size = $size;

        return $this;
    }

    /**
     * Get size
     *
     * @return int
     */
    public function getSize()
    {
        return $this->size;
    }

    /**
     * Set thumb
     *
     * @param string $thumb
     *
     * @return Attestation
     */
    public function setThumb($thumb)
    {
        $this->thumb = $thumb;

        return $this;
    }

    /**
     * Get thumb
     *
     * @return string
     */
    public function getThumb()
    {
        return $this->thumb;
    }
    

    /**
     * Add attestationVerif
     *
     * @param \AMLA\SqrBundle\Entity\AttestationVerification $attestationVerif
     *
     * @return Attestation
     */
    public function addAttestationVerif(\AMLA\SqrBundle\Entity\AttestationVerification $attestationVerif)
    {
        $this->attestationVerif[] = $attestationVerif;

        return $this;
    }

    /**
     * Remove attestationVerif
     *
     * @param \AMLA\SqrBundle\Entity\AttestationVerification $attestationVerif
     */
    public function removeAttestationVerif(\AMLA\SqrBundle\Entity\AttestationVerification $attestationVerif)
    {
        $this->attestationVerif->removeElement($attestationVerif);
    }

    /**
     * Get attestationVerif
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAttestationVerif()
    {
        return $this->attestationVerif;
    }

    /**
     * Set attestationVerif
     *
     * @param \AMLA\SqrBundle\Entity\AttestationVerification $attestationVerif
     *
     * @return Attestation
     */
    public function setAttestationVerif(\AMLA\SqrBundle\Entity\AttestationVerification $attestationVerif = null)
    {
        $this->attestationVerif = $attestationVerif;

        return $this;
    }
}
