<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Approvisionner
 *
 * @ORM\Table(name="approvisionner")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\ApprovisionnerRepository")
 */
class Approvisionner
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var float
     *
     * @ORM\Column(name="amount", type="float")
     */
    private $amount;

    /**
     * @var float
     *
     * @ORM\Column(name="fees", type="float")
     */
    private $fees;

    /**
     * @var float
     *
     * @ORM\Column(name="total", type="float")
     */
    private $total;

    /**
     * @var string
     *
     * @ORM\Column(name="type", type="string", length=20)
     */
    private $type;

    /**
     * @var string
     *
     * @ORM\Column(name="paymentMode", type="string", length=20)
     */
    private $paymentMode;

    /**
     * @var string
     *
     * @ORM\Column(name="numberToPay", type="string", length=20)
     */
    private $numberToPay;

    /**
     * @var string
     *
     * @ORM\Column(name="numberToBenefit", type="string", length=20)
     */
    private $numberToBenefit;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="approvisionner")
     * @ORM\JoinColumn(name="fournissseur_id", referencedColumnName="id")
     */
    private $fournisseur;

    /**
     * @ORM\ManyToOne(targetEntity="Account", inversedBy="approvisionner")
     * @ORM\JoinColumn(name="account_id", referencedColumnName="id")
     */
    private $account;

    /**
     * @var string
     *
     * @ORM\Column(name="operator", type="string", length=20, nullable=true)
     */
    private $operator;

    /**
     * @var int
     *
     * @ORM\Column(name="status", type="integer")
     */
    private $status;

    /**
     * @var string
     *
     * @ORM\Column(name="comment", type="text", nullable=true)
     */
    private $comment;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * Constructor
     */
    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->status = 0;// 1=Pending; 0=Success
        $this->fees = 25;// 1=Pending; 0=Success
        $this->total = 0;// 1=Pending; 0=Success
    }


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }


    /**
     * Set amount
     *
     * @param float $amount
     *
     * @return Approvisionner
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;

        return $this;
    }

    /**
     * Get amount
     *
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * Set paymentMode
     *
     * @param string $paymentMode
     *
     * @return Approvisionner
     */
    public function setPaymentMode($paymentMode)
    {
        $this->paymentMode = $paymentMode;

        return $this;
    }

    /**
     * Get paymentMode
     *
     * @return string
     */
    public function getPaymentMode()
    {
        return $this->paymentMode;
    }

    /**
     * Set numberToPay
     *
     * @param string $numberToPay
     *
     * @return Approvisionner
     */
    public function setNumberToPay($numberToPay)
    {
        $this->numberToPay = $numberToPay;

        return $this;
    }

    /**
     * Get numberToPay
     *
     * @return string
     */
    public function getNumberToPay()
    {
        return $this->numberToPay;
    }

    /**
     * Set operator
     *
     * @param string $operator
     *
     * @return Approvisionner
     */
    public function setOperator($operator)
    {
        $this->operator = $operator;

        return $this;
    }

    /**
     * Get operator
     *
     * @return string
     */
    public function getOperator()
    {
        return $this->operator;
    }

    /**
     * Set status
     *
     * @param integer $status
     *
     * @return Approvisionner
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return integer
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set comment
     *
     * @param string $comment
     *
     * @return Approvisionner
     */
    public function setComment($comment)
    {
        $this->comment = $comment;

        return $this;
    }

    /**
     * Get comment
     *
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return Approvisionner
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set fournisseur
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseur
     *
     * @return Approvisionner
     */
    public function setFournisseur(\AMLA\SqrBundle\Entity\Fournissseur $fournisseur = null)
    {
        $this->fournisseur = $fournisseur;

        return $this;
    }

    /**
     * Get fournisseur
     *
     * @return \AMLA\SqrBundle\Entity\Fournissseur
     */
    public function getFournisseur()
    {
        return $this->fournisseur;
    }

    /**
     * Set account
     *
     * @param \AMLA\SqrBundle\Entity\Account $account
     *
     * @return Approvisionner
     */
    public function setAccount(\AMLA\SqrBundle\Entity\Account $account = null)
    {
        $this->account = $account;

        return $this;
    }

    /**
     * Get account
     *
     * @return \AMLA\SqrBundle\Entity\Account
     */
    public function getAccount()
    {
        return $this->account;
    }

    /**
     * Set type
     *
     * @param string $type
     *
     * @return Approvisionner
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Get type
     *
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Set fees
     *
     * @param float $fees
     *
     * @return Approvisionner
     */
    public function setFees($fees)
    {
        $this->fees = $fees;

        return $this;
    }

    /**
     * Get fees
     *
     * @return float
     */
    public function getFees()
    {
        return $this->fees;
    }

    /**
     * Set total
     *
     * @param float $total
     *
     * @return Approvisionner
     */
    public function setTotal($total)
    {
        $this->total = $total;

        return $this;
    }

    /**
     * Get total
     *
     * @return float
     */
    public function getTotal()
    {
        return $this->total;
    }

    /**
     * Set numberToBenefit
     *
     * @param string $numberToBenefit
     *
     * @return Approvisionner
     */
    public function setNumberToBenefit($numberToBenefit)
    {
        $this->numberToBenefit = $numberToBenefit;

        return $this;
    }

    /**
     * Get numberToBenefit
     *
     * @return string
     */
    public function getNumberToBenefit()
    {
        return $this->numberToBenefit;
    }
}
