<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Anr
 *
 * @ORM\Table(name="anr")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\AnrRepository")
 */
class Anr
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="referenceANR", type="string", length=100)
     */
    private $referenceANR;
    
    /**
     * @var string
     *
     * @ORM\Column(name="fichier", type="string", length=255, nullable=true)
     */
    private $fichier;

     /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="anr")
     * @ORM\JoinColumn(name="fournisseur_id", referencedColumnName="id")
     */
    private $fournisseur;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_debut", type="datetime")
     */
    private $dateDebut;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_fin", type="datetime")
     */
    private $dateFin;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    /**
     * @ORM\OneToMany(targetEntity="SoummissionOffre", mappedBy="anr")
    */
    private $soumissionoffre;
    
     /**
     * Constructor
     */
    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); 
        
    }
    
    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set referenceANR
     *
     * @param string $referenceANR
     *
     * @return Anr
     */
    public function setReferenceANR($referenceANR)
    {
        $this->referenceANR = $referenceANR;

        return $this;
    }

    /**
     * Get referenceANR
     *
     * @return string
     */
    public function getReferenceANR()
    {
        return $this->referenceANR;
    }

    /**
     * Set fournisseur
     *
     * @param integer $fournisseur
     *
     * @return Anr
     */
    public function setFournisseur($fournisseur)
    {
        $this->fournisseur = $fournisseur;

        return $this;
    }

    /**
     * Get fournisseur
     *
     * @return int
     */
    public function getFournisseur()
    {
        return $this->fournisseur;
    }

    /**
     * Set dateDebut
     *
     * @param \DateTime $dateDebut
     *
     * @return Anr
     */
    public function setDateDebut($dateDebut)
    {
        $this->dateDebut = $dateDebut;

        return $this;
    }

    /**
     * Get dateDebut
     *
     * @return \DateTime
     */
    public function getDateDebut()
    {
        return $this->dateDebut;
    }

    /**
     * Set dateFin
     *
     * @param \DateTime $dateFin
     *
     * @return Anr
     */
    public function setDateFin($dateFin)
    {
        $this->dateFin = $dateFin;

        return $this;
    }

    /**
     * Get dateFin
     *
     * @return \DateTime
     */
    public function getDateFin()
    {
        return $this->dateFin;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return Anr
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set fichier
     *
     * @param string $fichier
     *
     * @return Anr
     */
    public function setFichier($fichier)
    {
        $this->fichier = $fichier;

        return $this;
    }

    /**
     * Get fichier
     *
     * @return string
     */
    public function getFichier()
    {
        return $this->fichier;
    }

    /**
     * Add soumissionoffre
     *
     * @param \AMLA\SqrBundle\Entity\SoummissionOffre $soumissionoffre
     *
     * @return Anr
     */
    public function addSoumissionoffre(\AMLA\SqrBundle\Entity\SoummissionOffre $soumissionoffre)
    {
        $this->soumissionoffre[] = $soumissionoffre;

        return $this;
    }

    /**
     * Remove soumissionoffre
     *
     * @param \AMLA\SqrBundle\Entity\SoummissionOffre $soumissionoffre
     */
    public function removeSoumissionoffre(\AMLA\SqrBundle\Entity\SoummissionOffre $soumissionoffre)
    {
        $this->soumissionoffre->removeElement($soumissionoffre);
    }

    /**
     * Get soumissionoffre
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getSoumissionoffre()
    {
        return $this->soumissionoffre;
    }
}
