<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Analytique
 *
 * @ORM\Table(name="analytique")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\AnalytiqueRepository")
 */
class Analytique
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var float
     *
     * @ORM\Column(name="cumulFactureNonPayeHt", type="float", nullable=true)
     */
    private $cumulFactureNonPayeHt;

    /**
     * @var float
     *
     * @ORM\Column(name="cumulFactureNonPayeTtc", type="float", nullable=true)
     */
    private $cumulFactureNonPayeTtc;

    /**
     * @var float
     *
     * @ORM\Column(name="cumulFacturePayeHt", type="float", nullable=true)
     */
    private $cumulFacturePayeHt;

    /**
     * @var float
     *
     * @ORM\Column(name="cumulFacturePayeTtc", type="float", nullable=true)
     */
    private $cumulFacturePayeTtc;

    /**
     * @var float
     *
     * @ORM\Column(name="cumulFactureRejeteHt", type="float", nullable=true)
     */
    private $cumulFactureRejeteHt;

    /**
     * @var float
     *
     * @ORM\Column(name="cumulFactureRejeteTtc", type="float", nullable=true)
     */
    private $cumulFactureRejeteTtc;

    /**
     * @var float
     *
     * @ORM\Column(name="cumulAttestationRetenuReverse", type="float", nullable=true)
     */
    private $cumulAttestationRetenuReverse;

    /**
     * @var float
     *
     * @ORM\Column(name="cumulAttestationRetenuNonReverse", type="float", nullable=true)
     */
    private $cumulAttestationRetenuNonReverse;

    /**
     * @var float
     *
     * @ORM\Column(name="montantGlobalTVAFactureTouteEntreprise", type="float", nullable=true)
     */
    private $montantGlobalTVAFactureTouteEntreprise;

    /**
     * @var float
     *
     * @ORM\Column(name="montantGlobalISFactureTouteEntreprise", type="float", nullable=true)
     */
    private $montantGlobalISFactureTouteEntreprise;

    /**
     * @var float
     *
     * @ORM\Column(name="montantGlobalISFactureEntreprisesCollectrice", type="float", nullable=true)
     */
    private $montantGlobalISFactureEntreprisesCollectrice;

    /**
     * @var float
     *
     * @ORM\Column(name="montantGlobalTVAFactureEntreprisesCollectrice", type="float", nullable=true)
     */
    private $montantGlobalTVAFactureEntreprisesCollectrice;

    /**
     * @var float
     *
     * @ORM\Column(name="montantGlobalISFactureEntreprisesNonCollectrice", type="float", nullable=true)
     */
    private $montantGlobalISFactureEntreprisesNonCollectrice;

    /**
     * @var float
     *
     * @ORM\Column(name="montantGlobalTVAFactureEntreprisesNonCollectrice", type="float", nullable=true)
     */
    private $montantGlobalTVAFactureEntreprisesNonCollectrice;

    /**
     * @var float
     *
     * @ORM\Column(name="montantGlobalTVAFacturerejete", type="float", nullable=true)
     */
    private $montantGlobalTVAFacturerejete;

    /**
     * @var float
     *
     * @ORM\Column(name="montantGlobalISFacturerejete", type="float", nullable=true)
     */
    private $montantGlobalISFacturerejete;

    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->cumulFactureNonPayeHt = 0;
        $this->cumulFactureNonPayeTtc = 0;
        $this->cumulFacturePayeHt = 0;
        $this->cumulFacturePayeTtc = 0;
        $this->cumulFactureRejeteHt = 0;
        $this->cumulFactureRejeteTtc = 0;
        $this->cumulAttestationRetenuReverse = 0;
        $this->cumulAttestationRetenuNonReverse = 0;

        $this->montantGlobalTVAFactureTouteEntreprise = 0;
        $this->montantGlobalISFactureTouteEntreprise = 0;
        $this->montantGlobalISFactureEntreprisesCollectrice = 0;
        $this->montantGlobalTVAFactureEntreprisesCollectrice = 0;
        $this->montantGlobalTVAFactureEntreprisesNonCollectrice = 0;
        $this->montantGlobalISFactureEntreprisesNonCollectrice = 0;
        $this->montantGlobalTVAFacturerejete = 0;
        $this->montantGlobalISFacturerejete = 0;
    }



    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set cumulFactureNonPayeHt
     *
     * @param float $cumulFactureNonPayeHt
     *
     * @return Analytique
     */
    public function setCumulFactureNonPayeHt($cumulFactureNonPayeHt)
    {
        $this->cumulFactureNonPayeHt = $cumulFactureNonPayeHt;

        return $this;
    }

    /**
     * Get cumulFactureNonPayeHt
     *
     * @return float
     */
    public function getCumulFactureNonPayeHt()
    {
        return $this->cumulFactureNonPayeHt;
    }

    /**
     * Set cumulFactureNonPayeTtc
     *
     * @param float $cumulFactureNonPayeTtc
     *
     * @return Analytique
     */
    public function setCumulFactureNonPayeTtc($cumulFactureNonPayeTtc)
    {
        $this->cumulFactureNonPayeTtc = $cumulFactureNonPayeTtc;

        return $this;
    }

    /**
     * Get cumulFactureNonPayeTtc
     *
     * @return float
     */
    public function getCumulFactureNonPayeTtc()
    {
        return $this->cumulFactureNonPayeTtc;
    }

    /**
     * Set cumulFacturePayeHt
     *
     * @param float $cumulFacturePayeHt
     *
     * @return Analytique
     */
    public function setCumulFacturePayeHt($cumulFacturePayeHt)
    {
        $this->cumulFacturePayeHt = $cumulFacturePayeHt;

        return $this;
    }

    /**
     * Get cumulFacturePayeHt
     *
     * @return float
     */
    public function getCumulFacturePayeHt()
    {
        return $this->cumulFacturePayeHt;
    }

    /**
     * Set cumulFacturePayeTtc
     *
     * @param float $cumulFacturePayeTtc
     *
     * @return Analytique
     */
    public function setCumulFacturePayeTtc($cumulFacturePayeTtc)
    {
        $this->cumulFacturePayeTtc = $cumulFacturePayeTtc;

        return $this;
    }

    /**
     * Get cumulFacturePayeTtc
     *
     * @return float
     */
    public function getCumulFacturePayeTtc()
    {
        return $this->cumulFacturePayeTtc;
    }

    /**
     * Set cumulFactureRejeteHt
     *
     * @param float $cumulFactureRejeteHt
     *
     * @return Analytique
     */
    public function setCumulFactureRejeteHt($cumulFactureRejeteHt)
    {
        $this->cumulFactureRejeteHt = $cumulFactureRejeteHt;

        return $this;
    }

    /**
     * Get cumulFactureRejeteHt
     *
     * @return float
     */
    public function getCumulFactureRejeteHt()
    {
        return $this->cumulFactureRejeteHt;
    }

    /**
     * Set cumulFactureRejeteTtc
     *
     * @param float $cumulFactureRejeteTtc
     *
     * @return Analytique
     */
    public function setCumulFactureRejeteTtc($cumulFactureRejeteTtc)
    {
        $this->cumulFactureRejeteTtc = $cumulFactureRejeteTtc;

        return $this;
    }

    /**
     * Get cumulFactureRejeteTtc
     *
     * @return float
     */
    public function getCumulFactureRejeteTtc()
    {
        return $this->cumulFactureRejeteTtc;
    }

    /**
     * Set cumulAttestationRetenuReverse
     *
     * @param float $cumulAttestationRetenuReverse
     *
     * @return Analytique
     */
    public function setCumulAttestationRetenuReverse($cumulAttestationRetenuReverse)
    {
        $this->cumulAttestationRetenuReverse = $cumulAttestationRetenuReverse;

        return $this;
    }

    /**
     * Get cumulAttestationRetenuReverse
     *
     * @return float
     */
    public function getCumulAttestationRetenuReverse()
    {
        return $this->cumulAttestationRetenuReverse;
    }

    /**
     * Set cumulAttestationRetenuNonReverse
     *
     * @param float $cumulAttestationRetenuNonReverse
     *
     * @return Analytique
     */
    public function setCumulAttestationRetenuNonReverse($cumulAttestationRetenuNonReverse)
    {
        $this->cumulAttestationRetenuNonReverse = $cumulAttestationRetenuNonReverse;

        return $this;
    }

    /**
     * Get cumulAttestationRetenuNonReverse
     *
     * @return float
     */
    public function getCumulAttestationRetenuNonReverse()
    {
        return $this->cumulAttestationRetenuNonReverse;
    }

    /**
     * Set montantGlobalTVAFactureTouteEntreprise
     *
     * @param float $montantGlobalTVAFactureTouteEntreprise
     *
     * @return Analytique
     */
    public function setMontantGlobalTVAFactureTouteEntreprise($montantGlobalTVAFactureTouteEntreprise)
    {
        $this->montantGlobalTVAFactureTouteEntreprise = $montantGlobalTVAFactureTouteEntreprise;

        return $this;
    }

    /**
     * Get montantGlobalTVAFactureTouteEntreprise
     *
     * @return float
     */
    public function getMontantGlobalTVAFactureTouteEntreprise()
    {
        return $this->montantGlobalTVAFactureTouteEntreprise;
    }

    /**
     * Set montantGlobalISFactureTouteEntreprise
     *
     * @param float $montantGlobalISFactureTouteEntreprise
     *
     * @return Analytique
     */
    public function setMontantGlobalISFactureTouteEntreprise($montantGlobalISFactureTouteEntreprise)
    {
        $this->montantGlobalISFactureTouteEntreprise = $montantGlobalISFactureTouteEntreprise;

        return $this;
    }

    /**
     * Get montantGlobalISFactureTouteEntreprise
     *
     * @return float
     */
    public function getMontantGlobalISFactureTouteEntreprise()
    {
        return $this->montantGlobalISFactureTouteEntreprise;
    }

    /**
     * Set montantGlobalISFactureEntreprisesCollectrice
     *
     * @param float $montantGlobalISFactureEntreprisesCollectrice
     *
     * @return Analytique
     */
    public function setMontantGlobalISFactureEntreprisesCollectrice($montantGlobalISFactureEntreprisesCollectrice)
    {
        $this->montantGlobalISFactureEntreprisesCollectrice = $montantGlobalISFactureEntreprisesCollectrice;

        return $this;
    }

    /**
     * Get montantGlobalISFactureEntreprisesCollectrice
     *
     * @return float
     */
    public function getMontantGlobalISFactureEntreprisesCollectrice()
    {
        return $this->montantGlobalISFactureEntreprisesCollectrice;
    }

    /**
     * Set montantGlobalTVAFactureEntreprisesCollectrice
     *
     * @param float $montantGlobalTVAFactureEntreprisesCollectrice
     *
     * @return Analytique
     */
    public function setMontantGlobalTVAFactureEntreprisesCollectrice($montantGlobalTVAFactureEntreprisesCollectrice)
    {
        $this->montantGlobalTVAFactureEntreprisesCollectrice = $montantGlobalTVAFactureEntreprisesCollectrice;

        return $this;
    }

    /**
     * Get montantGlobalTVAFactureEntreprisesCollectrice
     *
     * @return float
     */
    public function getMontantGlobalTVAFactureEntreprisesCollectrice()
    {
        return $this->montantGlobalTVAFactureEntreprisesCollectrice;
    }

    /**
     * Set montantGlobalISFactureEntreprisesNonCollectrice
     *
     * @param float $montantGlobalISFactureEntreprisesNonCollectrice
     *
     * @return Analytique
     */
    public function setMontantGlobalISFactureEntreprisesNonCollectrice($montantGlobalISFactureEntreprisesNonCollectrice)
    {
        $this->montantGlobalISFactureEntreprisesNonCollectrice = $montantGlobalISFactureEntreprisesNonCollectrice;

        return $this;
    }

    /**
     * Get montantGlobalISFactureEntreprisesNonCollectrice
     *
     * @return float
     */
    public function getMontantGlobalISFactureEntreprisesNonCollectrice()
    {
        return $this->montantGlobalISFactureEntreprisesNonCollectrice;
    }

    /**
     * Set montantGlobalTVAFactureEntreprisesNonCollectrice
     *
     * @param float $montantGlobalTVAFactureEntreprisesNonCollectrice
     *
     * @return Analytique
     */
    public function setMontantGlobalTVAFactureEntreprisesNonCollectrice($montantGlobalTVAFactureEntreprisesNonCollectrice)
    {
        $this->montantGlobalTVAFactureEntreprisesNonCollectrice = $montantGlobalTVAFactureEntreprisesNonCollectrice;

        return $this;
    }

    /**
     * Get montantGlobalTVAFactureEntreprisesNonCollectrice
     *
     * @return float
     */
    public function getMontantGlobalTVAFactureEntreprisesNonCollectrice()
    {
        return $this->montantGlobalTVAFactureEntreprisesNonCollectrice;
    }

    /**
     * Set montantGlobalTVAFacturerejete
     *
     * @param float $montantGlobalTVAFacturerejete
     *
     * @return Analytique
     */
    public function setMontantGlobalTVAFacturerejete($montantGlobalTVAFacturerejete)
    {
        $this->montantGlobalTVAFacturerejete = $montantGlobalTVAFacturerejete;

        return $this;
    }

    /**
     * Get montantGlobalTVAFacturerejete
     *
     * @return float
     */
    public function getMontantGlobalTVAFacturerejete()
    {
        return $this->montantGlobalTVAFacturerejete;
    }

    /**
     * Set montantGlobalISFacturerejete
     *
     * @param float $montantGlobalISFacturerejete
     *
     * @return Analytique
     */
    public function setMontantGlobalISFacturerejete($montantGlobalISFacturerejete)
    {
        $this->montantGlobalISFacturerejete = $montantGlobalISFacturerejete;

        return $this;
    }

    /**
     * Get montantGlobalISFacturerejete
     *
     * @return float
     */
    public function getMontantGlobalISFacturerejete()
    {
        return $this->montantGlobalISFacturerejete;
    }
}
