<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Security\Core\User\AdvancedUserInterface;

/**
 * Account
 *
 * @ORM\Table(name="checktoo_account")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\AccountRepository")
 */
class Account implements AdvancedUserInterface, \Serializable
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="login", type="string", length=50)
     */
    private $loginUser;

    /**
     * @var string
     *
     * @ORM\Column(name="niu", type="string", length=20, nullable=true)
     */
    private $niu;

    /**
     * @var string
     *
     * @ORM\Column(name="mdp", type="string", length=250)
     */
    private $password;

    /**
     * @var int
     *
     * @ORM\Column(name="activate", type="smallint", nullable=true)
     */
    private $activate;

    /**
     * @var int
     *
     * @ORM\Column(name="locked", type="smallint", nullable=true)
     */
    private $locked;

    /*
     * 1 = SuperAdmin
     * 2 = Ministere
     * 3 = Delegation
     * 4 = Promoteur
     * 5 = Responsable Etablissement
     * 6 = Surveillant
     * 7 = Scenseur
     * 8 = Enseignant
     * 9 = Eleve
     *
     */

    /**
     * @var int
     *
     * @ORM\Column(name="role_user", type="integer")
     */
    private $role;

    /**
     * @var string
     *
     * @ORM\Column(name="civilite", type="string", length=10, nullable=true)
     */
    private $sexe;

    /**
     * @var string
     *
     * @ORM\Column(name="nom", type="string", length=50, nullable=true)
     */
    private $nom;

    /**
     * @var string
     *
     * @ORM\Column(name="prenom", type="string", length=50, nullable=true)
     */
    private $prenom;

    /**
     * @var string
     *
     * @ORM\Column(name="telephone", type="string", length=20, nullable=true)
     */
    private $telephone;

    /**
     * @var string
     *
     * @ORM\Column(name="localisation", type="string", length=50, nullable=true)
     */
    private $localisation;

    /**
     * @var string
     *
     * @ORM\Column(name="date_de_naissance", type="date", nullable=true)
     */
    private $dateNaiss;

    /**
     * @var string
     *
     * @ORM\Column(name="email", type="string", length=80, nullable=true)
     */
    private $email;

    /**
     * @var string
     *
     * @ORM\Column(name="matricule", type="string", length=80, nullable=true)
     */
    private $matricule;

    /**
     * @var string
     *
     * @ORM\Column(name="adresse", type="string", length=100, nullable=true)
     */
    private $adresse;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="lastconnexion", type="datetime")
     */
    private $lastconnexion;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="currentconnexion", type="datetime")
     */
    private $currentconnexion;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="compagnyUsers", cascade={"persist"})
     * @ORM\JoinColumn(name="fournisseur_id", referencedColumnName="id")
     */
    private $compagnyId;

    /**
     * @ORM\OneToMany(targetEntity="Fournissseur", mappedBy="account")
    */
    private $fournisseurs;
    
    /**
     * @ORM\OneToMany(targetEntity="Invitation", mappedBy="sender")
    */
    private $messagesender;

    /**
     * @ORM\OneToMany(targetEntity="Invitation", mappedBy="receiver")
    */
    private $messagereceiver;
    /**
     * @ORM\OneToMany(targetEntity="ImpotVerify", mappedBy="account")
    */
    private $impotVerify;
    /**
     * @ORM\OneToMany(targetEntity="ImpotServerDown", mappedBy="account")
    */
    private $impotServerDown;
    
    /**
     * @ORM\OneToMany(targetEntity="Contrat", mappedBy="account")
    */
    private $contrat;
    
    /**
     * @ORM\OneToMany(targetEntity="Caution", mappedBy="account")
    */
    private $caution;

    /**
     * @ORM\OneToMany(targetEntity="FactureSpontane", mappedBy="account")
    */
    private $factureSpontane;

    /**
     * @ORM\OneToMany(targetEntity="AtdSuspension", mappedBy="account")
    */
    private $atdSuspension;

    /**
     * @ORM\OneToMany(targetEntity="AMR", mappedBy="account")
    */
    private $amr;

    /**
     * @ORM\OneToMany(targetEntity="MTN", mappedBy="account")
    */
    private $mtn;

    /**
     * @ORM\OneToMany(targetEntity="FactureSimple", mappedBy="account")
    */
    private $factureSimple;

    /**
     * @ORM\OneToMany(targetEntity="Moratoire", mappedBy="auteurDemandeur")
    */
    private $moratoireDemandeur;

    /**
     * @ORM\OneToMany(targetEntity="Moratoire", mappedBy="auteurDecision")
    */
    private $moratoireDecision;

    /**
     * @ORM\OneToMany(targetEntity="RemiseGracieuse", mappedBy="auteurDecision")
    */
    private $remiseGracieuseDecision;

    /**
     * @ORM\OneToMany(targetEntity="Service", mappedBy="account")
    */
    private $service;

    /**
     * @ORM\OneToMany(targetEntity="Fine", mappedBy="account")
    */
    private $fine;

    /**
     * @ORM\OneToMany(targetEntity="Quittance", mappedBy="sender")
    */
    private $quittance;

    /**
     * @ORM\OneToMany(targetEntity="Exchange", mappedBy="account")
     */
    private $exchange;

    /**
     * @ORM\OneToMany(targetEntity="Approvisionner", mappedBy="account")
     */
    private $approvisionner;

    /**
     * @ORM\OneToMany(targetEntity="SubscriptionInbill", mappedBy="account")
     */
    private $subscriptionInbill;

    /**
     * @ORM\OneToMany(targetEntity="PlanifierPaiement", mappedBy="account")
     */
    private $planifierPaiement;
    
    /**
     * Constructor
     */
    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->lastconnexion = new \Datetime(); // default date
        $this->currentconnexion = new \Datetime(); // default date
        $this->role=1;
        $this->activate = 1;
        $this->locked = 0;
    }

    public function fullName()
    {
        return $this->getNom().' '.$this->getPrenom();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set loginUser
     *
     * @param string $loginUser
     *
     * @return Account
     */
    public function setLoginUser($loginUser)
    {
        $this->loginUser = $loginUser;

        return $this;
    }

    /**
     * Get loginUser
     *
     * @return string
     */
    public function getLoginUser()
    {
        return $this->loginUser;
    }

    /**
     * Set tokenUser
     *
     * @param string $tokenUser
     *
     * @return Account
     */
    public function setTokenUser($tokenUser)
    {
        $this->tokenUser = $tokenUser;

        return $this;
    }

    /**
     * Get tokenUser
     *
     * @return string
     */
    public function getTokenUser()
    {
        return $this->tokenUser;
    }

    /**
     * Set etatUser
     *
     * @param integer $etatUser
     *
     * @return Account
     */
    public function setEtatUser($etatUser)
    {
        $this->etatUser = $etatUser;

        return $this;
    }

    /**
     * Get etatUser
     *
     * @return integer
     */
    public function getEtatUser()
    {
        return $this->etatUser;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return Account
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }
    ////////////// Fonctions de l'interface pour s�curity controller


    /**
     * Fonctions UserInterface
     *
     */

    public function setRoles(array $roles)
    {
        $this->role = $roles;

        // allows for chaining
        return $this;
    }

    public function getRoles()
    {
        switch ($this->getRole()) 
        {
            case 0:
                $role =  'ROLE_ADMIN';
                break;
            case 1:
                $role =  'ROLE_USER';
                break;
            case 2:
                $role =  'ROLE_USER';
                break;
            case 3:
                $role =  'ROLE_BANK';
                break;
            case 4:
                $role =  'ROLE_IMPOT';
                break;
            case 5:
                $role =  'ROLE_GRID';
                break;
            default:
                $role = 'ROLE_USER';
                break;
        }

        return array($role);
    }

    public function eraseCredentials()
    {

    }

    /** @see \Serializable::serialize() */
    public function serialize()
    {
        return serialize(array(
            $this->id,
            $this->loginUser,
            $this->password,
            // see section on salt below
            // $this->salt,
        ));
    }

    /** @see \Serializable::unserialize() */
    public function unserialize($serialized)
    {
        list (
            $this->id,
            $this->email,
            $this->password,
            // see section on salt below
            // $this->salt
            ) = unserialize($serialized);
    }

    public function getSalt() 
    {

    }

    public function getUsername() 
    {
        //return $this->nom . ' ' . $this->prenom;
        return $this->loginUser;
    }

    public function isAccountNonExpired()
    {
        return true;
    }

    public function isAccountNonLocked()
    {
        return true;
        //return $this->locked;
    }

    public function isCredentialsNonExpired()
    {
        return true;
    }

    public function isEnabled()
    {
        return $this->activate;
    }

    /**
     * Set password
     *
     * @param string $password
     * @return Account
     */
    public function setPassword($password)
    {
        $options = ['cost' => 15];
        $encoded = password_hash($password,PASSWORD_BCRYPT,$options);
        $this->password = $encoded;

        return $this;
    }

    /**
     * Get password
     *
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    //////////////// End Fonctions de l'interface


    /**
     * Set activate
     *
     * @param integer $activate
     *
     * @return Account
     */
    public function setActivate($activate)
    {
        $this->activate = $activate;

        return $this;
    }

    /**
     * Get activate
     *
     * @return integer
     */
    public function getActivate()
    {
        return $this->activate;
    }

    /**
     * Set locked
     *
     * @param integer $locked
     *
     * @return Account
     */
    public function setLocked($locked)
    {
        $this->locked = $locked;

        return $this;
    }

    /**
     * Get locked
     *
     * @return integer
     */
    public function getLocked()
    {
        return $this->locked;
    }

    /**
     * Set sexe
     *
     * @param string $sexe
     *
     * @return Account
     */
    public function setSexe($sexe)
    {
        $this->sexe = $sexe;

        return $this;
    }

    /**
     * Get sexe
     *
     * @return string
     */
    public function getSexe()
    {
        return $this->sexe;
    }

    /**
     * Set nom
     *
     * @param string $nom
     *
     * @return Account
     */
    public function setNom($nom)
    {
        $this->nom = $nom;

        return $this;
    }

    /**
     * Get nom
     *
     * @return string
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * Set prenom
     *
     * @param string $prenom
     *
     * @return Account
     */
    public function setPrenom($prenom)
    {
        $this->prenom = $prenom;

        return $this;
    }

    /**
     * Get prenom
     *
     * @return string
     */
    public function getPrenom()
    {
        return $this->prenom;
    }

    /**
     * Set telephone
     *
     * @param string $telephone
     *
     * @return Account
     */
    public function setTelephone($telephone)
    {
        $this->telephone = $telephone;

        return $this;
    }

    /**
     * Get telephone
     *
     * @return string
     */
    public function getTelephone()
    {
        return $this->telephone;
    }

    /**
     * Set dateNaiss
     *
     * @param \DateTime $dateNaiss
     *
     * @return Account
     */
    public function setDateNaiss($dateNaiss)
    {
        $this->dateNaiss = $dateNaiss;

        return $this;
    }

    /**
     * Get dateNaiss
     *
     * @return \DateTime
     */
    public function getDateNaiss()
    {
        return $this->dateNaiss;
    }

    /**
     * Set email
     *
     * @param string $email
     *
     * @return Account
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set adresse
     *
     * @param string $adresse
     *
     * @return Account
     */
    public function setAdresse($adresse)
    {
        $this->adresse = $adresse;

        return $this;
    }

    /**
     * Get adresse
     *
     * @return string
     */
    public function getAdresse()
    {
        return $this->adresse;
    }

    /**
     * Set numCni
     *
     * @param string $numCni
     *
     * @return Account
     */
    public function setNumCni($numCni)
    {
        $this->numCni = $numCni;

        return $this;
    }

    /**
     * Get numCni
     *
     * @return string
     */
    public function getNumCni()
    {
        return $this->numCni;
    }

    /**
     * Set diplome
     *
     * @param string $diplome
     *
     * @return Account
     */
    public function setDiplome($diplome)
    {
        $this->diplome = $diplome;

        return $this;
    }

    /**
     * Get diplome
     *
     * @return string
     */
    public function getDiplome()
    {
        return $this->diplome;
    }

    /**
     * Set role
     *
     * @param integer $role
     *
     * @return Account
     */
    public function setRole($role)
    {
        $this->role = $role;

        return $this;
    }

    /**
     * Get role
     *
     * @return integer
     */
    public function getRole()
    {
        return $this->role;
    }

    /**
     * Set token
     *
     * @param string $token
     *
     * @return Account
     */
    public function setToken($token)
    {
        $this->token = $token;

        return $this;
    }

    /**
     * Get token
     *
     * @return string
     */
    public function getToken()
    {
        return $this->token;
    }

    /**
     * Set lastConnection
     *
     * @param \DateTime $lastConnection
     *
     * @return Account
     */
    public function setLastConnection($lastConnection)
    {
        $this->lastConnection = $lastConnection;

        return $this;
    }

    /**
     * Get lastConnection
     *
     * @return \DateTime
     */
    public function getLastConnection()
    {
        return $this->lastConnection;
    }

    /**
     * Set currentConnection
     *
     * @param \DateTime $currentConnection
     *
     * @return Account
     */
    public function setCurrentConnection($currentConnection)
    {
        $this->currentConnection = $currentConnection;

        return $this;
    }

    /**
     * Get currentConnection
     *
     * @return \DateTime
     */
    public function getCurrentConnection()
    {
        return $this->currentConnection;
    }


    /**
     * Add fournisseur
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseur
     *
     * @return Account
     */
    public function addFournisseur(\AMLA\SqrBundle\Entity\Fournissseur $fournisseur)
    {
        $this->fournisseur[] = $fournisseur;

        return $this;
    }

    /**
     * Remove fournisseur
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseur
     */
    public function removeFournisseur(\AMLA\SqrBundle\Entity\Fournissseur $fournisseur)
    {
        $this->fournisseur->removeElement($fournisseur);
    }

    /**
     * Get fournisseurs
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFournisseurs()
    {
        return $this->fournisseurs;
    }

    /**
     * Add messagesender
     *
     * @param \AMLA\SqrBundle\Entity\Invitation $messagesender
     *
     * @return Account
     */
    public function addMessagesender(\AMLA\SqrBundle\Entity\Invitation $messagesender)
    {
        $this->messagesender[] = $messagesender;

        return $this;
    }

    /**
     * Remove messagesender
     *
     * @param \AMLA\SqrBundle\Entity\Invitation $messagesender
     */
    public function removeMessagesender(\AMLA\SqrBundle\Entity\Invitation $messagesender)
    {
        $this->messagesender->removeElement($messagesender);
    }

    /**
     * Get messagesender
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMessagesender()
    {
        return $this->messagesender;
    }

    /**
     * Add messagereceiver
     *
     * @param \AMLA\SqrBundle\Entity\Invitation $messagereceiver
     *
     * @return Account
     */
    public function addMessagereceiver(\AMLA\SqrBundle\Entity\Invitation $messagereceiver)
    {
        $this->messagereceiver[] = $messagereceiver;

        return $this;
    }

    /**
     * Remove messagereceiver
     *
     * @param \AMLA\SqrBundle\Entity\Invitation $messagereceiver
     */
    public function removeMessagereceiver(\AMLA\SqrBundle\Entity\Invitation $messagereceiver)
    {
        $this->messagereceiver->removeElement($messagereceiver);
    }

    /**
     * Get messagereceiver
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMessagereceiver()
    {
        return $this->messagereceiver;
    }

    /**
     * Set lastconnexion
     *
     * @param \DateTime $lastconnexion
     *
     * @return Account
     */
    public function setLastconnexion($lastconnexion)
    {
        $this->lastconnexion = $lastconnexion;

        return $this;
    }

    /**
     * Get lastconnexion
     *
     * @return \DateTime
     */
    public function getLastconnexion()
    {
        return $this->lastconnexion;
    }

    /**
     * Set currentconnexion
     *
     * @param \DateTime $currentconnexion
     *
     * @return Account
     */
    public function setCurrentconnexion($currentconnexion)
    {
        $this->currentconnexion = $currentconnexion;

        return $this;
    }

    /**
     * Get currentconnexion
     *
     * @return \DateTime
     */
    public function getCurrentconnexion()
    {
        return $this->currentconnexion;
    }

    /**
     * Add impotVerify
     *
     * @param \AMLA\SqrBundle\Entity\ImpotVerify $impotVerify
     *
     * @return Account
     */
    public function addImpotVerify(\AMLA\SqrBundle\Entity\ImpotVerify $impotVerify)
    {
        $this->impotVerify[] = $impotVerify;

        return $this;
    }

    /**
     * Remove impotVerify
     *
     * @param \AMLA\SqrBundle\Entity\ImpotVerify $impotVerify
     */
    public function removeImpotVerify(\AMLA\SqrBundle\Entity\ImpotVerify $impotVerify)
    {
        $this->impotVerify->removeElement($impotVerify);
    }

    /**
     * Get impotVerify
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getImpotVerify()
    {
        return $this->impotVerify;
    }

    /**
     * Add impotServerDown
     *
     * @param \AMLA\SqrBundle\Entity\ImpotServerDown $impotServerDown
     *
     * @return Account
     */
    public function addImpotServerDown(\AMLA\SqrBundle\Entity\ImpotServerDown $impotServerDown)
    {
        $this->impotServerDown[] = $impotServerDown;

        return $this;
    }

    /**
     * Remove impotServerDown
     *
     * @param \AMLA\SqrBundle\Entity\ImpotServerDown $impotServerDown
     */
    public function removeImpotServerDown(\AMLA\SqrBundle\Entity\ImpotServerDown $impotServerDown)
    {
        $this->impotServerDown->removeElement($impotServerDown);
    }

    /**
     * Get impotServerDown
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getImpotServerDown()
    {
        return $this->impotServerDown;
    }


    /**
     * Add contrat
     *
     * @param \AMLA\SqrBundle\Entity\Contrat $contrat
     *
     * @return Account
     */
    public function addContrat(\AMLA\SqrBundle\Entity\Contrat $contrat)
    {
        $this->contrat[] = $contrat;

        return $this;
    }

    /**
     * Remove contrat
     *
     * @param \AMLA\SqrBundle\Entity\Contrat $contrat
     */
    public function removeContrat(\AMLA\SqrBundle\Entity\Contrat $contrat)
    {
        $this->contrat->removeElement($contrat);
    }

    /**
     * Get contrat
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getContrat()
    {
        return $this->contrat;
    }

    /**
     * Add caution
     *
     * @param \AMLA\SqrBundle\Entity\Caution $caution
     *
     * @return Account
     */
    public function addCaution(\AMLA\SqrBundle\Entity\Caution $caution)
    {
        $this->caution[] = $caution;

        return $this;
    }

    /**
     * Remove caution
     *
     * @param \AMLA\SqrBundle\Entity\Caution $caution
     */
    public function removeCaution(\AMLA\SqrBundle\Entity\Caution $caution)
    {
        $this->caution->removeElement($caution);
    }

    /**
     * Get caution
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getCaution()
    {
        return $this->caution;
    }

    /**
     * Add factureSpontane
     *
     * @param \AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane
     *
     * @return Account
     */
    public function addFactureSpontane(\AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane)
    {
        $this->factureSpontane[] = $factureSpontane;

        return $this;
    }

    /**
     * Remove factureSpontane
     *
     * @param \AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane
     */
    public function removeFactureSpontane(\AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane)
    {
        $this->factureSpontane->removeElement($factureSpontane);
    }

    /**
     * Get factureSpontane
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFactureSpontane()
    {
        return $this->factureSpontane;
    }

    /**
     * Add atdSuspension
     *
     * @param \AMLA\SqrBundle\Entity\AtdSuspension $atdSuspension
     *
     * @return Account
     */
    public function addAtdSuspension(\AMLA\SqrBundle\Entity\AtdSuspension $atdSuspension)
    {
        $this->atdSuspension[] = $atdSuspension;

        return $this;
    }

    /**
     * Remove atdSuspension
     *
     * @param \AMLA\SqrBundle\Entity\AtdSuspension $atdSuspension
     */
    public function removeAtdSuspension(\AMLA\SqrBundle\Entity\AtdSuspension $atdSuspension)
    {
        $this->atdSuspension->removeElement($atdSuspension);
    }

    /**
     * Get atdSuspension
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAtdSuspension()
    {
        return $this->atdSuspension;
    }

    /**
     * Add amr
     *
     * @param \AMLA\SqrBundle\Entity\AMR $amr
     *
     * @return Account
     */
    public function addAmr(\AMLA\SqrBundle\Entity\AMR $amr)
    {
        $this->amr[] = $amr;

        return $this;
    }

    /**
     * Remove amr
     *
     * @param \AMLA\SqrBundle\Entity\AMR $amr
     */
    public function removeAmr(\AMLA\SqrBundle\Entity\AMR $amr)
    {
        $this->amr->removeElement($amr);
    }

    /**
     * Get amr
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAmr()
    {
        return $this->amr;
    }

    /**
     * Add mtn
     *
     * @param \AMLA\SqrBundle\Entity\MTN $mtn
     *
     * @return Account
     */
    public function addMtn(\AMLA\SqrBundle\Entity\MTN $mtn)
    {
        $this->mtn[] = $mtn;

        return $this;
    }

    /**
     * Remove mtn
     *
     * @param \AMLA\SqrBundle\Entity\MTN $mtn
     */
    public function removeMtn(\AMLA\SqrBundle\Entity\MTN $mtn)
    {
        $this->mtn->removeElement($mtn);
    }

    /**
     * Get mtn
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMtn()
    {
        return $this->mtn;
    }

    /**
     * Add factureSimple
     *
     * @param \AMLA\SqrBundle\Entity\FactureSimple $factureSimple
     *
     * @return Account
     */
    public function addFactureSimple(\AMLA\SqrBundle\Entity\FactureSimple $factureSimple)
    {
        $this->factureSimple[] = $factureSimple;

        return $this;
    }

    /**
     * Remove factureSimple
     *
     * @param \AMLA\SqrBundle\Entity\FactureSimple $factureSimple
     */
    public function removeFactureSimple(\AMLA\SqrBundle\Entity\FactureSimple $factureSimple)
    {
        $this->factureSimple->removeElement($factureSimple);
    }

    /**
     * Get factureSimple
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFactureSimple()
    {
        return $this->factureSimple;
    }

    /**
     * Add moratoireDemandeur
     *
     * @param \AMLA\SqrBundle\Entity\Moratoire $moratoireDemandeur
     *
     * @return Account
     */
    public function addMoratoireDemandeur(\AMLA\SqrBundle\Entity\Moratoire $moratoireDemandeur)
    {
        $this->moratoireDemandeur[] = $moratoireDemandeur;

        return $this;
    }

    /**
     * Remove moratoireDemandeur
     *
     * @param \AMLA\SqrBundle\Entity\Moratoire $moratoireDemandeur
     */
    public function removeMoratoireDemandeur(\AMLA\SqrBundle\Entity\Moratoire $moratoireDemandeur)
    {
        $this->moratoireDemandeur->removeElement($moratoireDemandeur);
    }

    /**
     * Get moratoireDemandeur
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMoratoireDemandeur()
    {
        return $this->moratoireDemandeur;
    }

    /**
     * Add moratoireDecision
     *
     * @param \AMLA\SqrBundle\Entity\Moratoire $moratoireDecision
     *
     * @return Account
     */
    public function addMoratoireDecision(\AMLA\SqrBundle\Entity\Moratoire $moratoireDecision)
    {
        $this->moratoireDecision[] = $moratoireDecision;

        return $this;
    }

    /**
     * Remove moratoireDecision
     *
     * @param \AMLA\SqrBundle\Entity\Moratoire $moratoireDecision
     */
    public function removeMoratoireDecision(\AMLA\SqrBundle\Entity\Moratoire $moratoireDecision)
    {
        $this->moratoireDecision->removeElement($moratoireDecision);
    }

    /**
     * Get moratoireDecision
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMoratoireDecision()
    {
        return $this->moratoireDecision;
    }

    /**
     * Add remiseGracieuseDecision
     *
     * @param \AMLA\SqrBundle\Entity\RemiseGracieuse $remiseGracieuseDecision
     *
     * @return Account
     */
    public function addRemiseGracieuseDecision(\AMLA\SqrBundle\Entity\RemiseGracieuse $remiseGracieuseDecision)
    {
        $this->remiseGracieuseDecision[] = $remiseGracieuseDecision;

        return $this;
    }

    /**
     * Remove remiseGracieuseDecision
     *
     * @param \AMLA\SqrBundle\Entity\RemiseGracieuse $remiseGracieuseDecision
     */
    public function removeRemiseGracieuseDecision(\AMLA\SqrBundle\Entity\RemiseGracieuse $remiseGracieuseDecision)
    {
        $this->remiseGracieuseDecision->removeElement($remiseGracieuseDecision);
    }

    /**
     * Get remiseGracieuseDecision
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getRemiseGracieuseDecision()
    {
        return $this->remiseGracieuseDecision;
    }

    /**
     * Set compagnyId
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $compagnyId
     *
     * @return Account
     */
    public function setCompagnyId(\AMLA\SqrBundle\Entity\Fournissseur $compagnyId = null)
    {
        $this->compagnyId = $compagnyId;

        return $this;
    }

    /**
     * Get compagnyId
     *
     * @return \AMLA\SqrBundle\Entity\Fournissseur
     */
    public function getCompagnyId()
    {
        return $this->compagnyId;
    }

    /**
     * Set localisation
     *
     * @param string $localisation
     *
     * @return Account
     */
    public function setLocalisation($localisation)
    {
        $this->localisation = $localisation;

        return $this;
    }

    /**
     * Get localisation
     *
     * @return string
     */
    public function getLocalisation()
    {
        return $this->localisation;
    }

    /**
     * Add service
     *
     * @param \AMLA\SqrBundle\Entity\Service $service
     *
     * @return Account
     */
    public function addService(\AMLA\SqrBundle\Entity\Service $service)
    {
        $this->service[] = $service;

        return $this;
    }

    /**
     * Remove service
     *
     * @param \AMLA\SqrBundle\Entity\Service $service
     */
    public function removeService(\AMLA\SqrBundle\Entity\Service $service)
    {
        $this->service->removeElement($service);
    }

    /**
     * Get service
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getService()
    {
        return $this->service;
    }

    /**
     * Add fine
     *
     * @param \AMLA\SqrBundle\Entity\Fine $fine
     *
     * @return Account
     */
    public function addFine(\AMLA\SqrBundle\Entity\Fine $fine)
    {
        $this->fine[] = $fine;

        return $this;
    }

    /**
     * Remove fine
     *
     * @param \AMLA\SqrBundle\Entity\Fine $fine
     */
    public function removeFine(\AMLA\SqrBundle\Entity\Fine $fine)
    {
        $this->fine->removeElement($fine);
    }

    /**
     * Get fine
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFine()
    {
        return $this->fine;
    }

    /**
     * Add quittance
     *
     * @param \AMLA\SqrBundle\Entity\Quittance $quittance
     *
     * @return Account
     */
    public function addQuittance(\AMLA\SqrBundle\Entity\Quittance $quittance)
    {
        $this->quittance[] = $quittance;

        return $this;
    }

    /**
     * Remove quittance
     *
     * @param \AMLA\SqrBundle\Entity\Quittance $quittance
     */
    public function removeQuittance(\AMLA\SqrBundle\Entity\Quittance $quittance)
    {
        $this->quittance->removeElement($quittance);
    }

    /**
     * Get quittance
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getQuittance()
    {
        return $this->quittance;
    }

    /**
     * Set matricule
     *
     * @param string $matricule
     *
     * @return Account
     */
    public function setMatricule($matricule)
    {
        $this->matricule = $matricule;

        return $this;
    }

    /**
     * Get matricule
     *
     * @return string
     */
    public function getMatricule()
    {
        return $this->matricule;
    }

    /**
     * Add exchange
     *
     * @param \AMLA\SqrBundle\Entity\Exchange $exchange
     *
     * @return Account
     */
    public function addExchange(\AMLA\SqrBundle\Entity\Exchange $exchange)
    {
        $this->exchange[] = $exchange;

        return $this;
    }

    /**
     * Remove exchange
     *
     * @param \AMLA\SqrBundle\Entity\Exchange $exchange
     */
    public function removeExchange(\AMLA\SqrBundle\Entity\Exchange $exchange)
    {
        $this->exchange->removeElement($exchange);
    }

    /**
     * Get exchange
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getExchange()
    {
        return $this->exchange;
    }

    /**
     * Add approvisionner
     *
     * @param \AMLA\SqrBundle\Entity\Approvisionner $approvisionner
     *
     * @return Account
     */
    public function addApprovisionner(\AMLA\SqrBundle\Entity\Approvisionner $approvisionner)
    {
        $this->approvisionner[] = $approvisionner;

        return $this;
    }

    /**
     * Remove approvisionner
     *
     * @param \AMLA\SqrBundle\Entity\Approvisionner $approvisionner
     */
    public function removeApprovisionner(\AMLA\SqrBundle\Entity\Approvisionner $approvisionner)
    {
        $this->approvisionner->removeElement($approvisionner);
    }

    /**
     * Get approvisionner
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getApprovisionner()
    {
        return $this->approvisionner;
    }

    /**
     * Add subscriptionInbill.
     *
     * @param \AMLA\SqrBundle\Entity\SubscriptionInbill $subscriptionInbill
     *
     * @return Account
     */
    public function addSubscriptionInbill(\AMLA\SqrBundle\Entity\SubscriptionInbill $subscriptionInbill)
    {
        $this->subscriptionInbill[] = $subscriptionInbill;

        return $this;
    }

    /**
     * Remove subscriptionInbill.
     *
     * @param \AMLA\SqrBundle\Entity\SubscriptionInbill $subscriptionInbill
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeSubscriptionInbill(\AMLA\SqrBundle\Entity\SubscriptionInbill $subscriptionInbill)
    {
        return $this->subscriptionInbill->removeElement($subscriptionInbill);
    }

    /**
     * Get subscriptionInbill.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getSubscriptionInbill()
    {
        return $this->subscriptionInbill;
    }

    /**
     * Set niu.
     *
     * @param string|null $niu
     *
     * @return Account
     */
    public function setNiu($niu = null)
    {
        $this->niu = $niu;

        return $this;
    }

    /**
     * Get niu.
     *
     * @return string|null
     */
    public function getNiu()
    {
        return $this->niu;
    }

    /**
     * Add planifierPaiement.
     *
     * @param \AMLA\SqrBundle\Entity\PlanifierPaiement $planifierPaiement
     *
     * @return Account
     */
    public function addPlanifierPaiement(\AMLA\SqrBundle\Entity\PlanifierPaiement $planifierPaiement)
    {
        $this->planifierPaiement[] = $planifierPaiement;

        return $this;
    }

    /**
     * Remove planifierPaiement.
     *
     * @param \AMLA\SqrBundle\Entity\PlanifierPaiement $planifierPaiement
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removePlanifierPaiement(\AMLA\SqrBundle\Entity\PlanifierPaiement $planifierPaiement)
    {
        return $this->planifierPaiement->removeElement($planifierPaiement);
    }

    /**
     * Get planifierPaiement.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPlanifierPaiement()
    {
        return $this->planifierPaiement;
    }
}
