<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AccessInBill
 *
 * @ORM\Table(name="access_in_bill")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\AccessInBillRepository")
 */
class AccessInBill
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Repertoire", inversedBy="accessInBill")
     * @ORM\JoinColumn(name="repertoire_id", referencedColumnName="id")
     */
    private $repertoire;

    /**
     * @ORM\ManyToOne(targetEntity="InBill", inversedBy="accessInBill")
     * @ORM\JoinColumn(name="in_bill_id", referencedColumnName="id")
     */
    private $inBill;

    /**
     * @var bool
     *
     * @ORM\Column(name="isDevis", type="boolean", nullable=true)
     */
    private $isDevis;

    /**
     * @var bool
     *
     * @ORM\Column(name="isFacture", type="boolean", nullable=true)
     */
    private $isFacture;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
    }
    
    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }


    /**
     * Set isDevis.
     *
     * @param bool|null $isDevis
     *
     * @return AccessInBill
     */
    public function setIsDevis($isDevis = null)
    {
        $this->isDevis = $isDevis;

        return $this;
    }

    /**
     * Get isDevis.
     *
     * @return bool|null
     */
    public function getIsDevis()
    {
        return $this->isDevis;
    }

    /**
     * Set isFacture.
     *
     * @param bool|null $isFacture
     *
     * @return AccessInBill
     */
    public function setIsFacture($isFacture = null)
    {
        $this->isFacture = $isFacture;

        return $this;
    }

    /**
     * Get isFacture.
     *
     * @return bool|null
     */
    public function getIsFacture()
    {
        return $this->isFacture;
    }

    /**
     * Set dateCreated.
     *
     * @param \DateTime $dateCreated
     *
     * @return AccessInBill
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated.
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set repertoire.
     *
     * @param \AMLA\SqrBundle\Entity\Repertoire|null $repertoire
     *
     * @return AccessInBill
     */
    public function setRepertoire(\AMLA\SqrBundle\Entity\Repertoire $repertoire = null)
    {
        $this->repertoire = $repertoire;

        return $this;
    }

    /**
     * Get repertoire.
     *
     * @return \AMLA\SqrBundle\Entity\Repertoire|null
     */
    public function getRepertoire()
    {
        return $this->repertoire;
    }

    /**
     * Set inBill.
     *
     * @param \AMLA\SqrBundle\Entity\InBill|null $inBill
     *
     * @return AccessInBill
     */
    public function setInBill(\AMLA\SqrBundle\Entity\InBill $inBill = null)
    {
        $this->inBill = $inBill;

        return $this;
    }

    /**
     * Get inBill.
     *
     * @return \AMLA\SqrBundle\Entity\InBill|null
     */
    public function getInBill()
    {
        return $this->inBill;
    }
}
