<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ATDCantonne
 *
 * @ORM\Table(name="a_t_d_cantonne")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\ATDCantonneRepository")
 */
class ATDCantonne
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\Column(name="numero_cantonnement", type="integer")
     */
    private $numeroCantonnement;

    /**
     * @var int
     *
     * @ORM\Column(name="numero_atd", type="integer")
     */
    private $numeroAtd;

    /**
     * @var float
     *
     * @ORM\Column(name="montant", type="float")
     */
    private $montant;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_cantonnement", type="datetime")
     */
    private $dateCantonnement;

    /**
     * @var string
     *
     * @ORM\Column(name="source_cantonnement", type="string", length=255)
     */
    private $sourceCantonnement;

    /**
     * @var string
     *
     * @ORM\Column(name="lieu_cantonnement", type="string", length=255)
     */
    private $lieuCantonnement;

    /**
     * @var int
     *
     * @ORM\Column(name="account", type="integer")
     */
    private $account;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="created_at", type="datetime")
     */
    private $createdAt;

    /**
     * @var string
     *
     * @ORM\Column(name="reference_impot", type="string", length=50)
     */
    private $referenceImpot;

    /**
     * @var string
     *
     * @ORM\Column(name="reference_checktatoo", type="string", length=50)
     */
    private $referenceChecktatoo;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set numeroCantonnement
     *
     * @param integer $numeroCantonnement
     *
     * @return ATDCantonne
     */
    public function setNumeroCantonnement($numeroCantonnement)
    {
        $this->numeroCantonnement = $numeroCantonnement;

        return $this;
    }

    /**
     * Get numeroCantonnement
     *
     * @return int
     */
    public function getNumeroCantonnement()
    {
        return $this->numeroCantonnement;
    }

    /**
     * Set numeroAtd
     *
     * @param integer $numeroAtd
     *
     * @return ATDCantonne
     */
    public function setNumeroAtd($numeroAtd)
    {
        $this->numeroAtd = $numeroAtd;

        return $this;
    }

    /**
     * Get numeroAtd
     *
     * @return int
     */
    public function getNumeroAtd()
    {
        return $this->numeroAtd;
    }

    /**
     * Set montant
     *
     * @param float $montant
     *
     * @return ATDCantonne
     */
    public function setMontant($montant)
    {
        $this->montant = $montant;

        return $this;
    }

    /**
     * Get montant
     *
     * @return float
     */
    public function getMontant()
    {
        return $this->montant;
    }

    /**
     * Set dateCantonnement
     *
     * @param \DateTime $dateCantonnement
     *
     * @return ATDCantonne
     */
    public function setDateCantonnement($dateCantonnement)
    {
        $this->dateCantonnement = $dateCantonnement;

        return $this;
    }

    /**
     * Get dateCantonnement
     *
     * @return \DateTime
     */
    public function getDateCantonnement()
    {
        return $this->dateCantonnement;
    }

    /**
     * Set sourceCantonnement
     *
     * @param string $sourceCantonnement
     *
     * @return ATDCantonne
     */
    public function setSourceCantonnement($sourceCantonnement)
    {
        $this->sourceCantonnement = $sourceCantonnement;

        return $this;
    }

    /**
     * Get sourceCantonnement
     *
     * @return string
     */
    public function getSourceCantonnement()
    {
        return $this->sourceCantonnement;
    }

    /**
     * Set lieuCantonnement
     *
     * @param string $lieuCantonnement
     *
     * @return ATDCantonne
     */
    public function setLieuCantonnement($lieuCantonnement)
    {
        $this->lieuCantonnement = $lieuCantonnement;

        return $this;
    }

    /**
     * Get lieuCantonnement
     *
     * @return string
     */
    public function getLieuCantonnement()
    {
        return $this->lieuCantonnement;
    }

    /**
     * Set account
     *
     * @param integer $account
     *
     * @return ATDCantonne
     */
    public function setAccount($account)
    {
        $this->account = $account;

        return $this;
    }

    /**
     * Get account
     *
     * @return int
     */
    public function getAccount()
    {
        return $this->account;
    }

    /**
     * Set createdAt
     *
     * @param \DateTime $createdAt
     *
     * @return ATDCantonne
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Set referenceImpot
     *
     * @param string $referenceImpot
     *
     * @return ATDCantonne
     */
    public function setReferenceImpot($referenceImpot)
    {
        $this->referenceImpot = $referenceImpot;

        return $this;
    }

    /**
     * Get referenceImpot
     *
     * @return string
     */
    public function getReferenceImpot()
    {
        return $this->referenceImpot;
    }

    /**
     * Set referenceChecktatoo
     *
     * @param string $referenceChecktatoo
     *
     * @return ATDCantonne
     */
    public function setReferenceChecktatoo($referenceChecktatoo)
    {
        $this->referenceChecktatoo = $referenceChecktatoo;

        return $this;
    }

    /**
     * Get referenceChecktatoo
     *
     * @return string
     */
    public function getReferenceChecktatoo()
    {
        return $this->referenceChecktatoo;
    }
}
