<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\statutJuridique;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Statutjuridique controller.
 *
 * @Route("statutjuridique/{_locale}", defaults = {"_locale" = "fr"})
 */
class statutJuridiqueController extends Controller
{
    /**
     * Lists all statutJuridique entities.
     *
     * @Route("/", name="statutjuridique_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $statutJuridiques = $em->getRepository('AMLASqrBundle:statutJuridique')->findAll();

        return $this->render('statutjuridique/index.html.twig', array(
            'statutJuridiques' => $statutJuridiques,
        ));
    }

    /**
     * Creates a new statutJuridique entity.
     *
     * @Route("/new", name="statutjuridique_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $statutJuridique = new Statutjuridique();
        $form = $this->createForm('AMLA\SqrBundle\Form\statutJuridiqueType', $statutJuridique);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($statutJuridique);
            $em->flush();

            return $this->redirectToRoute('statutjuridique_show', array('id' => $statutJuridique->getId()));
        }

        return $this->render('statutjuridique/new.html.twig', array(
            'statutJuridique' => $statutJuridique,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a statutJuridique entity.
     *
     * @Route("/{id}", name="statutjuridique_show")
     * @Method("GET")
     */
    public function showAction(statutJuridique $statutJuridique)
    {
        $deleteForm = $this->createDeleteForm($statutJuridique);

        return $this->render('statutjuridique/show.html.twig', array(
            'statutJuridique' => $statutJuridique,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing statutJuridique entity.
     *
     * @Route("/{id}/edit", name="statutjuridique_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, statutJuridique $statutJuridique)
    {
        $deleteForm = $this->createDeleteForm($statutJuridique);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\statutJuridiqueType', $statutJuridique);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('statutjuridique_edit', array('id' => $statutJuridique->getId()));
        }

        return $this->render('statutjuridique/edit.html.twig', array(
            'statutJuridique' => $statutJuridique,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a statutJuridique entity.
     *
     * @Route("/{id}", name="statutjuridique_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, statutJuridique $statutJuridique)
    {
        $form = $this->createDeleteForm($statutJuridique);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($statutJuridique);
            $em->flush();
        }

        return $this->redirectToRoute('statutjuridique_index');
    }

    /**
     * Creates a form to delete a statutJuridique entity.
     *
     * @param statutJuridique $statutJuridique The statutJuridique entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(statutJuridique $statutJuridique)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('statutjuridique_delete', array('id' => $statutJuridique->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
