<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Verification;
use AMLA\SqrBundle\Entity\ImpotVerify;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use AMLA\SqrBundle\API\SqrApi as SqrApi; 
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;

/**
 * Verification controller.
 *
 * @Route("verification/{_locale}", defaults = {"_locale" = "fr"})
 */
class VerificationController extends Controller
{

    /**
     * Lists all verification entities.
     *
     * @Route("/", name="verification_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $verifications = $em->getRepository('AMLASqrBundle:Verification')->findAll();

        return $this->render('verification/index.html.twig', array(
            'verifications' => $verifications,
        ));
    }

    /**
     * Lists all verification entities.
     *
     * @Route("/history", name="verification_history")
     * @Method("GET")
     */
    public function historyAction()
    {
        $em = $this->getDoctrine()->getManager();

        $impotVerifications = $em->getRepository('AMLASqrBundle:ImpotVerify')->findby(['account'=>$this->getUser()],['id'=>'desc']);

        return $this->render('verification/history.html.twig', array(
            'impotVerifications' => $impotVerifications,
        ));
    }


    /**
     * Finds and displays a verification entity.
     *
     * @Route("/{id}/detail", name="verification_impot_show")
     * @Method("GET")
     */
    public function showImpotVerifDetailAction(ImpotVerify $impotVerify)
    {      

        return $this->render('verification/show_history.html.twig', array(
            'impotVerif' => $impotVerify,
        ));
    }
    
    /**
     * Lists all verification entities.
     *
     * @Route("/api/impot", name="verification_api_impot")
     *  @Method({"GET","POST"})
     */
    public function apiImpotAction(Request $request)
    {
        if($_POST)
        {
            switch ($request->get('action')) 
            {
                case 'ANR':
                    # code...
                    if((!empty($request->get('numAnr'))) || (!empty($request->get('niuForAnr'))))
                    {
                        $numANR = $request->get('numAnr');
                        $niuForAnr = $request->get('niuForAnr');
                        if($numANR)
                        {
                            $val = $numANR;
                            $critere = 'Numéro ANR';
                            $url = $this->getParameter('api_impot').'ANR?numero_anr='.$numANR.'&idshare_application=ENEO';
                        }elseif($niuForAnr)
                        {
                            $val = $niuForAnr;
                            $critere = 'NIU';
                            $url = $this->getParameter('api_impot').'ANR?niu='.$niuForAnr.'&idshare_application=ENEO';
                        }
                        $ch = curl_init();
                        $options = [
                            CURLOPT_URL => $url,
                            CURLOPT_POST => 0,
                            //CURLOPT_POSTFIELDS => '',
                            CURLOPT_HTTPHEADER => array('Content-Type: multipart/form-data'),
                            CURLOPT_RETURNTRANSFER => true,
                        ];
                        curl_setopt_array($ch, $options);
                        $response = curl_exec($ch);
                        $response = json_decode($response,true);
                        curl_close($ch);

                        if(!empty($response))
                        {
                            $post = array(
                            'Date de début' =>$response[0]['date_debut'],
                            'Date de fin' =>$response[0]['date_fin'],        
                            'Date insertion' =>$response[0]['date_insertion'],      
                            'Montant du' =>$response[0]['montant_du'],      
                            'NIU' =>$response[0]['niu'],             
                            'Numéro ANR' =>$response[0]['numero_anr'],      
                            'Raison Sociale' =>$response[0]['raison_sociale'],   
                            'Référence impot' =>$response[0]['reference_impot'],  
                            'Date Générée' =>$response[0]['date_generated'],       
                            );

                            $apiCall = $this->sqrGetCode($post, $request->get('action'), $critere, $val, $response[0]['reference_impot'], $response[0]['date_generated']);
                            //dump($apiCall['niu']);die;
                       
                            $niuRef = $apiCall['niu'];
                            $niuImpot =$response[0]['niu'];
                        }else
                        {
                            $niuRef = null;
                            $niuImpot =null;
                        }            

                        return $this->render('verification/new.html.twig', array(
                            'checkAnrs' => $response,
                            'result'=>0,
                            'critere'=>$critere,
                            'value'=>$val,
                            'checktatooRef'=>$niuRef,
                            'fwdNiu'=>$niuImpot,
                        ));
                    }
                    break;
                case 'ATD':
                    # code...
                    
                    if((!empty($request->get('atdNum'))) || (!empty($request->get('atdNiu'))))
                    {
                        $atdNum = $request->get('atdNum');
                        $atdNiu = $request->get('atdNiu');
                        if($atdNum)
                        {
                            $val = $atdNum;
                            $critere = 'Numéro ATD';
                            $url = $this->getParameter('api_impot').'ATD?numero_atd='.$atdNum.'&idshare_application=ENEO';
                        }elseif($atdNiu)
                        {                   
                            $critere = 'NIU';
                            $val = $atdNiu;
                            $url = $this->getParameter('api_impot').'ATD?niu='.$atdNiu.'&idshare_application=ENEO';
                        }
                        $ch = curl_init();
                        $options = [
                            CURLOPT_URL => $url,
                            CURLOPT_POST => 0,
                            //CURLOPT_POSTFIELDS => '',
                            CURLOPT_HTTPHEADER => array('Content-Type: multipart/form-data'),
                            CURLOPT_RETURNTRANSFER => true,
                        ];
                        curl_setopt_array($ch, $options);
                        $responseAtd = curl_exec($ch);
                        $responseAtd = json_decode($responseAtd,true);
                        curl_close($ch);
                        //dump($responseAtd);die;
                        
                        if(!empty($responseAtd))
                        {
                            $post = array(
                            'Numéro ATD' =>$responseAtd[0]['numero_atd'],
                            'Raison Sociale' =>$responseAtd[0]['raison_sociale'],
                            'NIU' =>$responseAtd[0]['niu'],        
                            'Date insertion' =>$responseAtd[0]['date_insertion'],      
                            'Montant du' =>$responseAtd[0]['montant_du'],      
                            'Montant payé' =>$responseAtd[0]['montant_paye'],      
                            'Reste à payer' =>$responseAtd[0]['reste'],           
                            'Montant cantonné' =>$responseAtd[0]['montant_cantonne'],        
                            'Référence impot' =>$responseAtd[0]['reference_impot'],  
                            'Date Générée' =>$responseAtd[0]['date_generated'],       
                            );

                            $apiCall = $this->sqrGetCode($post, $request->get('action'), $critere, $val, $responseAtd[0]['reference_impot'], $responseAtd[0]['date_generated']);
                            //dump($apiCall['niu']);die;
                            $niuRef = $apiCall['niu'];
                            $niuImpot =$responseAtd[0]['niu'];
                        }else
                        {
                            $niuRef = null;
                            $niuImpot =null;
                        }   

                        return $this->render('verification/new.html.twig', array(
                            'checkAtds' => $responseAtd,
                            'result'=>1,
                            'critere'=>$critere,
                            'value'=>$val,
                            'checktatooRef'=>$niuRef,
                            'fwdNiu'=>$niuImpot,
                        ));
                    }
                    break;
                case 'CONTRIBUABLE':
                    # code...                    
                    if(!empty($request->get('niuContribuable')))
                    {
                        $niuContribuable = $request->get('niuContribuable');
                        if($niuContribuable)
                        {
                            $val = $niuContribuable;
                            $critere = 'NIU';
                            $url = 'http://teledeclaration-dgi.cm:1020/api/Contribuable2?niu='.$niuContribuable.'&idshare_application=ENEO';
                        }
                        //dump($url);
                        $ch = curl_init();
                        $options = [
                            CURLOPT_URL => $url,
                            CURLOPT_POST => 0,
                            //CURLOPT_POSTFIELDS => '',
                            CURLOPT_HTTPHEADER => array('Content-Type: multipart/form-data'),
                            CURLOPT_RETURNTRANSFER => true,
                        ];
                        curl_setopt_array($ch, $options);
                        $responseContribuable = curl_exec($ch);
                        $responseContribuable = json_decode($responseContribuable,true);
                        curl_close($ch);
                        //dump($responseContribuable);die;
                        if($responseContribuable[0]['message'] == 'OK')
                        {
                            $post = array(      
                                'NIU' =>$responseContribuable[0]['niu'],  
                                'Raison Sociale' =>$responseContribuable[0]['raison_sociale'],   
                                'Sigle' =>$responseContribuable[0]['sigle'],   
                                'Activité principale' =>$responseContribuable[0]['activiteprincipale'],
                                'Classe activité' =>$responseContribuable[0]['classeactivite'],        
                                'Régime fiscal' =>$responseContribuable[0]['regimefiscal'],          
                                'Forme juridique' =>$responseContribuable[0]['formejuridique'],          
                                'Téléphone' =>$responseContribuable[0]['telephone'],          
                                'Centre des impots' =>$responseContribuable[0]['centre_des_impots'],      
                                'Centre régional' =>$responseContribuable[0]['centre_regional'],           
                                'Boite postale' =>$responseContribuable[0]['bp'],              
                                'Ville' =>$responseContribuable[0]['ville'],              
                                'Quartier' =>$responseContribuable[0]['quartier'],              
                                'Lieu dit' =>$responseContribuable[0]['lieu_dit'],               
                                'Etat' =>$responseContribuable[0]['etat'],           
                                'Référence impot' =>$responseContribuable[0]['reference_impot'],  
                                'Date Générée' =>$responseContribuable[0]['date_generated'],       
                            );

                            $apiCall = $this->sqrGetCode($post, $request->get('action'), $critere, $val, $responseContribuable[0]['reference_impot'], $responseContribuable[0]['date_generated']);
                            //dump($apiCall['niu']);die;
                            $niuRef = $apiCall['niu'];
                            $niuImpot = $responseContribuable[0]['niu'];

                        }elseif($responseContribuable[0]['message'] == 'KO')
                        {
                            $niuImpot= null;
                            $niuRef = null;
                        }
                        //dump($responseContribuable);die;
                        //M110600037622F //P012500025988S
                        return $this->render('verification/new.html.twig', array(
                            'contribuables' => $responseContribuable,
                            'result'=>1,
                            'critere'=>$critere,
                            'value'=>$val,
                            'checktatooRef'=>$niuRef,
                            'fwdNiu'=>$niuImpot,
                        ));
                    }
                    break;
                default:
                    # code...
                    $this->get('session')->getFlashBag()->add('info', 'Une erreur est survenue. Essayez à nouveau.');
                    break;
            }
        }
        

        return $this->render('verification/new.html.twig', array(
            //'verifications' => $verifications,
        ));
    }


    /**
     * Verify informations.
     *
     * @Route("/value", name="verification_value")
     * @Method({"GET","POST"})
     */
    public function VerifAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();

        $valeur = $request->get('valeur');
        $type = $request->get('type');

        switch ($type) 
        {
            case 'niu':
                $compname = $request->get('compname');

                if($valeur)
                {
                    $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['niu'=>$valeur]);
                    
                }elseif ($compname) 
                {
                    $fournisseur = count($em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['raisonSociale'=>$compname]));
                }

                $verif = ($fournisseur == NULL) ? false : true;
                $response = array('verification'=>$verif);
                $response = new JsonResponse($response);
                return $response;
                break;
            case 'anr':
                $datejour = new \Datetime("now");
                $anr = $em->getRepository('AMLASqrBundle:Anr')->findOneBy(['referenceANR'=>$valeur]);
                if ($anr != NULL) 
                {
                    $verif = ($anr->getDateFin() < $datejour ) ? false : true;
                }else 
                {
                    $verif = false;
                }
                $response = array('verification'=>$verif);
                $response = new JsonResponse($response);
                return $response;
                break;
            case 'atd':
                $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['niu'=>$valeur]);
                if ($fournisseur != NULL) 
                {
                    $atd = $em->getRepository('AMLASqrBundle:Atd')->findOneBy(['misEnCause'=>$fournisseur->getNiu()]);
                    if ($atd != NULL ) 
                    {
                        if($atd->getMontant()>0){
                            $verif = true;
                        }else{
                            $verif = false;
                        }                
                    }
                    else
                    {
                        $verif = false;
                    }
                    
                }else
                {
                    $verif = false;
                }
                $response = array('verification'=>$verif);
                $response = new JsonResponse($response);
                return $response;
                break;
            case 'bon':
                $boncommande = $em->getRepository('AMLASqrBundle:BonCommande')->findOneBy(['reference'=>$valeur]);
                $verif = ($boncommande == NULL) ? false : true;
                $response = array('verification'=>$verif);
                $response = new JsonResponse($response);
                return $response;
                break;
            case 'facture':
                $facture = $em->getRepository('AMLASqrBundle:Facture')->findOneBy(['reference'=>$valeur]);
                $verif = ($facture == NULL) ? false : true;
                $response = array('verification'=>$verif);
                $response = new JsonResponse($response);
                return $response;
                break;
            case 'rap':
                $facture = $em->getRepository('AMLASqrBundle:Facture')->findOneBy(['reference'=>$valeur]);
                $verif = ($facture == NULL) ? false : true;
                if ($facture != NULL) 
                {
                    $resteapayer = $facture->getReceptionTravaux()->getBonCommande()->getRestePaye();
                }else
                {
                    $resteapayer = 'Pas de résultat';
                }
                $response = array('verification'=>$verif,'reste'=>$resteapayer);
                $response = new JsonResponse($response);
                return $response;
                break;
            case 'pp':
                $facture = $em->getRepository('AMLASqrBundle:Facture')->findOneBy(['reference'=>$valeur]);
                $verif = ($facture == NULL) ? false : true;
                if ($facture != NULL) 
                {
                    $montant = $facture->getMontant();
                }else
                {
                    $montant = 'Pas de résultat';
                }
                $response = array('verification'=>$verif,'montant'=>$montant);
                $response = new JsonResponse($response);
                return $response;
                break;
            default:
                # code...
                break;
        }

    }

    /**
     * Creates a new verification entity.
     *
     * @Route("/new", name="verification_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $verification = new Verification();
        $form = $this->createForm('AMLA\SqrBundle\Form\VerificationType', $verification);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) 
        {
            $em = $this->getDoctrine()->getManager();
            $em->persist($verification);
            $em->flush();

            return $this->redirectToRoute('verification_show', array('id' => $verification->getId()));
        }

        return $this->render('verification/new.old.07-05-2020.html.twig', array(
            'verification' => $verification,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a verification entity.
     *
     * @Route("/{id}", name="verification_show")
     * @Method("GET")
     */
    public function showAction(Verification $verification)
    {
        $deleteForm = $this->createDeleteForm($verification);

        return $this->render('verification/show.html.twig', array(
            'verification' => $verification,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing verification entity.
     *
     * @Route("/{id}/edit", name="verification_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Verification $verification)
    {
        $deleteForm = $this->createDeleteForm($verification);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\VerificationType', $verification);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) 
        {
            $this->getDoctrine()->getManager()->flush();
            return $this->redirectToRoute('verification_edit', array('id' => $verification->getId()));
        }

        return $this->render('verification/edit.html.twig', array(
            'verification' => $verification,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a verification entity.
     *
     * @Route("/{id}", name="verification_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Verification $verification)
    {
        $form = $this->createDeleteForm($verification);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) 
        {
            $em = $this->getDoctrine()->getManager();
            $em->remove($verification);
            $em->flush();
        }

        return $this->redirectToRoute('verification_index');
    }

    /**
     * Creates a form to delete a verification entity.
     *
     * @param Verification $verification The verification entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Verification $verification)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('verification_delete', array('id' => $verification->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }

    /*private function sqrGetCode(array $post, $action, $critere, $val, $refImpot,$dateImpot)
    {        
        
        $em = $this->getDoctrine()->getManager();
        $cle = $this->container->getParameter('api_key');
        
        $keyParam = array(
            'cle' => $this->container->getParameter('api_key'),
            'pieceqr'=> 'Vérification-'.$action,
            'proprietaire' => $this->getUser()->getNom().' '.$this->getUser()->getPrenom(),
        );
        
        $dataToSend = array_merge($keyParam, $post);
        //dump($keyParam);dump($post);dump($dataToSend);die;

        $container = $this->container;
        $api = new SqrApi($container);
        $res = $api->callAPI($dataToSend);
        
        if($res[0])
        {            
            $qr = $res[0]->qr;
            $num = $res[0]->niu;             

            $impotVerif = new ImpotVerify;

            $impotVerif->setChecktatooNiuRef($num);
            $impotVerif->setChecktatooSqrRef($qr);
            //$impotVerif->setChecktatooDateGenerated();
            $impotVerif->setVerificationType($action);
            $impotVerif->setCriteria($critere);
            $impotVerif->setDataToVerify($val);
            $impotVerif->setImpotReference($refImpot);
            $impotVerif->setImpotDateGenerated($dateImpot);
            $impotVerif->setAccount($this->getUser());

            $em->persist($impotVerif);
            $em->flush();
            $result = array(
                'qr' => $qr,
                'niu'=> $num,
            );

        }else
        {
            $result=null;
        }
        

        return $result;

    }*/
    private function sqrGetCode(array $post, $action, $critere, $val, $refImpot,$dateImpot)
    {        
        
        $em = $this->getDoctrine()->getManager();
        $cle = $this->container->getParameter('api_key');
        
        $keyParam = array(
            'cle' => $this->container->getParameter('api_key'),
            'pieceqr'=> 'Vérification-'.$action,
            'proprietaire' => $this->getUser()->getNom().' '.$this->getUser()->getPrenom(),
        );
        
        $dataToSend = array_merge($keyParam, $post);
        //dump($post);dump($post['Raison Sociale']);dump($dataToSend);die;

        $container = $this->container;
        $api = new SqrApi($container);
        $res = $api->callAPI($dataToSend);

        if($res[0])
        {            
            $qr = $res[0]->qr;
            $num = $res[0]->niu; 

            $impotVerif = new ImpotVerify;

            $impotVerif->setChecktatooNiuRef($num);
            $impotVerif->setChecktatooSqrRef($qr);

            // on nouri l'objet impot vérif
            //$impotVerif->setChecktatooDateGenerated();
            $impotVerif->setVerificationType($action);
            $impotVerif->setCriteria($critere);
            $impotVerif->setDataToVerify($val);
            $impotVerif->setImpotReference($refImpot);
            $impotVerif->setImpotDateGenerated($dateImpot);
            $impotVerif->setAccount($this->getUser());

            switch ($action) 
            {
                case 'ANR':
                {
                    $impotVerif->setAnr($post['Numéro ANR']);
                    $impotVerif->setNiu($post['NIU']);
                    $impotVerif->setRaisonSociale($post['Raison Sociale']);
                    $impotVerif->setDateInsertion($post['Date insertion']);
                    $impotVerif->setDateDelivrance($post['Date de début']);
                    $impotVerif->setMontantDu($post['Montant du']);
                    $impotVerif->setDateExpiration($post['Date de fin']);
                }
                break;
                case 'ATD':
                {
                    $impotVerif->setAtd($post['Numéro ATD']);
                    $impotVerif->setRaisonSociale($post['Raison Sociale']);
                    $impotVerif->setNiu($post['NIU']);
                    //$impotVerif->setDateInsertion($post['Date insertion']);
                    $impotVerif->setMontantDu($post['Montant du']);
                    $impotVerif->setMontantPaye($post['Montant payé']);
                    $impotVerif->setRestePaye($post['Reste à payer']);
                    $impotVerif->setMontantCantonne($post['Montant cantonné']);
                }
                break;
                case 'CONTRIBUABLE':
                {
                    $impotVerif->setNiu($post['NIU']);
                    $impotVerif->setRaisonSociale($post['Raison Sociale']);
                    $impotVerif->setSigle($post['Sigle']);
                    $impotVerif->setActivitePrincipale($post['Activité principale']);
                    $impotVerif->setClasseActvite($post['Classe activité']);
                    $impotVerif->setRegimeFiscal($post['Régime fiscal']);
                    $impotVerif->setFormeJuridique($post['Forme juridique']);        
                    $impotVerif->setTelephone($post['Téléphone']);
                    $impotVerif->setCentreImpot($post['Centre des impots']);
                    $impotVerif->setCentreRegional($post['Centre régional']);
                    $impotVerif->setBoitePostale($post['Boite postale']);
                    $impotVerif->setVille($post['Ville']);
                    //$impotVerif->setCommune($post['commune']);        
                    $impotVerif->setQuartier($post['Quartier']);
                    $impotVerif->setLieuDit($post['Lieu dit']);
                    $impotVerif->setEtat($post['Etat']);
                }
                break;
                default:
                # code...
                //$this->get('session')->getFlashBag()->add('info', 'Une erreur est survenue. Essayez à nouveau.');

                break;
            }            

            //start attestation vérif
            $newname = 'ATTEST_VERIF'.date('YmdHis',time()).mt_rand(0,1000).'.png';

            $name = 'ATTEST_VERIF_IMPOT'.mt_rand(0,1000).$num.'.pdf';
            $target = __DIR__.'/../../../../web/Production_documentaire/Impots/';

            $checkqr = $api->generateQr($qr,$num,$newname);
            $checkqr->setChemin($newname);
            //dump($checkqr);die;
            $impotVerif->setQrCode($checkqr);  
            $impotVerif->setPdf('/Production_documentaire/Impots/'.$name);         

            $pdf = $this->renderView('attestationverification/attestation_verif_impot.html.twig', array(
                'imageqr'=> $impotVerif->getQrCode()->getChemin(),
                'impotVerif' => $impotVerif,
                'base_dir' => $this->get('kernel')->getRootDir() . '/../web',
                ));

            try{

                $mpdf = new \Mpdf\Mpdf();
                $mpdf->WriteHtml($pdf);
                if (file_exists($target) != 1) 
                {        
                    mkdir($target,0777,true);
                    $mpdf->Output($target.$name, 'F');
                }else
                {
                    $mpdf->Output($target.$name, 'F');
                }
        
            }catch(MpdfException $e)
            {
        
                die($e->getMessage());
            }
            /// end attestation vérif
            
            $em->persist($checkqr);
            $em->persist($impotVerif);
            $em->flush();
            $result = array(
                'qr' => $qr,
                'niu'=> $num,
            );
           
        }else
        {
            $result=null;
        }
        
        return $result;

    }
}
