<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Fournissseur;
use AMLA\SqrBundle\Entity\TvaHistory;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Tvahistory controller.
 *
 * @Route("tvahistory")
 */
class TvaHistoryController extends Controller
{
    /**
     * Lists all tvaHistory entities.
     *
     * @Route("/", name="tvahistory_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $tvaHistories = $em->getRepository('AMLASqrBundle:TvaHistory')->findAll();

        return $this->render('tvahistory/index.html.twig', array(
            'tvaHistories' => $tvaHistories,
        ));
    }


    /**
     * Lists all tvaHistory entities.
     *
     * @Route("/emise/secured", name="tvahistory_emise")
     * @Method("GET")
     */
    public function indexEmiseAction()
    {
        if($this->getUser() && !empty($this->getUser()->getRole())) 
        {
            $em = $this->getDoctrine()->getManager();

            $fournisseur = $this->getUser()->getCompagnyId();

            $factureSpontanes = $em->getRepository('AMLASqrBundle:FactureSpontane')->findBy(['account'=>$this->getUser()], ['id'=>'DESC']);

            return $this->render('tvahistory/emises.html.twig', array(
                'factureSpontanes' => $factureSpontanes,
            ));
        }else
        {
            $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
            return $this->redirectToRoute('dashboard_index');
        }
    }

    /**
     * Lists all tvaHistory entities.
     *
     * @Route("/recues/secured", name="tvahistory_recues")
     * @Method("GET")
     */
    public function indexRecuesAction()
    {
        if($this->getUser() && !empty($this->getUser()->getRole())) 
        {
            $em = $this->getDoctrine()->getManager();
            $fournisseur = $this->getUser()->getCompagnyId();

            //$factureSpontanes = $em->getRepository('AMLASqrBundle:FactureSpontane')->findBy(['account'=>$this->getUser()], ['id'=>'DESC']);
            $factureSpontanes = $em->getRepository('AMLASqrBundle:FactureSpontane')->findBy(['fournisseur'=>$fournisseur], ['id'=>'DESC']);

            return $this->render('tvahistory/recues.html.twig', array(
                'factureSpontanes' => $factureSpontanes,
            ));
        }else
        {
            $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
            return $this->redirectToRoute('dashboard_index');
        }        
    }

    /**
     * Creates a new tvaHistory entity.
     *
     * @Route("/new", name="tvahistory_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $tvaHistory = new Tvahistory();
        $form = $this->createForm('AMLA\SqrBundle\Form\TvaHistoryType', $tvaHistory);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) 
        {
            $em = $this->getDoctrine()->getManager();
            $em->persist($tvaHistory);
            $em->flush();

            return $this->redirectToRoute('tvahistory_show', array('id' => $tvaHistory->getId()));
        }

        return $this->render('tvahistory/new.html.twig', array(
            'tvaHistory' => $tvaHistory,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a tvaHistory entity.
     *
     * @Route("/{id}", name="tvahistory_show")
     * @Method("GET")
     */
    public function showAction(TvaHistory $tvaHistory)
    {
        $deleteForm = $this->createDeleteForm($tvaHistory);

        return $this->render('tvahistory/show.html.twig', array(
            'tvaHistory' => $tvaHistory,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Finds and displays a tvaHistory entity.
     *
     * @Route("/{id}/historique", name="tvahistory_show_from_tva")
     * @Method("GET")
     */
    public function showTvahistoryFromTvaAction(Fournissseur $fournisseur)
    {       

        return $this->render('tvahistory/index_from_tva.html.twig', array(
            'fournisseur' => $fournisseur,
        ));
    }

    /**
     * Displays a form to edit an existing tvaHistory entity.
     *
     * @Route("/{id}/edit", name="tvahistory_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, TvaHistory $tvaHistory)
    {
        $deleteForm = $this->createDeleteForm($tvaHistory);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\TvaHistoryType', $tvaHistory);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('tvahistory_edit', array('id' => $tvaHistory->getId()));
        }

        return $this->render('tvahistory/edit.html.twig', array(
            'tvaHistory' => $tvaHistory,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a tvaHistory entity.
     *
     * @Route("/{id}", name="tvahistory_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, TvaHistory $tvaHistory)
    {
        $form = $this->createDeleteForm($tvaHistory);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($tvaHistory);
            $em->flush();
        }

        return $this->redirectToRoute('tvahistory_index');
    }

    /**
     * Creates a form to delete a tvaHistory entity.
     *
     * @param TvaHistory $tvaHistory The tvaHistory entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(TvaHistory $tvaHistory)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('tvahistory_delete', array('id' => $tvaHistory->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
