<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\SubscriptionInBill;
use AMLA\SqrBundle\Entity\InBill;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;

/**
 * Subscriptioninbill controller.
 *
 * @Route("subscriptioninbill/{_locale}", defaults = {"_locale" = "fr"})
 */
class SubscriptionInBillController extends Controller
{
    /**
     * Lists all subscriptionInBill entities.
     *
     * @Route("/", name="subscriptioninbill_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        if ($this->getUser() && !empty($this->getUser()->getRole())) 
        {
            $em = $this->getDoctrine()->getManager();
            $fournisseur = $this->getUser()->getCompagnyId();
            $inBill = $fournisseur->getInBill();
            //$inBill = $em->getRepository('AMLASqrBundle:InBill')->findOneBy(['fournisseur'=>$fournisseur]);//, ['id'=>'DESC']
            //$subscriptionInBills = $em->getRepository('AMLASqrBundle:SubscriptionInBill')->findBy(['']);

            return $this->render('subscriptioninbill/index.html.twig', array(
                //'subscriptionInBills' => $subscriptionInBills,
                'inBill'=>$inBill,
            ));
        }else
        {
            $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
            return $this->redirectToRoute('dashboard_index');
        }
    }

    /**
     * Creates a new subscriptionInBill entity.
     *
     * @Route("/new", name="subscriptioninbill_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $user = $this->getUser();
        if ($this->getUser() && !empty($this->getUser()->getRole())) 
        {
            $subscriptionInBill = new Subscriptioninbill();
            $form = $this->createForm('AMLA\SqrBundle\Form\SubscriptionInBillType', $subscriptionInBill);
            $form->handleRequest($request);

            if ($form->isSubmitted() && $form->isValid()) 
            {

                $em = $this->getDoctrine()->getManager();
                $fournisseur = $user->getCompagnyId();

                
                $dateDebut = new \Datetime();
                $interval = new \DateInterval('P'.$subscriptionInBill->getMonths().'M');

                //$inBill = $em->getRepository('AMLASqrBundle:InBill')->findOneBy(['fournisseur'=>$fournisseur]);
                $inBill = $fournisseur->getInBill();
                if ($fournisseur->getInBill())
                {
                    // calcule des dates de validité du cours souscrit
                    $dateFinAncien = new \Datetime($inBill->getDateFin()->format('Y-m-d'));
                    $dateFinNouveau = $dateFinAncien->add($interval);

                    $inBill->setDateDebut($dateFinAncien);
                    $inBill->setDateFin($dateFinNouveau);
                    
                }else
                {
                    $dateFinAncien = new \Datetime(date("Y-m-d"));
                    $dateFinNouveau = $dateFinAncien->add($interval);

                    $inBill = new InBill();
                    $inBill->setDateFin($interval);
                    $fournisseur->setInBill($inBill);
                    $inBill->setDateDebut($dateFinAncien);
                    $inBill->setDateFin($dateFinNouveau);
                }

                //update fournisseur set inbill available
                $fournisseur->setIsInbill(1);

                $subscriptionInBill->setInBill($inBill);
                $subscriptionInBill->setAccount($user);
                $subscriptionInBill->setDateStart($dateFinAncien);
                $subscriptionInBill->setDateEnd($dateFinNouveau);

                $em->persist($inBill);
                $em->persist($fournisseur);
                $em->persist($subscriptionInBill);
                $em->flush();

                $this->get('session')->getFlashBag()->add('success', 'Votre souscription au service IB BILL a été effectué avec succès !!!');
                return $this->redirectToRoute('inbill_index_mine');
                //return $this->redirectToRoute('subscriptioninbill_show', array('id' => $subscriptionInBill->getId()));
            }

            return $this->render('subscriptioninbill/new.html.twig', array(
                'subscriptionInBill' => $subscriptionInBill,
                'form' => $form->createView(),
            ));
        }else
        {
            $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
            return $this->redirectToRoute('dashboard_index');
        }
    }

    /**
     * Finds and displays a subscriptionInBill entity.
     *
     * @Route("/{id}", name="subscriptioninbill_show")
     * @Method("GET")
     */
    public function showAction(SubscriptionInBill $subscriptionInBill)
    {
        $deleteForm = $this->createDeleteForm($subscriptionInBill);

        return $this->render('subscriptioninbill/show.html.twig', array(
            'subscriptionInBill' => $subscriptionInBill,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing subscriptionInBill entity.
     *
     * @Route("/{id}/edit", name="subscriptioninbill_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, SubscriptionInBill $subscriptionInBill)
    {
        $deleteForm = $this->createDeleteForm($subscriptionInBill);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\SubscriptionInBillType', $subscriptionInBill);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('subscriptioninbill_edit', array('id' => $subscriptionInBill->getId()));
        }

        return $this->render('subscriptioninbill/edit.html.twig', array(
            'subscriptionInBill' => $subscriptionInBill,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a subscriptionInBill entity.
     *
     * @Route("/{id}", name="subscriptioninbill_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, SubscriptionInBill $subscriptionInBill)
    {
        $form = $this->createDeleteForm($subscriptionInBill);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($subscriptionInBill);
            $em->flush();
        }

        return $this->redirectToRoute('subscriptioninbill_index');
    }

    /**
     * Creates a form to delete a subscriptionInBill entity.
     *
     * @param SubscriptionInBill $subscriptionInBill The subscriptionInBill entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(SubscriptionInBill $subscriptionInBill)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('subscriptioninbill_delete', array('id' => $subscriptionInBill->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
