<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Offre;
use AMLA\SqrBundle\Entity\Annexe;
use AMLA\SqrBundle\Entity\Document;
use AMLA\SqrBundle\Entity\Financier;
use AMLA\SqrBundle\Entity\Technique;
use AMLA\SqrBundle\Entity\Fournissseur;
use AMLA\SqrBundle\Entity\Administratif;
use AMLA\SqrBundle\Entity\OffreFournisseur;
use AMLA\SqrBundle\Entity\SoummissionOffre;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;

/**
 * Soummissionoffre controller.
 *
 * @Route("offre/{_locale}", defaults = {"_locale" = "fr"})
 */
class SoummissionOffreController extends Controller
{
    /**
     * Lists all soummissionOffre entities.
     *
     * @Route("/", name="soummissionoffre_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $soummissionOffres = $em->getRepository('AMLASqrBundle:SoummissionOffre')->findAll();

        return $this->render('soummissionoffre/index.html.twig', array(
            'soummissionOffres' => $soummissionOffres,
        ));
    }

    /**
     * Lists all soummissionOffre entities.
     *
     * @Route("/mine", name="soummissionoffre_mine")
     * @Method("GET")
     */
    public function mineAction()
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);


        $soummissionOffres = $em->getRepository('AMLASqrBundle:SoummissionOffre')->getSoumissionUser($fournisseur);

        return $this->render('soummissionoffre/index.html.twig', array(
            'soummissionOffres' => $soummissionOffres,
        ));
    }

    /**
     * Lists all soummissionOffre entities.
     *
     * @Route("/sent", name="soummissionoffre_sent")
     * @Method("GET")
     */
    public function sentAction()
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
        $soummissionOffres = $em->getRepository('AMLASqrBundle:SoummissionOffre')->getSoumissionSentUser($fournisseur);

        return $this->render('soummissionoffre/sent.html.twig', array(
            'soummissionOffres' => $soummissionOffres,
        ));
    }

     /**
     * Lists all soummissionOffre entities.
     *
     * @Route("/{id}/download/admin", name="soummissionoffre_downloadadmin")
     * @Method("GET")
     */
    public function downloadAdminAction(SoummissionOffre $soummissionoffre)
    {
        $em = $this->getDoctrine()->getManager();

        $administratif = $em->getRepository('AMLASqrBundle:Administratif')->findOneBy(['soumission'=>$soummissionoffre->getId()]);
        if ($administratif != NULL) {
            $docadmin = $em->getRepository('AMLASqrBundle:Document')->findOneBy(['administratif'=>$administratif->getId()]);
            //Téléchargement du document administratif de la proposition
            if(file_exists($docadmin->getPath())){
                header('Content-type: application/'.pathinfo($docadmin->getPath(), PATHINFO_EXTENSION));
    
                // It will be called downloaded.zip
                header('Content-Disposition: attachment; filename='.$administratif->getReference().'.'.pathinfo($docadmin->getPath(), PATHINFO_EXTENSION));
    
                // The PDF source is in original.zip
                readfile($docadmin->getPath());
    
                $this->addFlash('info','Vous venez de télécharger l\'offre administrative');
                
            }else{
                $this->addFlash('danger','Impossible de télécharger car le fichier de l\'offre administrative est inexistant!!!');
            }
        }else{
            $this->addFlash('danger','Pas de documents administratifs pour cette proposition');
        }

        return $this->redirectToRoute('dashboard_index');
    }

     /**
     * Lists all soummissionOffre entities.
     *
     * @Route("/{id}/download/annexe", name="soummissionoffre_downloadannexe")
     * @Method("GET")
     */
    public function downloadAnnexeAction(SoummissionOffre $soummissionoffre)
    { 
        $em = $this->getDoctrine()->getManager();

        $annexe = $em->getRepository('AMLASqrBundle:Annexe')->findOneBy(['soumission'=>$soummissionoffre->getId()]);
        if ($annexe != NULL) {
            $docannexe = $em->getRepository('AMLASqrBundle:Document')->findOneBy(['annexe'=>$annexe->getId()]);
            //Téléchargement du document annexe de la proposition
            if(file_exists($docannexe->getPath())){
                header('Content-type: application/'.pathinfo($docannexe->getPath(), PATHINFO_EXTENSION));

                // It will be called downloaded.zip
                header('Content-Disposition: attachment; filename='.$annexe->getReference().'.'.pathinfo($docannexe->getPath(), PATHINFO_EXTENSION));

                // The PDF source is in original.zip
                readfile($docannexe->getPath());

                $this->addFlash('info','Vous venez de télécharger l\'offre annexe');
                
            }else{
                $this->addFlash('danger','Impossible de télécharger car le fichier de l\'offre annexe est inexistant!!!');
            }

        }else{
            $this->addFlash('danger','Pas de documents annexes pour cette proposition');
        }

        return $this->redirectToRoute('dashboard_index');
    }

    /**
     * Lists all soummissionOffre entities.
     *
     * @Route("/{id}/download/financier", name="soummissionoffre_downloadfin")
     * @Method("GET")
     */
    public function downloadFinAction(SoummissionOffre $soummissionoffre)
    { 
        $em = $this->getDoctrine()->getManager();

        $financier = $em->getRepository('AMLASqrBundle:Financier')->findOneBy(['soumission'=>$soummissionoffre->getId()]);
        if ($financier != NULL) {
            $docfin = $em->getRepository('AMLASqrBundle:Document')->findOneBy(['financier'=>$financier->getId()]);
            //Téléchargement du document financier de la proposition
            if(file_exists($docfin->getPath())){
                header('Content-type: application/'.pathinfo($docfin->getPath(), PATHINFO_EXTENSION));

                // It will be called downloaded.zip
                header('Content-Disposition: attachment; filename='.$financier->getReference().'.'.pathinfo($docfin->getPath(), PATHINFO_EXTENSION));

                // The PDF source is in original.zip
                readfile($docfin->getPath());

                $this->addFlash('info','Vous venez de télécharger l\'offre financière');
                
            }else{
                $this->addFlash('danger','Impossible de télécharger car le fichier de l\'offre financière est inexistant!!!');
            }
        }else{
            $this->addFlash('danger','Pas de documents financiers pour cette proposition');
        }

        return $this->redirectToRoute('dashboard_index');
    }   
    
    /**
     * Lists all soummissionOffre entities.
     *
     * @Route("/{id}/download/technique", name="soummissionoffre_downloadtech")
     * @Method("GET")
     */
    public function downloadTechAction(SoummissionOffre $soummissionoffre)
    {
        $em = $this->getDoctrine()->getManager();

        $technique = $em->getRepository('AMLASqrBundle:Technique')->findOneBy(['soumission'=>$soummissionoffre->getId()]);
        if ($technique != NULL) {
            $doctech = $em->getRepository('AMLASqrBundle:Document')->findOneBy(['technique'=>$technique->getId()]);
             //Téléchargement du document technique de la proposition
            if(file_exists($doctech->getPath())){
                header('Content-type: application/'.pathinfo($doctech->getPath(), PATHINFO_EXTENSION));

                // It will be called downloaded.zip
                header('Content-Disposition: attachment; filename='.$technique->getReference().'.'.pathinfo($doctech->getPath(), PATHINFO_EXTENSION));

                // The PDF source is in original.zip
                readfile($doctech->getPath());

                $this->addFlash('info','Vous venez de télécharger l\'offre technique');
                
            }else{
                $this->addFlash('danger','Impossible de télécharger car le fichier de l\'offre technique est inexistant!!!');
            }
        }else{
            $this->addFlash('danger','Pas de documents techniques pour cette proposition');
        }
        
        return $this->redirectToRoute('dashboard_index');
    }


    /**
     * Lists all soummissionOffre entities.
     *
     * @Route("/receive", name="soummissionoffre_receive")
     * @Method("GET")
     */
    public function receiveAction()
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
        $soummissionOffres = $em->getRepository('AMLASqrBundle:SoummissionOffre')->getSoumissionReceiveUser($fournisseur);

        $propositions = array();

        foreach ($soummissionOffres as $soummissionOffre) {
            $propositions[] = (object)array(
                'propos' => $soummissionOffre,
                'selectionne' => $em->getRepository('AMLASqrBundle:Preselection')->findOneBy(['offre'=> $soummissionOffre->getOffre(),'fournisseur'=> $soummissionOffre->getFournisseur()]),
                'valide' => $this->hasValidateAnr($soummissionOffre->getFournisseur())
            );
        }
        //dump($propositions);die;
        return $this->render('soummissionoffre/receive.html.twig', array(
            'propositions' => $propositions,
        ));
    }


    public function hasValidateAnr(Fournissseur $fournisseur){

        $em = $this->getDoctrine()->getManager();
        $anrs = $em->getRepository('AMLASqrBundle:Anr')->findBy(['fournisseur'=>$fournisseur]);

        $verif = false;
        $datejour = new \Datetime("now");

            foreach ($anrs as $anr) {
            
                if($anr->getDateFin() < $datejour){
                    $verif = false;
                }else{
                    $verif = true; 
                    break;
                }

            }
        return $verif;
    }

    /**
     * Creates a new soummissionOffre entity.
     *
     * @Route("/{id}/new", name="soummissionoffre_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request, Offre $offre)
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]); 
        $soffre = new Soummissionoffre();
        $form = $this->createForm('AMLA\SqrBundle\Form\SoummissionOffreType', $soffre);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            
            //dump($request);die;
            $prix = $request->get('amla_sqrbundle_soummissionoffre')['Montant'];
            $commentaires = $request->get('amla_sqrbundle_soummissionoffre')['commentaires'];
            $techniques = $request->files->get("amla_sqrbundle_soummissionoffre")["techniques"];
            $financiers = $request->files->get("amla_sqrbundle_soummissionoffre")["financiers"];
            $administratifs = $request->files->get("amla_sqrbundle_soummissionoffre")["administratifs"];
            $annexes = $request->files->get("amla_sqrbundle_soummissionoffre")["annexes"];
            $soffre->setCommentaires($commentaires);
            $soffre->setPrice($prix);
            $soffre->setOffre($offre);
            $soffre->setFournisseur($fournisseur);

            //Gestion dossier technique
            $docTech = new Document();
            $technique = new Technique();
            $path = sha1(uniqid(mt_rand(), true)).'.'.$techniques->guessExtension();
            $docTech->setPath($path);
            $docTech->setSize($techniques->getClientSize());
            $docTech->setName($technique->getReference().'.'.$techniques->guessExtension());
            $docTech->setThumb($technique->getReference().'.'.$techniques->guessExtension());
            $techniques->move($docTech->getUploadRootDir(), $path);
            $technique->addDocument($docTech);
            $docTech->setTechnique($technique);
            $technique->setSoumission($soffre);
            $soffre->addTechnique($technique);
            $em->persist($docTech);
            $em->persist($technique);

            //Gestion dossier financier
            $docFin = new Document();
            $financier = new Financier();
            $path = sha1(uniqid(mt_rand(), true)).'.'.$financiers->guessExtension();
            $docFin->setPath($path);
            $docFin->setSize($financiers->getClientSize());
            $docFin->setName($financier->getReference().'.'.$financiers->guessExtension());
            $docFin->setThumb($financier->getReference().'.'.$financiers->guessExtension());
            $financiers->move($docFin->getUploadRootDir(), $path);
            $financier->addDocument($docFin);
            $docFin->setFinancier($financier);
            $financier->setSoumission($soffre);
            $soffre->addFinancier($financier);
            $em->persist($docFin);
            $em->persist($financier);

            //Gestion dossier annexe
            $docAn = new Document();
            $annexe = new Annexe();
            $path = sha1(uniqid(mt_rand(), true)).'.'.$annexes->guessExtension();
            $docAn->setPath($path);
            $docAn->setSize($annexes->getClientSize());
            $docAn->setName($annexe->getReference().'.'.$annexes->guessExtension());
            $docAn->setThumb($annexe->getReference().'.'.$annexes->guessExtension());
            $annexes->move($docAn->getUploadRootDir(), $path);
            $annexe->addDocument($docAn);
            $docAn->setAnnexe($annexe);
            $annexe->setSoumission($soffre);
            $soffre->addAnnex($annexe);
            $em->persist($docAn);
            $em->persist($annexe);

            //Gestion dossier administratif
            $docAdm = new Document();
            $administratif = new Administratif();
            $path = sha1(uniqid(mt_rand(), true)).'.'.$administratifs->guessExtension();
            $docAdm->setPath($path);
            $docAdm->setSize($administratifs->getClientSize());
            $docAdm->setName($administratif->getReference().'.'.$administratifs->guessExtension());
            $docAdm->setThumb($administratif->getReference().'.'.$administratifs->guessExtension());
            $administratifs->move($docAdm->getUploadRootDir(), $path);
            $administratif->addDocument($docAdm);
            $docAdm->setAdministratif($administratif);
            $administratif->setSoumission($soffre);
            $soffre->addAdministratif($administratif);
            $em->persist($docAdm);
            $em->persist($administratif);

            //$soffre->setStatut(1);
            $em->persist($soffre);
            $em->flush();
            try {

                $message = (new \Swift_Message('CHECKTATOO - Nouvelle Soumission'))
                ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
                ->setTo($offre->getFournisseur()->getAdresseEmail())
                ->setBody(
                    $this->renderView(
                        'emails/soummission.html.twig', array(
                        'offre' => $offre, 
                        'sender' => $fournisseur,)
                    ),
                    'text/html'
                );

                $this->get('mailer')->send($message);
            

            } catch (\Exception $e) {
                $this->addFlash('danger','une erreur est survenue lors de l\'envoie du mail');
                return $this->redirectToRoute('dashboard_index');
            }
            $this->addFlash('info','Proposition soumise avec succès');
            return $this->redirectToRoute('dashboard_index');
        }

        return $this->render('soummissionoffre/new.html.twig', array(
            'form' => $form->createView(),
        ));
    }


     /**
     * Creates a new soummissionOffre entity.
     *
     * @Route("/spontanous", name="soummissionoffre_spontanous")
     * @Method({"GET", "POST"})
     */
    public function spontanousAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]); 
        $soffre = new Soummissionoffre();
        $form = $this->createForm('AMLA\SqrBundle\Form\SoummissionOffreType1', $soffre);
        $form->handleRequest($request);

        if ($form->isSubmitted()) {
            
            $fournseurs = $request->get('amla_sqrbundle_soummissionoffre')['fournisseur'];
            $fournisseurs = array();
            foreach($fournseurs as $fournseur){

                $fournisseurs[] = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneById($fournseur);
            }

            $prix = $request->get('amla_sqrbundle_soummissionoffre')['Montant'];
            $commentaires = $request->get('amla_sqrbundle_soummissionoffre')['commentaires'];
            $techniques = $request->files->get("amla_sqrbundle_soummissionoffre")["techniques"];
            $financiers = $request->files->get("amla_sqrbundle_soummissionoffre")["financiers"];
            $administratifs = $request->files->get("amla_sqrbundle_soummissionoffre")["administratifs"];
            $annexes = $request->files->get("amla_sqrbundle_soummissionoffre")["annexes"];
            $soffre->setCommentaires($commentaires);
            $soffre->setPrice($prix);
            $soffre->setFournisseur($fournisseur);
            $commune = $fournisseur->getCommune();
            $ville = $commune->getVille();
            $paysF = $ville->getPays();
            $pays = $paysF->getAlpha3();
            if ($fournisseurs != NULL){
                foreach ($fournisseurs as $fourn) {
                    $offreFournisseur = new OffreFournisseur();
                    $offreFournisseur->setFournisseurSpon($fournisseur);
                    $offreFournisseur->setFournisseur($fourn);
                    $em->persist($offreFournisseur);
                    try {
                        $message = (new \Swift_Message('CHECKTATOO - Offre Spontanée'))
                        ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
                        ->setTo($fourn->getAdresseEmail())
                        ->setBody(
                            $this->renderView(
                                'emails/spontanous.html.twig', array(
                                'offre' => $offre, 
                                'sender'=> $fournisseur,)
                            ),
                            'text/html'
                        );
        
                        $this->get('mailer')->send($message);

                    } catch (\Exception $e) {
                        $this->addFlash('danger','une erreur est survenue lors de l\'envoie du mail');
                        return $this->redirectToRoute('dashboard_index');
                    }
                }
            }else{
                $user = $this->getUser();
                $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
                $fmoas = $em->getRepository('AMLASqrBundle:FournisseurMoa')->getFournisseurPays($fournisseur, $pays);
                //$fournissseurs = array();
                foreach ($fmoas as $fmoa) {
                    $offreFournisseur = new OffreFournisseur();
                    $offreFournisseur->setFournisseurSpon($fournisseur);
                    $offreFournisseur->setFournisseur($fmoa->getFournisseur());
                    $em->persist($offreFournisseur);
                    try {
                        $message = (new \Swift_Message('CHECKTATOO - Offre Spontanée'))
                        ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
                        ->setTo($fmoa->getFournisseur()->getAdresseEmail())
                        ->setBody(
                            $this->renderView(
                                'emails/spontanous.html.twig', array(
                                'offre' => $offre, 
                                'sender'=> $fournisseur,)
                            ),
                            'text/html'
                        );
        
                        $this->get('mailer')->send($message);

                    } catch (\Exception $e) {
                        $this->addFlash('danger','une erreur est survenue lors de l\'envoie du mail');
                        return $this->redirectToRoute('dashboard_index');
                    }
                }
            }

            //Gestion dossier technique
            $docTech = new Document();
            $technique = new Technique();
            $path = sha1(uniqid(mt_rand(), true)).'.'.$techniques->guessExtension();
            $docTech->setPath($path);
            $docTech->setSize($techniques->getClientSize());
            $docTech->setName($technique->getReference().'.'.$techniques->guessExtension());
            $docTech->setThumb($technique->getReference().'.'.$techniques->guessExtension());
            $techniques->move($docTech->getUploadRootDir(), $path);
            $technique->addDocument($docTech);
            $docTech->setTechnique($technique);
            $technique->setSoumission($soffre);
            $soffre->addTechnique($technique);
            $em->persist($docTech);
            $em->persist($technique);

            //Gestion dossier financier
            $docFin = new Document();
            $financier = new Financier();
            $path = sha1(uniqid(mt_rand(), true)).'.'.$financiers->guessExtension();
            $docFin->setPath($path);
            $docFin->setSize($financiers->getClientSize());
            $docFin->setName($financier->getReference().'.'.$financiers->guessExtension());
            $docFin->setThumb($financier->getReference().'.'.$financiers->guessExtension());
            $financiers->move($docFin->getUploadRootDir(), $path);
            $financier->addDocument($docFin);
            $docFin->setFinancier($financier);
            $financier->setSoumission($soffre);
            $soffre->addFinancier($financier);
            $em->persist($docFin);
            $em->persist($financier);

            //Gestion dossier annexe
            $docAn = new Document();
            $annexe = new Annexe();
            $path = sha1(uniqid(mt_rand(), true)).'.'.$annexes->guessExtension();
            $docAn->setPath($path);
            $docAn->setSize($annexes->getClientSize());
            $docAn->setName($annexe->getReference().'.'.$annexes->guessExtension());
            $docAn->setThumb($annexe->getReference().'.'.$annexes->guessExtension());
            $annexes->move($docAn->getUploadRootDir(), $path);
            $annexe->addDocument($docAn);
            $docAn->setAnnexe($annexe);
            $annexe->setSoumission($soffre);
            $soffre->addAnnex($annexe);
            $em->persist($docAn);
            $em->persist($annexe);

            //Gestion dossier administratif
            $docAdm = new Document();
            $administratif = new Administratif();
            $path = sha1(uniqid(mt_rand(), true)).'.'.$administratifs->guessExtension();
            $docAdm->setPath($path);
            $docAdm->setSize($administratifs->getClientSize());
            $docAdm->setName($administratif->getReference().'.'.$administratifs->guessExtension());
            $docAdm->setThumb($administratif->getReference().'.'.$administratifs->guessExtension());
            $administratifs->move($docAdm->getUploadRootDir(), $path);
            $administratif->addDocument($docAdm);
            $docAdm->setAdministratif($administratif);
            $administratif->setSoumission($soffre);
            $soffre->addAdministratif($administratif);
            $em->persist($docAdm);
            $em->persist($administratif);


            $em->persist($soffre);
            $em->flush();

           

            $this->addFlash('info','Proposition soumise avec succès');
            return $this->redirectToRoute('dashboard_index');
        }

        return $this->render('soummissionoffre/spontanous.html.twig', array(
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a soummissionOffre entity.
     *
     * @Route("/{id}", name="soummissionoffre_show")
     * @Method("GET")
     */
    public function showAction(SoummissionOffre $soummissionOffre)
    {
        $deleteForm = $this->createDeleteForm($soummissionOffre);

        return $this->render('soummissionoffre/show.html.twig', array(
            'soummissionOffre' => $soummissionOffre,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing soummissionOffre entity.
     *
     * @Route("/{id}/edit", name="soummissionoffre_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, SoummissionOffre $soummissionOffre)
    {
        $deleteForm = $this->createDeleteForm($soummissionOffre);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\SoummissionOffreType', $soummissionOffre);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('soummissionoffre_edit', array('id' => $soummissionOffre->getId()));
        }

        return $this->render('soummissionoffre/edit.html.twig', array(
            'soummissionOffre' => $soummissionOffre,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a soummissionOffre entity.
     *
     * @Route("/{id}", name="soummissionoffre_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, SoummissionOffre $soummissionOffre)
    {
        $form = $this->createDeleteForm($soummissionOffre);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($soummissionOffre);
            $em->flush();
        }

        return $this->redirectToRoute('soummissionoffre_index');
    }

    /**
     * Creates a form to delete a soummissionOffre entity.
     *
     * @param SoummissionOffre $soummissionOffre The soummissionOffre entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(SoummissionOffre $soummissionOffre)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('soummissionoffre_delete', array('id' => $soummissionOffre->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
