<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\ServiceItem;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;

/**
 * Serviceitem controller.
 *
 * @Route("serviceitem/{_locale}", defaults = {"_locale" = "fr"})
 */
class ServiceItemController extends Controller
{
    /**
     * Lists all serviceItem entities.
     *
     * @Route("/", name="serviceitem_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $serviceItems = $em->getRepository('AMLASqrBundle:ServiceItem')->findAll();

        return $this->render('serviceitem/index.html.twig', array(
            'serviceItems' => $serviceItems,
        ));
    }

     /**
     * Lists all ServiceItem entities.
     *
     * @Route("/json/category", name="serviceitem_index_category")
     * @Method("GET")
     */
    public function indexFromCategoryAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $categoryId = $request->get('categoryFormId');

        $category = $em->getRepository('AMLASqrBundle:ServiceCategory')->findOneBy(['id'=>$categoryId]);

        $serviceItems = $em->getRepository('AMLASqrBundle:ServiceItem')->findBy(['serviceCategory'=>$category]);

        $tabRetour = array();
        foreach ($serviceItems as $serviceItem) 
        {
            $tabRetour[] = 
            [
                'id'=>$serviceItem->getId(),
                'intitule'=>$serviceItem->getIntitule(),
                'codification'=>$serviceItem->getCodification(),
                'amount'=>$serviceItem->getAmount(),
            ];
        }

        $response = new JsonResponse($tabRetour);
        return $response;
       
    }

    /**
     * Creates a new serviceItem entity.
     *
     * @Route("/new", name="serviceitem_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $serviceItem = new Serviceitem();
        $form = $this->createForm('AMLA\SqrBundle\Form\ServiceItemType', $serviceItem);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($serviceItem);
            $em->flush();

            return $this->redirectToRoute('serviceitem_show', array('id' => $serviceItem->getId()));
        }

        return $this->render('serviceitem/new.html.twig', array(
            'serviceItem' => $serviceItem,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a serviceItem entity.
     *
     * @Route("/{id}", name="serviceitem_show")
     * @Method("GET")
     */
    public function showAction(ServiceItem $serviceItem)
    {
        $deleteForm = $this->createDeleteForm($serviceItem);

        return $this->render('serviceitem/show.html.twig', array(
            'serviceItem' => $serviceItem,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing serviceItem entity.
     *
     * @Route("/{id}/edit", name="serviceitem_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, ServiceItem $serviceItem)
    {
        $deleteForm = $this->createDeleteForm($serviceItem);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\ServiceItemType', $serviceItem);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('serviceitem_edit', array('id' => $serviceItem->getId()));
        }

        return $this->render('serviceitem/edit.html.twig', array(
            'serviceItem' => $serviceItem,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a serviceItem entity.
     *
     * @Route("/{id}", name="serviceitem_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, ServiceItem $serviceItem)
    {
        $form = $this->createDeleteForm($serviceItem);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($serviceItem);
            $em->flush();
        }

        return $this->redirectToRoute('serviceitem_index');
    }

    /**
     * Creates a form to delete a serviceItem entity.
     *
     * @param ServiceItem $serviceItem The serviceItem entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(ServiceItem $serviceItem)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('serviceitem_delete', array('id' => $serviceItem->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
