<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Service;
use AMLA\SqrBundle\Entity\Quittance;
use AMLA\SqrBundle\Entity\ServiceArticle;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;
use AMLA\SqrBundle\Entity\CheckQr;
use AMLA\SqrBundle\API\SqrApi as SqrApi;

/**
 * Service controller.
 *
 * @Route("service/{_locale}", defaults = {"_locale" = "fr"})
 */
class ServiceController extends Controller
{
    /**
     * Lists all service entities.
     *
     * @Route("/", name="service_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $services = $em->getRepository('AMLASqrBundle:Service')->findAll();

        return $this->render('service/index.html.twig', array(
            'services' => $services,
        ));
    }

   

    /**
     * Creates a new service entity.
     *
     * @Route("/new", name="service_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $service = new Service();
        $form = $this->createForm('AMLA\SqrBundle\Form\ServiceType', $service);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) 
        {

            $em = $this->getDoctrine()->getManager();

            $serviceItemForm = $request->get('serviceItem');
            $quantity = $request->get('quantite');
            
            $nbEl = count($serviceItemForm);

            $total = $service->getFees();
            for($i=0; $i<$nbEl; $i++)
            {
                $serviceItem = $em->getRepository('AMLASqrBundle:ServiceItem')->findOneBy(['id'=>$serviceItemForm[$i]]);
                $serviceArticle = new serviceArticle();

                $serviceArticle->setService($service);
                $serviceArticle->setServiceItem($serviceItem);
                $serviceArticle->setQuantity($quantity[$i]);            

                $em->persist($serviceArticle);
                $total = $total + $serviceArticle->getServiceItem()->getAmount();
            }

            $service->setAccount($this->getUser());
            $service->setTotal($total);

            //dump($request);die;

                $cle = $this->container->getParameter('api_key');
                $piece = 'Facturation service';
                $proprietaire = $service->getEmail().'/'.$service->getTelephone();

                $post = array(
                    'cle' => $cle,
                    'pieceqr'=> $piece, 
                    'proprietaire' => $proprietaire, 
                                   
                );

                $container = $this->container;
                $api = new SqrApi($container);
                $res = $api->callAPI($post);
                
                if($res[0])
                {
                    $qr = $res[0]->qr;
                    $num = $res[0]->niu; 
                }
                
                $newname = 'Amende_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
                //$checkqr = new CheckQr();
                $checkqr = $api->generateQr($qr,$num,$newname);
                $checkqr->setChemin($newname);
                $service->setTransactionNumber($checkqr); 

                //Génération du Bordereau avec MPDF
                $target = __DIR__.'/../../../../web/generated/services/';
                $name = 'service-'.$num.'.pdf';

                /*$pdf = $this->renderView('amende/docEmission.html.twig', array(
                    'atd' => $atd,
                    'emeteur'=>$emeteur,
                    'imageqr'=> $atd->getQrCode()->getChemin(),
                    'base_dir' => $this->get('kernel')->getRootDir().'/../web'.$request->getBasePath(),
                ));

                try
                {
                    $mpdf = new \Mpdf\Mpdf();
                    $mpdf->WriteHtml($pdf);
                    if (file_exists($target) != 1) 
                    {
                        mkdir($target,0777,true);
                        $mpdf->Output($target.$name, 'F');
                    }else
                    {
                        $mpdf->Output($target.$name, 'F');
                    }

                }catch(MpdfException $e)
                {
                    die($e->getMessage());
                    $this->get('session')->getFlashBag()->add('danger', 'Erreur lors de la génération de l\'amende');
                }                
*/
           

            $em->persist($checkqr);
            $em->persist($service);
            $em->flush();

             // On envoie le mot de passe par mail
            $message = (new \Swift_Message('CHECKTATOO : Notification facturation de service'))
                ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO']) // sender
                ->setTo($service->getEmail())       // recipient
                /*->setBody('Vos paramètres de connexion à la plateforme CHECKTATOO sont
                    Login:'  . $user->getLoginUser().'
                    Mot de passe : ' . $passss);*/
                ->setBody(
                    $this->renderView(
                    // app/Resources/views/Emails/registration.html.twig
                        'service/email_send.html.twig',
                        array('service' =>$service )
                    ),
                    'text/html'
                );
            $this->get('mailer')->send($message);

            return $this->redirectToRoute('service_show', array('id' => $service->getId()));
        }

        return $this->render('service/new.html.twig', array(
            'service' => $service,
            'form' => $form->createView(),
        ));
    }

     /**
     * Creates a new service entity.
     *
     * @Route("/pay/om", name="service_pay_om_pay")
     * @Method({"GET", "POST"})
     */
    public function payAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();

        $cle =  $cle = $this->getParameter('api_key');
        $numero = $request->get('telephone');
        $serviceId = $request->get('serviceId');
        $payerMessage = 'Test';        
        $payeeNote = 'Test ';

        $service = $em->getRepository('AMLASqrBundle:Service')->findOneBy(['id'=>$serviceId]);
        if($service)
        {
            $amount = intVal($service->getTotal());
            $clientEId =$service->getTransactionNumber()->getNumero();
            //dump($factureSpontane->getQrCode()->getNumero());die;
            $client = new \GuzzleHttp\Client([ 'timeout'=> 10.0, 'verify' =>$this->get('kernel')->getRootDir().'/../web/SSL/cacert.pem']);
            try 
            {   
                $em = $this->getDoctrine()->getManager();
    
                $response = $client->request('POST', $this->getParameter('epayment_base_url').'/initiate/payment/MTN', [
                   'form_params'=> [ 
                        "cle"=>$cle,
                        "amount"=>$amount,
                        "currency"=>"XAF",
                        "clientEId"=>$clientEId,
                        "partyId"=> $numero,
                        /*"payer"=> [
                            "partyIdType"=>"MSISDN",
                            //"partyId"=> "237673126161",
                            "partyId"=> $numero,
                        ],*/
                        "payerMessage"=>$payerMessage,
                        "payeeNote"=>$payeeNote,
                    ]
                ]);
    
                 /*$code =  $response->getStatusCode(); # 200
                $header =  $response->getHeaderLine('content-type'); # 'application/json; charset=utf8'*/
                $body =  (string)$response->getBody(); # '{"id": 1420053, "name": "guzzle", ...}'
                
                $ret = json_decode($body, true);  
                if($ret['uuid'] == 'null' || $ret['status_code'] =='Application non autorisé ou Clé API incorrecte')
                {
                    $reply = 0;
                }else
                {

                    $reply = 1;
                }
                //dump($ret);die;
               
                 
            } catch (\GuzzleHttp\Exception\ConnectException $th)
            {
               //die('bam');
               throw $th;
              // $rep ='ERREUR';
              //die();
              $reply = 0;
            }
        }
        
        $response = new JsonResponse($reply);
        return $response;
    }


     /**
     * Creates a new service entity.
     *
     * @Route("/pay/by/cash/agent", name="service_cash_pay")
     * @Method({"GET", "POST"})
     */
    public function payCashAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();

        $serviceId = $request->get('serviceId');

        $service = $em->getRepository('AMLASqrBundle:Service')->findOneBy(['id'=>$serviceId]);
        if($service)
        {
            $em = $this->getDoctrine()->getManager();
            $quittance = new Quittance();

            $cle = $this->container->getParameter('api_key');
            $piece = 'Quittance';
            $proprietaire = $service->getEmail().'/'.$service->getTelephone();

            $post = array(
                'cle' => $cle,
                'pieceqr'=> $piece, 
                'proprietaire' => $proprietaire,                                    
            );

            $container = $this->container;
            $api = new SqrApi($container);
            $res = $api->callAPI($post);
            
            if($res[0])
            {
                $qr = $res[0]->qr;
                $num = $res[0]->niu; 
            }
            
            $newname = 'Quittance'.date('YmdHis',time()).mt_rand(0,1000).'.png';
            //$checkqr = new CheckQr();
            $checkqr = $api->generateQr($qr,$num,$newname);
            $checkqr->setChemin($newname);
            $quittance->setTransactionNumber($checkqr); 

            //Génération du Bordereau avec MPDF
            $target = __DIR__.'/../../../../web/generated/quittance/';
            $name = 'service-'.$num.'.pdf';

            /*
            $pdf = $this->renderView('amende/docEmission.html.twig', array(
                'atd' => $atd,
                'emeteur'=>$emeteur,
                'imageqr'=> $atd->getQrCode()->getChemin(),
                'base_dir' => $this->get('kernel')->getRootDir().'/../web'.$request->getBasePath(),
            ));

            try
            {
                $mpdf = new \Mpdf\Mpdf();
                $mpdf->WriteHtml($pdf);
                if (file_exists($target) != 1) 
                {
                    mkdir($target,0777,true);
                    $mpdf->Output($target.$name, 'F');
                }else
                {
                    $mpdf->Output($target.$name, 'F');
                }

            }catch(MpdfException $e)
            {
                die($e->getMessage());
                $this->get('session')->getFlashBag()->add('danger', 'Erreur lors de la génération de l\'amende');
            }                
            */
                $quittance->setModeReglement('ESPECE');
                $quittance->setMontant($service->getTotal());
                $quittance->setPlaceCreated($service->getAccount()->getLocalisation());
                $quittance->setPhoneNumber($service->getTelephone());
                $quittance->setReceiverNiu($service->getSqrId());
                $quittance->setSender($service->getAccount());
                $service->setIsPaid(1);
                $service->setQuittance($quittance);
            
            $em->persist($quittance);
            $em->persist($checkqr);
            $em->persist($service);
            $em->flush();

            $reply = 1;
        }else{
            $reply= 0;
        }
        
        $response = new JsonResponse($reply);
        return $response;
    }


    /**
     * Finds and displays a service entity.
     *
     * @Route("/{id}", name="service_show")
     * @Method("GET")
     */
    public function showAction(Service $service)
    {
        $deleteForm = $this->createDeleteForm($service);

        return $this->render('service/show.html.twig', array(
            'service' => $service,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Finds and displays a service entity.
     *
     * @Route("validate/{id}/paiement", name="service_valider")
     * @Method("GET")
     */
    public function validerAction(Service $service)
    {

        return $this->render('service/valider.html.twig', array(
            'service' => $service,
        ));
    }

    /**
     * Displays a form to edit an existing service entity.
     *
     * @Route("/{id}/edit", name="service_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Service $service)
    {
        $deleteForm = $this->createDeleteForm($service);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\ServiceType', $service);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('service_edit', array('id' => $service->getId()));
        }

        return $this->render('service/edit.html.twig', array(
            'service' => $service,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a service entity.
     *
     * @Route("/{id}", name="service_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Service $service)
    {
        $form = $this->createDeleteForm($service);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($service);
            $em->flush();
        }

        return $this->redirectToRoute('service_index');
    }

    /**
     * Creates a form to delete a service entity.
     *
     * @param Service $service The service entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Service $service)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('service_delete', array('id' => $service->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }

    private  function updateServiceStatus (Service $service, $method)
    {
        # code...
            $em = $this->getDoctrine()->getManager();
            $quittance = new Quittance();

            $cle = $this->container->getParameter('api_key');
            $piece = 'Quittance';
            $proprietaire = $service->getEmail().'/'.$service->getTelephone();

            $post = array(
                'cle' => $cle,
                'pieceqr'=> $piece, 
                'proprietaire' => $proprietaire,                                    
            );

            $container = $this->container;
            $api = new SqrApi($container);
            $res = $api->callAPI($post);
            
            if($res[0])
            {
                $qr = $res[0]->qr;
                $num = $res[0]->niu; 
            }
            
            $newname = 'Quittance'.date('YmdHis',time()).mt_rand(0,1000).'.png';
            //$checkqr = new CheckQr();
            $checkqr = $api->generateQr($qr,$num,$newname);
            $checkqr->setChemin($newname);
            $quittance->setTransactionNumber($checkqr); 

            //Génération du Bordereau avec MPDF
            $target = __DIR__.'/../../../../web/generated/quittance/';
            $name = 'service-'.$num.'.pdf';

            /*
            $pdf = $this->renderView('amende/docEmission.html.twig', array(
                'atd' => $atd,
                'emeteur'=>$emeteur,
                'imageqr'=> $atd->getQrCode()->getChemin(),
                'base_dir' => $this->get('kernel')->getRootDir().'/../web'.$request->getBasePath(),
            ));

            try
            {
                $mpdf = new \Mpdf\Mpdf();
                $mpdf->WriteHtml($pdf);
                if (file_exists($target) != 1) 
                {
                    mkdir($target,0777,true);
                    $mpdf->Output($target.$name, 'F');
                }else
                {
                    $mpdf->Output($target.$name, 'F');
                }

            }catch(MpdfException $e)
            {
                die($e->getMessage());
                $this->get('session')->getFlashBag()->add('danger', 'Erreur lors de la génération de l\'amende');
            }                
            */
                
                $quittance->setMontant($service->getTotal());
                $quittance->setPlaceCreated($service->getAccount()->getLocalisation());
                $quittance->setPhoneNumber($service->getTelephone());
                $quittance->setReceiverNiu($service->getSqrId());

                $service->setIsPaid(1);
                $service->setQuittance($quittance);

                if ($method='MOMO') 
                {
                    $quittance->setModeReglement($method);
                    $quittance->setTelephoneMomoReglement($numero);
                }
            
            $em->persist($quittance);
            $em->persist($checkqr);
            $em->persist($service);
            $em->flush();

            return 1;
                
   }
}
