<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\ServiceCategory;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * Servicecategory controller.
 *
 * @Route("servicecategory/{_locale}", defaults = {"_locale" = "fr"})
 */
class ServiceCategoryController extends Controller
{
    /**
     * Lists all serviceCategory entities.
     *
     * @Route("/", name="servicecategory_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $serviceCategories = $em->getRepository('AMLASqrBundle:ServiceCategory')->findAll();

        return $this->render('servicecategory/index.html.twig', array(
            'serviceCategories' => $serviceCategories,
        ));
    }

    /**
     * Lists all serviceCategory entities.
     *
     * @Route("/json", name="servicecategory_index_json")
     * @Method("GET")
     */
    public function indexJsonAction()
    {
        $em = $this->getDoctrine()->getManager();

        $serviceCategories = $em->getRepository('AMLASqrBundle:ServiceCategory')->findAll();

        $tabRetour = array();
        foreach ($serviceCategories as $serviceCategory) 
        {
            $tabRetour[] = [
                'id'=>$serviceCategory->getId(),
                'intitule'=>$serviceCategory->getIntitule(),
            ];
        }

        $response = new JsonResponse($tabRetour);
        return $response;
    }

    /**
     * Creates a new serviceCategory entity.
     *
     * @Route("/new", name="servicecategory_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $serviceCategory = new Servicecategory();
        $form = $this->createForm('AMLA\SqrBundle\Form\ServiceCategoryType', $serviceCategory);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($serviceCategory);
            $em->flush();

            return $this->redirectToRoute('servicecategory_show', array('id' => $serviceCategory->getId()));
        }

        return $this->render('servicecategory/new.html.twig', array(
            'serviceCategory' => $serviceCategory,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a serviceCategory entity.
     *
     * @Route("/{id}", name="servicecategory_show")
     * @Method("GET")
     */
    public function showAction(ServiceCategory $serviceCategory)
    {
        $deleteForm = $this->createDeleteForm($serviceCategory);

        return $this->render('servicecategory/show.html.twig', array(
            'serviceCategory' => $serviceCategory,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing serviceCategory entity.
     *
     * @Route("/{id}/edit", name="servicecategory_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, ServiceCategory $serviceCategory)
    {
        $deleteForm = $this->createDeleteForm($serviceCategory);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\ServiceCategoryType', $serviceCategory);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('servicecategory_edit', array('id' => $serviceCategory->getId()));
        }

        return $this->render('servicecategory/edit.html.twig', array(
            'serviceCategory' => $serviceCategory,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a serviceCategory entity.
     *
     * @Route("/{id}", name="servicecategory_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, ServiceCategory $serviceCategory)
    {
        $form = $this->createDeleteForm($serviceCategory);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($serviceCategory);
            $em->flush();
        }

        return $this->redirectToRoute('servicecategory_index');
    }

    /**
     * Creates a form to delete a serviceCategory entity.
     *
     * @param ServiceCategory $serviceCategory The serviceCategory entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(ServiceCategory $serviceCategory)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('servicecategory_delete', array('id' => $serviceCategory->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
