<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\ServiceArticle;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Servicearticle controller.
 *
 * @Route("servicearticle/{_locale}", defaults = {"_locale" = "fr"})
 */
class ServiceArticleController extends Controller
{
    /**
     * Lists all serviceArticle entities.
     *
     * @Route("/", name="servicearticle_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $serviceArticles = $em->getRepository('AMLASqrBundle:ServiceArticle')->findAll();

        return $this->render('servicearticle/index.html.twig', array(
            'serviceArticles' => $serviceArticles,
        ));
    }

    /**
     * Creates a new serviceArticle entity.
     *
     * @Route("/new", name="servicearticle_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $serviceArticle = new Servicearticle();
        $form = $this->createForm('AMLA\SqrBundle\Form\ServiceArticleType', $serviceArticle);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($serviceArticle);
            $em->flush();

            return $this->redirectToRoute('servicearticle_show', array('id' => $serviceArticle->getId()));
        }

        return $this->render('servicearticle/new.html.twig', array(
            'serviceArticle' => $serviceArticle,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a serviceArticle entity.
     *
     * @Route("/{id}", name="servicearticle_show")
     * @Method("GET")
     */
    public function showAction(ServiceArticle $serviceArticle)
    {
        $deleteForm = $this->createDeleteForm($serviceArticle);

        return $this->render('servicearticle/show.html.twig', array(
            'serviceArticle' => $serviceArticle,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing serviceArticle entity.
     *
     * @Route("/{id}/edit", name="servicearticle_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, ServiceArticle $serviceArticle)
    {
        $deleteForm = $this->createDeleteForm($serviceArticle);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\ServiceArticleType', $serviceArticle);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('servicearticle_edit', array('id' => $serviceArticle->getId()));
        }

        return $this->render('servicearticle/edit.html.twig', array(
            'serviceArticle' => $serviceArticle,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a serviceArticle entity.
     *
     * @Route("/{id}", name="servicearticle_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, ServiceArticle $serviceArticle)
    {
        $form = $this->createDeleteForm($serviceArticle);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($serviceArticle);
            $em->flush();
        }

        return $this->redirectToRoute('servicearticle_index');
    }

    /**
     * Creates a form to delete a serviceArticle entity.
     *
     * @param ServiceArticle $serviceArticle The serviceArticle entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(ServiceArticle $serviceArticle)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('servicearticle_delete', array('id' => $serviceArticle->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
