<?php
namespace AMLA\SqrBundle\Controller;
/**
 * Created by PhpStorm.
 * User: Cedric-Rio
 * Date: 07/06/2018
 * Time: 16:32
 */


use AMLA\SqrBundle\Entity\Account;
use Symfony\Component\Security\Core;
use AMLA\SqrBundle\Entity\Fournissseur;
use AMLA\SqrBundle\Entity\Freevending;
use AMLA\SqrBundle\Entity\BanqueAssocie;
use AMLA\SqrBundle\Entity\FournisseurBanque;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\Security\Core\SecurityContextInterface;
use Symfony\Component\Security\Http\Authentication\AuthenticationUtils;
use Symfony\Component\Security\Core\Authentication\Token\UsernamePasswordToken;

class SecurityController extends Controller {

    /**
     * @Route("/",  name="homepage")
     */
    public function loginAction(Request $request) 
    {
        // Si le visiteur est d�j� identifi�, on le redirige vers l'accueil
        /*if ($this->get('security.authorization_checker')->isGranted('IS_AUTHENTICATED_REMEMBERED')) {
            return $this->redirectToRoute('user_index');
        }*/
        $em = $this->getDoctrine()->getManager();
        // Si le visiteur est d�j� identifi�, on le redirige vers l'accueil
        $fournissseur = new Fournissseur();
        $account = new Account();
        $banqueAssocie = new BanqueAssocie();
        $fournisseurBanque = new FournisseurBanque();
        $freevending = new Freevending();

        $form = $this->createForm('AMLA\SqrBundle\Form\FournissseurType', $fournissseur);
        $form->handleRequest($request);
        $acform = $this->createForm('AMLA\SqrBundle\Form\AccountType', $account);
        $acform->handleRequest($request);
        $banqueform = $this->createForm('AMLA\SqrBundle\Form\BanqueAssocieType', $banqueAssocie);
        $banqueform->handleRequest($request);
        if (($form->isSubmitted() && $form->isValid()) /*&& ($banqueform->isSubmitted() && $banqueform->isValid())  */ && ($acform->isSubmitted() && $acform->isValid())) 
        {
            $fournissseurExist = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['niu'=>$fournissseur->getNiu()]);
            if(!$fournissseurExist)
            {
                if($fournissseur->getLogo() != '')
                {
                    // $file stores the uploaded PDF file
                    /** @var Symfony\Component\HttpFoundation\File\UploadedFile $file */
                    $file = $fournissseur->getLogo();

                    $fileName = $this->generateUniqueFileName().'.'.$file->guessExtension();

                    // Move the file to the directory where brochures are stored
                    try {
                        $file->move(
                            $this->getParameter('logo_entreprise_directory'),
                            $fileName
                        );
                    } catch (FileException $e) {
                        // ... handle exception if something happens during file upload
                    }

                    // updates the 'brochure' property to store the PDF file name
                    // instead of its contents
                    $fournissseur->setLogo($fileName);
                    // ... persist the $product variable or any other work
                }

                //$password = $account->getPassword();
                //$options = ['cost' => 15];
                //$encoded = password_hash($password,PASSWORD_BCRYPT,$options);
                //$account->setPassword($encoded);
                $account->setEmail($fournissseur->getAdresseEmail());
                $account->setCompagnyId($fournissseur);
                $em->persist($account);
                $fournissseur->setAccount($account);
                $pays = $fournissseur->getCommune()->getVille()->getPays();
                $fournissseur->setPays($pays->getAlpha3());
                $em->persist($fournissseur);
                //$em->persist($banqueAssocie);
                //ajout de l'entité freevending
                $freevending->setFournisseur($fournissseur);
                $em->persist($freevending);

                //$fournisseurBanque->setBanque($banqueAssocie);
                //$fournisseurBanque->setFournisseur($fournissseur);
                //$em->persist($fournisseurBanque);
                $em->flush();
                $this->addFlash('info','Compte créé avec succès!');
                return $this->redirectToRoute('login');
            }else
            {
                $this->addFlash('danger','Ce NIU est déjà utilisé !.');
            }

        }

        if ($this->get('security.authorization_checker')->isGranted('IS_AUTHENTICATED_REMEMBERED')) 
        {
            /*
            $usr = $this->getUser();
            date_default_timezone_set('Africa/Douala');
            $usr->setLastConnexion(new \Datetime()); // default date
            $em->persist($usr);
            $em->flush();
            dump($this->getUser()); die;
            */

            return $this->redirectToRoute('dashboard_index');
        }

        $authenticationUtils = $this->get('security.authentication_utils');

        //$em = $this->getDoctrine()->getManager();
        //$request = $this->get('request_stack')->getCurrentRequest();
        //dump($request);die;
        //$session = $request->getSession();

        // Le service authentication_utils permet de r�cup�rer le nom d'utilisateur
        // et l'erreur dans le cas o� le formulaire a d�j� �t� soumis mais �tait invalide
        // (mauvais mot de passe par exemple)
        //$authenticationUtils = $this->get('security.authentication_utils');

        // get the login error if there is one
        $error = $authenticationUtils->getLastAuthenticationError();

        // last username entered by the user
        $lastUsername = $authenticationUtils->getLastUsername();

        return $this->render(
            'security/login_new.html.twig', array(
            //'security/login.html.twig', array(
                // last username entered by the user
                'last_username' => $lastUsername,
                'error'         => $error,
                'form' => $form->createView(),
                'banqueform' => $banqueform->createView(),
                'acform' => $acform->createView(),
            )
        );
    }

    

    /**
     * @Method({"POST"})
     * @Route("/reset",  name="reset")
     */
    public function resetNowAction(Request $request) {
        $em = $this->getDoctrine()->getManager();
        $session = $request->getSession();
        $params = $request->request->all();
        $error = null;

         $authenticationUtils = $this->get('security.authentication_utils');

        if ($params) 
        {
            $login = &$params["email"];
            $em = $this->container->get("doctrine.orm.default_entity_manager");
            $user = $em->getRepository("AMLASqrBundle:Account")->findOneBy(array("email" => $login));
            if ($user == null) 
            {
                $this->addFlash('info','Utilisateur non trouvé.!');
                //return $this->redirectToRoute('login');
                die('in');
                return $this->render('security/recover.html.twig', array('error' => $error, 'last_username' => $authenticationUtils->getLastUsername()));
            }

            $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
            $passss = substr(str_shuffle($chars), 0, 8);
            $options = [
                'cost' => 15
            ];
            $pass = password_hash($passss, PASSWORD_BCRYPT, $options);
            $user->setPassword($pass);

            $em->persist($user);
            $em->flush();
            $this->addFlash('info','Mot de pass reinitialisé avec succès. Consultez votre mail!');
           
            // On envoie le mot de passe par mail
            $message = (new \Swift_Message('CHECKTATOO : Reinitialisation de mot de passe'))
                ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO']) // sender
                ->setTo($user->getEmail())       // recipient
                ->setBody('Vos paramètres de connexion à la plateforme CHECKTATOO sont 
                    Login:'  . $user->getLoginUser().' 
                    Mot de passe : ' . $passss);

            $this->get('mailer')->send($message);
        }
       // die('out');
        //return $this->redirectToRoute('login');
        return $this->render('security/recover.html.twig', array('error' => $error, 'last_username' => $authenticationUtils->getLastUsername(),'locale'=>$this->get('translator')->getLocale()));
    }

    /**
     * @return string
     */
    private function generateUniqueFileName()
    {
        // md5() reduces the similarity of the file names generated by
        // uniqid(), which is based on timestamps
        return md5(uniqid());
    }

}
