<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\SecretariatPublic;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Secretariatpublic controller.
 *
 * @Route("secretariatpublic/{_locale}", defaults = {"_locale" = "fr"})
 */
class SecretariatPublicController extends Controller
{
    /**
     * Lists all secretariatPublic entities.
     *
     * @Route("/", name="secretariatpublic_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $secretariatPublics = $em->getRepository('AMLASqrBundle:SecretariatPublic')->findAll();

        return $this->render('secretariatpublic/index.html.twig', array(
            'secretariatPublics' => $secretariatPublics,
        ));
    }

    /**
     * Creates a new secretariatPublic entity.
     *
     * @Route("/new", name="secretariatpublic_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $secretariatPublic = new Secretariatpublic();
        $form = $this->createForm('AMLA\SqrBundle\Form\SecretariatPublicType', $secretariatPublic);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($secretariatPublic);
            $em->flush();

            return $this->redirectToRoute('secretariatpublic_show', array('id' => $secretariatPublic->getId()));
        }

        return $this->render('secretariatpublic/new.html.twig', array(
            'secretariatPublic' => $secretariatPublic,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a secretariatPublic entity.
     *
     * @Route("/{id}", name="secretariatpublic_show")
     * @Method("GET")
     */
    public function showAction(SecretariatPublic $secretariatPublic)
    {
        $deleteForm = $this->createDeleteForm($secretariatPublic);

        return $this->render('secretariatpublic/show.html.twig', array(
            'secretariatPublic' => $secretariatPublic,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing secretariatPublic entity.
     *
     * @Route("/{id}/edit", name="secretariatpublic_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, SecretariatPublic $secretariatPublic)
    {
        $deleteForm = $this->createDeleteForm($secretariatPublic);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\SecretariatPublicType', $secretariatPublic);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('secretariatpublic_edit', array('id' => $secretariatPublic->getId()));
        }

        return $this->render('secretariatpublic/edit.html.twig', array(
            'secretariatPublic' => $secretariatPublic,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a secretariatPublic entity.
     *
     * @Route("/{id}", name="secretariatpublic_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, SecretariatPublic $secretariatPublic)
    {
        $form = $this->createDeleteForm($secretariatPublic);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($secretariatPublic);
            $em->flush();
        }

        return $this->redirectToRoute('secretariatpublic_index');
    }

    /**
     * Creates a form to delete a secretariatPublic entity.
     *
     * @param SecretariatPublic $secretariatPublic The secretariatPublic entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(SecretariatPublic $secretariatPublic)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('secretariatpublic_delete', array('id' => $secretariatPublic->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
