<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\RemiseGracieuse;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Remisegracieuse controller.
 *
 * @Route("remisegracieuse/{_locale}", defaults = {"_locale" = "fr"})
 */
class RemiseGracieuseController extends Controller
{
    /**
     * Lists all remiseGracieuse entities.
     *
     * @Route("/", name="remisegracieuse_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $remiseGracieuses = $em->getRepository('AMLASqrBundle:RemiseGracieuse')->findAll();

        return $this->render('remisegracieuse/index.html.twig', array(
            'remiseGracieuses' => $remiseGracieuses,
        ));
    }

    /**
     * Lists all remiseGracieuse entities.
     *
     * @Route("/mine", name="remisegracieuse_index_mine")
     * @Method("GET")
     */
    public function indexMineAction()
    {
        $em = $this->getDoctrine()->getManager();

        //$remiseGracieuses = $em->getRepository('AMLASqrBundle:RemiseGracieuse')->findBy(['']));

        return $this->render('remisegracieuse/index_mine.html.twig', array(
            'fournisseur' => $this->getUser()->getFournisseurs()[0],
        ));
    }

    /**
     * Creates a new remiseGracieuse entity.
     *
     * @Route("/new", name="remisegracieuse_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $remiseGracieuse = new Remisegracieuse();
        $form = $this->createForm('AMLA\SqrBundle\Form\RemiseGracieuseType', $remiseGracieuse);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) 
        {
            /*
            $em = $this->getDoctrine()->getManager();
            $em->persist($remiseGracieuse);
            $em->flush();

            return $this->redirectToRoute('remisegracieuse_show', array('id' => $remiseGracieuse->getId()));*/
            $this->get('session')->getFlashBag()->add('danger', 'La référence est introuvable');
        }

        return $this->render('remisegracieuse/new.html.twig', array(
            'remiseGracieuse' => $remiseGracieuse,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a remiseGracieuse entity.
     *
     * @Route("/{id}", name="remisegracieuse_show")
     * @Method("GET")
     */
    public function showAction(RemiseGracieuse $remiseGracieuse)
    {
        $deleteForm = $this->createDeleteForm($remiseGracieuse);

        return $this->render('remisegracieuse/show.html.twig', array(
            'remiseGracieuse' => $remiseGracieuse,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing remiseGracieuse entity.
     *
     * @Route("/{id}/edit", name="remisegracieuse_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, RemiseGracieuse $remiseGracieuse)
    {
        $deleteForm = $this->createDeleteForm($remiseGracieuse);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\RemiseGracieuseType', $remiseGracieuse);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('remisegracieuse_edit', array('id' => $remiseGracieuse->getId()));
        }

        return $this->render('remisegracieuse/edit.html.twig', array(
            'remiseGracieuse' => $remiseGracieuse,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a remiseGracieuse entity.
     *
     * @Route("/{id}", name="remisegracieuse_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, RemiseGracieuse $remiseGracieuse)
    {
        $form = $this->createDeleteForm($remiseGracieuse);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($remiseGracieuse);
            $em->flush();
        }

        return $this->redirectToRoute('remisegracieuse_index');
    }

    /**
     * Creates a form to delete a remiseGracieuse entity.
     *
     * @param RemiseGracieuse $remiseGracieuse The remiseGracieuse entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(RemiseGracieuse $remiseGracieuse)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('remisegracieuse_delete', array('id' => $remiseGracieuse->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
