<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\RelationAffaire;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Relationaffaire controller.
 *
 * @Route("relationaffaire/{_locale}", defaults = {"_locale" = "fr"})
 */
class RelationAffaireController extends Controller
{
    /**
     * Lists all relationAffaire entities.
     *
     * @Route("/", name="relationaffaire_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $relationAffaires = $em->getRepository('AMLASqrBundle:RelationAffaire')->findAll();

        return $this->render('relationaffaire/index.html.twig', array(
        //return $this->render('invitation/index.html.twig', array(
            'relationAffaires' => $relationAffaires,
        ));
    }
    
    /**
     * Lists all relationaffaire entities.
     *
     * @Route("/mine", name="relationaffaire_mine")
     * @Method("GET")
     */
    public function mineAction()
    {
        if($this->getUser() && !empty($this->getUser()->getRole())) 
        {
            $fournisseur = $this->getUser()->getCompagnyId();

            $em = $this->getDoctrine()->getManager();

            $relationAffaires = $em->getRepository('AMLASqrBundle:RelationAffaire')->getMyRelations($fournisseur);

            return $this->render('relationaffaire/mine.html.twig', array(
                'relationAffaires' => $relationAffaires,
            ));
        }else
        {
            $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
            return $this->redirectToRoute('dashboard_index');
        }
    }

    /**
     * Lists all relationaffaire entities.
     *
     * @Route("/to/validate", name="relationaffaire_to_validate")
     * @Method("GET")
     */
    public function toValidateAction()
    {
        if($this->getUser() && !empty($this->getUser()->getRole())) 
        {
            $fournisseur = $this->getUser()->getCompagnyId();

            $em = $this->getDoctrine()->getManager();

            $relationAffaires = $em->getRepository('AMLASqrBundle:RelationAffaire')->getToValidateRelations($fournisseur);

            return $this->render('relationaffaire/to_validate.html.twig', array(
                'relationAffaires' => $relationAffaires,
            ));
        }else
        {
            $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
            return $this->redirectToRoute('dashboard_index');
        }
    }

    /**
     * Lists all relationaffaire entities.
     *
     * @Route("/rejected", name="relationaffaire_rejected")
     * @Method("GET")
     */
    public function rejectedAction()
    {
        if($this->getUser() && !empty($this->getUser()->getRole())) 
        {
            $fournisseur = $this->getUser()->getCompagnyId();

            $em = $this->getDoctrine()->getManager();

            $relationAffaires = $em->getRepository('AMLASqrBundle:RelationAffaire')->getRejectedRelations($fournisseur);

            return $this->render('relationaffaire/rejected.html.twig', array(
                'relationAffaires' => $relationAffaires,
            ));
        }else
        {
            $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
            return $this->redirectToRoute('dashboard_index');
        }
    }

    /**
     * Lists all relationaffaire entities.
     *
     * @Route("/sent", name="relationaffaire_sent")
     * @Method("GET")
     */
    public function sentAction()
    {
        if($this->getUser() && !empty($this->getUser()->getRole())) 
        {
            $fournisseur = $this->getUser()->getCompagnyId();

            $em = $this->getDoctrine()->getManager();
            $user = $this->getUser();
            $relationAffaires = $em->getRepository('AMLASqrBundle:RelationAffaire')->getSentRelations($fournisseur);

            return $this->render('relationaffaire/sent.html.twig', array(
                'relationAffaires' => $relationAffaires,
            ));
        }else
        {
            $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
            return $this->redirectToRoute('dashboard_index');
        }
    }

    /**
     * Lists all relationaffaire entities.
     *
     * @Route("/received", name="relationaffaire_received")
     * @Method("GET")
     */
    public function receivedAction()
    {
        if($this->getUser() && !empty($this->getUser()->getRole())) 
        {
            $fournisseur = $this->getUser()->getCompagnyId();

            $em = $this->getDoctrine()->getManager();
            $user = $this->getUser();
            $relationAffaires = $em->getRepository('AMLASqrBundle:RelationAffaire')->getReceiptRelations($fournisseur);

            return $this->render('relationaffaire/received.html.twig', array(
                'relationAffaires' => $relationAffaires,
            ));
        }else
        {
            $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
            return $this->redirectToRoute('dashboard_index');
        }
    }


    /**
     * Lists all relations entities.
     *
     * @Route("/{id}/{action}/traiter", name="relationsaffaire_traiter")
     * @Method({"GET","POST"})
     */
    public function traitementAction(RelationAffaire $relationAffaire, $action)
    {
        if($this->getUser() && !empty($this->getUser()->getRole())) 
        {
            $fournisseur = $this->getUser()->getCompagnyId();
            $user = $this->getUser();

            $em = $this->getDoctrine()->getManager();
            if ($relationAffaire->getIsAcceptFinal() == 0) 
            {
                if($action == "VALIDER")
                {
                    $relationAffaire->setIsAcceptFinal(1);

                    try
                    {
                        $message = (new \Swift_Message('CHECKTATOO - Invitation'))
                        ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
                        //->setTo($moa->getAdresseEmail())
                        ->setTo($relationAffaire->getFournisseurEnAffaire()->getAdresseEmail())
                        ->setBody(
                            $this->renderView(
                                'emails/relationaffairevalidation.html.twig',array(
                                'sender' => $relationAffaire->getFournisseurEnAffaire(), )
                            ),
                            'text/html'
                        );

                        $this->get('mailer')->send($message);

                    } catch (\Exception $e)
                    {
                        dump($e);die;
                        $this->addFlash('danger','une erreur est survenue lors de l\'envoie du mail');
                        return $this->redirectToRoute('dashboard_index');
                    }

                    try {

                        $message = (new \Swift_Message('CHECKTATOO - Invitation'))
                        ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
                        //->setTo($fournisseur->getAdresseEmail())
                        ->setTo($relationAffaire->getFournisseurInitial()->getAdresseEmail())
                        ->setBody(
                            $this->renderView(
                                'emails/relationaffairevalidsender.html.twig',array(
                                'receiver' => $relationAffaire->getFournisseurInitial(), )
                            ),
                            'text/html'
                        );

                        $this->get('mailer')->send($message);
                    } catch (\Exception $e) 
                    {
                        dump($e);die;
                        $this->addFlash('danger','une erreur est survenue lors de l\'envoie du mail');
                        return $this->redirectToRoute('dashboard_index');
                    } 
                    $this->get('session')->getFlashBag()->add('success', "Relation d'affaire accepté avec succès !!!");

                }elseif ($action == "REJETER") 
                {
                    // code...
                    $relationAffaire->setIsAcceptFinal(2);
                    $this->get('session')->getFlashBag()->add('danger', "Relation d'affaire rejeté avec succès !!!");
                }

                $em->persist($relationAffaire);
                $em->flush();
                
            }

            return $this->redirectToRoute('relationaffaire_to_validate');

        }else
        {
            $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
            return $this->redirectToRoute('dashboard_index');
        }
    }

    /**
     * Creates a new relationAffaire entity.
     *
     * @Route("/new", name="relationaffaire_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $relationAffaire = new Relationaffaire();
        $form = $this->createForm('AMLA\SqrBundle\Form\RelationAffaireType', $relationAffaire);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($relationAffaire);
            $em->flush();

            return $this->redirectToRoute('relationaffaire_show', array('id' => $relationAffaire->getId()));
        }

        return $this->render('relationaffaire/new.html.twig', array(
            'relationAffaire' => $relationAffaire,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a relationAffaire entity.
     *
     * @Route("/{id}", name="relationaffaire_show")
     * @Method("GET")
     */
    public function showAction(RelationAffaire $relationAffaire)
    {
        $deleteForm = $this->createDeleteForm($relationAffaire);

        return $this->render('relationaffaire/show.html.twig', array(
            'relationAffaire' => $relationAffaire,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing relationAffaire entity.
     *
     * @Route("/{id}/edit", name="relationaffaire_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, RelationAffaire $relationAffaire)
    {
        $deleteForm = $this->createDeleteForm($relationAffaire);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\RelationAffaireType', $relationAffaire);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('relationaffaire_edit', array('id' => $relationAffaire->getId()));
        }

        return $this->render('relationaffaire/edit.html.twig', array(
            'relationAffaire' => $relationAffaire,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a relationAffaire entity.
     *
     * @Route("/{id}", name="relationaffaire_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, RelationAffaire $relationAffaire)
    {
        $form = $this->createDeleteForm($relationAffaire);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($relationAffaire);
            $em->flush();
        }

        return $this->redirectToRoute('relationaffaire_index');
    }

    /**
     * Creates a form to delete a relationAffaire entity.
     *
     * @param RelationAffaire $relationAffaire The relationAffaire entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(RelationAffaire $relationAffaire)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('relationaffaire_delete', array('id' => $relationAffaire->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
