<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\RegimeFiscal;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Regimefiscal controller.
 *
 * @Route("regimefiscal/{_locale}", defaults = {"_locale" = "fr"})
 */
class RegimeFiscalController extends Controller
{
    /**
     * Lists all regimeFiscal entities.
     *
     * @Route("/", name="regimefiscal_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $regimeFiscals = $em->getRepository('AMLASqrBundle:RegimeFiscal')->findAll();

        return $this->render('regimefiscal/index.html.twig', array(
            'regimeFiscals' => $regimeFiscals,
        ));
    }

    /**
     * Creates a new regimeFiscal entity.
     *
     * @Route("/new", name="regimefiscal_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $regimeFiscal = new Regimefiscal();
        $form = $this->createForm('AMLA\SqrBundle\Form\RegimeFiscalType', $regimeFiscal);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($regimeFiscal);
            $em->flush();

            return $this->redirectToRoute('regimefiscal_show', array('id' => $regimeFiscal->getId()));
        }

        return $this->render('regimefiscal/new.html.twig', array(
            'regimeFiscal' => $regimeFiscal,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a regimeFiscal entity.
     *
     * @Route("/{id}", name="regimefiscal_show")
     * @Method("GET")
     */
    public function showAction(RegimeFiscal $regimeFiscal)
    {
        $deleteForm = $this->createDeleteForm($regimeFiscal);

        return $this->render('regimefiscal/show.html.twig', array(
            'regimeFiscal' => $regimeFiscal,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing regimeFiscal entity.
     *
     * @Route("/{id}/edit", name="regimefiscal_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, RegimeFiscal $regimeFiscal)
    {
        $deleteForm = $this->createDeleteForm($regimeFiscal);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\RegimeFiscalType', $regimeFiscal);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('regimefiscal_edit', array('id' => $regimeFiscal->getId()));
        }

        return $this->render('regimefiscal/edit.html.twig', array(
            'regimeFiscal' => $regimeFiscal,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a regimeFiscal entity.
     *
     * @Route("/{id}", name="regimefiscal_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, RegimeFiscal $regimeFiscal)
    {
        $form = $this->createDeleteForm($regimeFiscal);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($regimeFiscal);
            $em->flush();
        }

        return $this->redirectToRoute('regimefiscal_index');
    }

    /**
     * Creates a form to delete a regimeFiscal entity.
     *
     * @param RegimeFiscal $regimeFiscal The regimeFiscal entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(RegimeFiscal $regimeFiscal)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('regimefiscal_delete', array('id' => $regimeFiscal->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
