<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\API\SqrApi;
use AMLA\SqrBundle\Entity\BonCommande;
use AMLA\SqrBundle\Entity\ProcesVerbal;
use AMLA\SqrBundle\Entity\ReceptionTravaux;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;

/**
 * Receptiontravaux controller.
 *
 * @Route("receptiontravaux/{_locale}", defaults = {"_locale" = "fr"})
 */
class ReceptionTravauxController extends Controller
{
    /**
     * Lists all receptionTravaux entities.
     *
     * @Route("/", name="receptiontravaux_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $receptionTravauxes = $em->getRepository('AMLASqrBundle:ReceptionTravaux')->findAll();

        return $this->render('receptiontravaux/index.html.twig', array(
            'receptionTravauxes' => $receptionTravauxes,
        ));
    }

     /**
     * Creates a new demo entity.
     *
     * @Route("/suivi-travaux", name="receptiontravaux_suivi")
     * @Method({"GET", "POST"})
     */
    public function suiviTravauxAction(Request $request)
    {

        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]); 
        $bonCommandes = $em->getRepository('AMLASqrBundle:BonCommande')->getBonCommandeUser($fournisseur);
        

        return $this->render('receptiontravaux/receptiontravaux.html.twig', array(
            'bonCommandes' => $bonCommandes,
        ));

       /*
        $commandes =$em->getRepository('AMLASqrBundle:BonCommande')->findAll();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);

        $offres = $em->getRepository('AMLASqrBundle:Offre')->findBy(['fournisseur'=>$fournisseur->getId(), 'statut'=>1]);
        */ 
    }

    
     /**
     * Creates a new demo entity.
     *
     * @Route("/commandes", name="receptiontravaux_commandes")
     * @Method({"GET", "POST"})
     */
    public function travauxCommandesAction(Request $request)
    {

        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]); 
        $receptionTravauxes = $em->getRepository('AMLASqrBundle:ReceptionTravaux')->getTravauxCommandes($fournisseur);

       //$bonCommandes = $em->getRepository('AMLASqrBundle:BonCommande')->getBonCommandeUser($fournisseur);

        return $this->render('receptiontravaux/travauxcommandes.html.twig', array(
            'receptionWorks' => $receptionTravauxes,
        ));
    }
    
    /**
    * Creates a new demo entity.
    *
    * @Route("/realise", name="receptiontravaux_realise")
    * @Method({"GET", "POST"})
    */
   public function travauxRealiseAction(Request $request)
   {

       $em = $this->getDoctrine()->getManager();

       $user = $this->getUser();
       $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]); 
       $receptionTravauxes = $em->getRepository('AMLASqrBundle:ReceptionTravaux')->getTravauxRealises($fournisseur);

       return $this->render('receptiontravaux/travauxrealises.html.twig', array(
           'receptionWorks' => $receptionTravauxes,
       ));

   }
    
   /**
   * Creates a new demo entity.
   *
   * @Route("/new", name="receptiontravaux_nouvelle_reception")
   * @Method({"GET", "POST"})
   */
  public function nouvelleReceptionAction(Request $request)
  {

      $em = $this->getDoctrine()->getManager();

      $user = $this->getUser();
      $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]); 
      //$receptionTravauxes = $em->getRepository('AMLASqrBundle:ReceptionTravaux')->getTravauxRealises($fournisseur);
        $bonCommandes = $em->getRepository('AMLASqrBundle:BonCommande')->getBonCommandeDemandeReception($fournisseur);


      return $this->render('receptiontravaux/receptiontravaux.html.twig', array(
          'bonCommandes' => $bonCommandes,
      ));

  }

    /**
     * Creates a new receptionTravaux entity.
     *
     * @Route("/{id}/new", name="receptiontravaux_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request, BonCommande $bonCommande)
    {
        $receptionTravaux = new Receptiontravaux();
        //$form = $this->createForm('AMLA\SqrBundle\Form\ReceptionTravauxType', $receptionTravaux);
        $form = $this->createForm('AMLA\SqrBundle\Form\ReceptionTravauxDemandeType', $receptionTravaux);
        $form->handleRequest($request);
        

        if ($form->isSubmitted() && $form->isValid()) 
        {
            $recep= $request->get('typeReception');
            $tauxRealisation = $request->get('taux');
            
            $em = $this->getDoctrine()->getManager();
            $pverbal = new ProcesVerbal();
            $pverbal->setBonCommande($bonCommande);
            $pverbal->setReference('PV_Travaux'.$pverbal->randomString());
            $pverbal->setTypePV('Travaux');
            $receptionTravaux->setBonCommande($bonCommande);
            $receptionTravaux->setTypeReception($recep);
            $receptionTravaux->setPourcentageReception($tauxRealisation);
            
            $offre = $bonCommande->getSoummissionOffre()->getOffre();
            $fournisseur = $bonCommande->getSoummissionOffre()->getFournisseur();
            
            //Paramètres de base à envoyer à l'API
            $cle = 'MW7-ZDT-LDQ';
            $piece = 'PV de Travaux';
            $proprietaire = 'Adjudicateur: '.$fournisseur->getRaisonSociale().' '.'Titulaire de marché: '.$offre->getFournisseur()->getRaisonSociale();

            //Données à transmettre à l'API
            $post = array(
                'cle' => $cle,
                'pieceqr'=> $piece, 
                'proprietaire' => $proprietaire, 
                'Reference de l\'offre' => $offre->getReference(),
                'Reference du bon de commande' => $bonCommande->getReference(),
                'Objet de l\'offre' => $offre->getObjet(),
                'Nom du titulaire du marché' => $offre->getFournisseur()->getRaisonSociale(),
                'Nom de l\'adjudicateur' => $fournisseur->getRaisonSociale(),
                'Cautionnement' =>  $bonCommande->getCautionnement()?'Avec Cautionnement':'Sans Cautionnement',
                'Prix du cautionnement' =>  $bonCommande->getPrixCautionnement(),
                'Retenue de garantie' => $bonCommande->getRetenueGarantie(),
                'Montant HT' =>  $bonCommande->getMontant(),
                'Montant TTC' =>  $bonCommande->getMontant(),
            );

            $container = $this->container;
            $api = new SqrApi($container);
            $res = $api->callAPI($post);
            
            if($res[0]){
    
                $qr = $res[0]->qr;
                $num = $res[0]->niu; 
            }

            $newname = 'PV_TRAV_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
            $checkqr = $api->generateQr($qr,$num,$newname);
            $checkqr->setChemin($newname);
            $pverbal->setQrCode($checkqr);
             //Génération du Bordereau avec MPDF
            $target = __DIR__.'/../../../../web/generated/ProcesVerbaux/boncommande_'.$bonCommande->getId().'/adjudicateur_'.$fournisseur->getRaisonSociale().'/titulaire_'.$offre->getFournisseur()->getRaisonSociale().'/';
            $name = 'PV_TRAVAUX_'.$pverbal->getReference().'.pdf';
            /* dump($this->get('kernel')->getRootDir().'/web/'.$request->getBasePath().$boncommande->getQrCode()->getChemin());
            die; */
            $pdf = $this->renderView('procesverbal/procesverbal.html.1.twig', array(
                'verbal' => $pverbal,
                'fournisseur' => $fournisseur,
                'offre'=>$offre,
                'reception'=>$receptionTravaux,
                'imageqr'=> $pverbal->getQrCode()->getChemin(),
                'base_dir' => $this->get('kernel')->getRootDir().'/../web'.$request->getBasePath(),
            ));

            try{

                $mpdf = new \Mpdf\Mpdf();
                $mpdf->WriteHtml($pdf);
                if (file_exists($target) != 1) {
    
                    mkdir($target,0777,true);
                    $mpdf->Output($target.$name, 'F');
                }else{
                    $mpdf->Output($target.$name, 'F');
                }
    
            }catch(MpdfException $e){
    
                die($e->getMessage());
                $this->get('session')->getFlashBag()->add('danger', 'Erreur lors de l\'émission du PV de travaux');
            }

            $receptionTravaux->setPvTravaux('generated/ProcesVerbaux/boncommande_'.$bonCommande->getId().'/adjudicateur_'.$fournisseur->getRaisonSociale().'/titulaire_'.$offre->getFournisseur()->getRaisonSociale().'/'.$name);
            $em->persist($checkqr);
            $em->persist($pverbal);
            $em->persist($receptionTravaux);
            $em->flush();
            //Envoie des mails
            $this->get('session')->getFlashBag()->add('success', 'PV de travaux émis avec succès!');
            return $this->redirectToRoute('receptiontravaux_show', array('id' => $receptionTravaux->getId()));
        }

        return $this->render('receptiontravaux/new.html.twig', array(
            'receptionTravaux' => $receptionTravaux,
            'bonCommande'=>$bonCommande,
            'form' => $form->createView(),
        ));
    }

    /**
     * Creates a new receptionTravaux entity.
     *
     * @Route("/{id}/valider", name="receptiontravaux_valider")
     * @Method({"GET", "POST"})
     */
    public function newValiderAction(Request $request, ReceptionTravaux $receptionWork)
    {
        //$receptionTravaux = new Receptiontravaux();
        //$form = $this->createForm('AMLA\SqrBundle\Form\ReceptionTravauxType', $receptionTravaux);
        $form = $this->createForm('AMLA\SqrBundle\Form\ReceptionTravauxType', $receptionWork);
        $form->handleRequest($request);
        

        if ($form->isSubmitted() && $form->isValid()) 
        {
            $em = $this->getDoctrine()->getManager();
            $bonCommande = $receptionWork->getBonCommande();
            $percentDone= $bonCommande->getTauxRecu();
            $percentSuggest= $receptionWork->getPourcentageReception();
            $percentSum = $percentDone+$percentSuggest;
            
            //dump($bonCommande->getResteReceptionner());die;
            if($percentDone<100 && $percentSum<=100)
            {
                $pverbal = new ProcesVerbal();
                $pverbal->setBonCommande($bonCommande);
                $pverbal->setReference('PV_RCPT'.$pverbal->randomString());
                $pverbal->setTypePV('Reception');

                $offre = $bonCommande->getSoummissionOffre()->getOffre();
                $fournisseur = $bonCommande->getSoummissionOffre()->getFournisseur();
                
                //Paramètres de base à envoyer à l'API
                $cle = 'MW7-ZDT-LDQ';
                $piece = 'PV de Travaux';
                $proprietaire = 'Adjudicateur: '.$fournisseur->getRaisonSociale().' '.'Titulaire de marché: '.$offre->getFournisseur()->getRaisonSociale();

                //Données à transmettre à l'API
                $post = array(
                    'cle' => $cle,
                    'pieceqr'=> $piece, 
                    'proprietaire' => $proprietaire, 
                    'Reference de l\'offre' => $offre->getReference(),
                    'Reference du bon de commande' => $bonCommande->getReference(),
                    'Objet de l\'offre' => $offre->getObjet(),
                    'Nom du titulaire du marché' => $offre->getFournisseur()->getRaisonSociale(),
                    'Nom de l\'adjudicateur' => $fournisseur->getRaisonSociale(),
                    'Cautionnement' =>  $bonCommande->getCautionnement()?'Avec Cautionnement':'Sans Cautionnement',
                    'Prix du cautionnement' =>  $bonCommande->getPrixCautionnement(),
                    'Retenue de garantie' => $bonCommande->getRetenueGarantie(),
                    'Montant HT' =>  $bonCommande->getMontant(),
                    'Montant TTC' =>  $bonCommande->getMontant(),
                );

                $container = $this->container;
                $api = new SqrApi($container);
                $res = $api->callAPI($post);
                
                if($res[0]){
        
                    $qr = $res[0]->qr;
                    $num = $res[0]->niu; 
                }

                $newname = 'PV_RCPT_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
                $checkqr = $api->generateQr($qr,$num,$newname);
                $checkqr->setChemin($newname);
                $pverbal->setQrCode($checkqr);
                //Génération du Bordereau avec MPDF
                $target = __DIR__.'/../../../../web/generated/ProcesVerbaux/boncommande_'.$bonCommande->getId().'/adjudicateur_'.$fournisseur->getRaisonSociale().'/titulaire_'.$offre->getFournisseur()->getRaisonSociale().'/';
                $name = 'PV_RECEPTION_'.$pverbal->getReference().'.pdf';

                /* dump($this->get('kernel')->getRootDir().'/web/'.$request->getBasePath().$boncommande->getQrCode()->getChemin());
                die; */
                $pdf = $this->renderView('procesverbal/pvreception.html.1.twig', array(
                    'verbal' => $pverbal,
                    'fournisseur' => $fournisseur,
                    'offre'=>$offre,
                    'reception'=>$receptionWork,
                    'imageqr'=> $pverbal->getQrCode()->getChemin(),
                    'base_dir' => $this->get('kernel')->getRootDir().'/../web'.$request->getBasePath(),
                ));
    
                try{

                    $mpdf = new \Mpdf\Mpdf();
                    $mpdf->WriteHtml($pdf);
                    if (file_exists($target) != 1) 
                    {
        
                        mkdir($target,0777,true);
                        $mpdf->Output($target.$name, 'F');
                    }else{
                        $mpdf->Output($target.$name, 'F');
                    }
        
                }catch(MpdfException $e)
                {    
                    die($e->getMessage());
                    $this->get('session')->getFlashBag()->add('danger', 'Erreur lors de l\'émission du PV de travaux');
                }
                //dump($request->get('amla_sqrbundle_receptiontravaux')['memberList']);die;
                $memList= $request->get('amla_sqrbundle_receptiontravaux')['memberList'];
                $dateCom= new \ Datetime($request->get('amla_sqrbundle_receptiontravaux')['dateCommission']);

                $receptionWork->setDateCommission($dateCom);
                $receptionWork->setMemberList($memList);
                $receptionWork->setStatut(1);
                $bonCommande->setTauxRecu($percentSum);
                if($percentSum==100)
                {
                    $bonCommande->setStatut(0);
                }

                $em->persist($bonCommande);
                $em->persist($checkqr);
                $em->persist($pverbal);
                $em->persist($receptionWork);
                $em->flush();

                $this->get('session')->getFlashBag()->add('success', 'La demande de reception a été validé avec succès !');

                return $this->redirectToRoute('receptiontravaux_show', array('id' => $receptionWork->getId()));
            }

            $this->get('session')->getFlashBag()->add('success', 'Le taux de réalisation pour cette demande de reception est incohérent !');
            
        }

        return $this->render('receptiontravaux/receptiontravauxvalider.html.twig', array(
            //'receptionTravaux' => $receptionTravaux,
            'receptionWork'=>$receptionWork,
            'form' => $form->createView(),
        ));
    }


    /**
     * Creates a new receptionTravaux entity.
     *
     * @Route("/{id}/rejeter", name="receptiontravaux_rejeter")
     * @Method({"GET", "POST"})
     */
    public function newRejeterAction(Request $request, ReceptionTravaux $receptionWork)
    {
        
        $em = $this->getDoctrine()->getManager();
        
        $receptionWork->setStatut(3);
        $em->persist($receptionWork);
        $em->flush();

        $this->get('session')->getFlashBag()->add('success', 'La demande de reception des travaux a été rejeté avec succès!');

        return $this->redirectToRoute('receptiontravaux_commandes');
    }

    /**
     * Finds and displays a receptionTravaux entity.
     *
     * @Route("/{id}", name="receptiontravaux_show")
     * @Method("GET")
     */
    public function showAction(ReceptionTravaux $receptionTravaux)
    {
        $deleteForm = $this->createDeleteForm($receptionTravaux);

        return $this->render('receptiontravaux/show.html.twig', array(
            'receptionTravaux' => $receptionTravaux,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing receptionTravaux entity.
     *
     * @Route("/{id}/edit", name="receptiontravaux_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, ReceptionTravaux $receptionTravaux)
    {
        $deleteForm = $this->createDeleteForm($receptionTravaux);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\ReceptionTravauxType', $receptionTravaux);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('receptiontravaux_edit', array('id' => $receptionTravaux->getId()));
        }

        return $this->render('receptiontravaux/edit.html.twig', array(
            'receptionTravaux' => $receptionTravaux,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a receptionTravaux entity.
     *
     * @Route("/{id}", name="receptiontravaux_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, ReceptionTravaux $receptionTravaux)
    {
        $form = $this->createDeleteForm($receptionTravaux);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($receptionTravaux);
            $em->flush();
        }

        return $this->redirectToRoute('receptiontravaux_index');
    }

    /**
     * Creates a form to delete a receptionTravaux entity.
     *
     * @param ReceptionTravaux $receptionTravaux The receptionTravaux entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(ReceptionTravaux $receptionTravaux)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('receptiontravaux_delete', array('id' => $receptionTravaux->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
