<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Quittance;
use AMLA\SqrBundle\Entity\FactureSpontane ;
use AMLA\SqrBundle\Entity\Notification ;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use AMLA\SqrBundle\API\SqrApi as SqrApi; 

/**
 * Quittance controller.
 *
 * @Route("quittance/{_locale}", defaults = {"_locale" = "fr"})
 */
class QuittanceController extends Controller
{
    /**
     * Lists all quittance entities.
     *
     * @Route("/", name="quittance_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $quittances = $em->getRepository('AMLASqrBundle:Quittance')->findAll();

        return $this->render('quittance/index.html.twig', array(
            'quittances' => $quittances,
        ));
    }

    /**
     * Lists all quittance entities.
     *
     * @Route("/emises", name="quittance_emise_secure")
     * @Method("GET")
     */
    public function indexEmisesAction()
    {
        if ($this->getUser() && !empty($this->getUser()->getRole()))
        {
            $em = $this->getDoctrine()->getManager();

            $quittances = $em->getRepository('AMLASqrBundle:Quittance')->findBy(['sender'=>$this->getUser()], ['id'=>'DESC']);

            return $this->render('quittance/emises.html.twig', array(
                'quittances' => $quittances,
            ));

        }else
        {
            $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
            return $this->redirectToRoute('dashboard_index');
        }
    }

    /**
     * Lists all quittance entities.
     *
     * @Route("/recues", name="quittance_recu_secure")
     * @Method("GET")
     */
    public function indexRecuesAction()
    {
        if ($this->getUser() && !empty($this->getUser()->getRole()))
        {
            //dump($this->getUser());die;
            $niu = $this->getUser()->getCompagnyId()->getNiu();
            $em = $this->getDoctrine()->getManager();

            $quittances = $em->getRepository('AMLASqrBundle:Quittance')->findBy(['receiverNiu'=>$niu], ['id'=>'DESC']);

            return $this->render('quittance/recues.html.twig', array(
                'quittances' => $quittances,
            ));

        }else
        {
            $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
            return $this->redirectToRoute('dashboard_index');
        }
    }
    

    /**
     * Creates a new quittance entity.
     *
     * @Route("/new/secure", name="quittance_new_secure")
     * @Method({"GET", "POST"})
     */
    public function newSecureAction(Request $request)
    {
        $quittance = new Quittance();
        $form = $this->createForm('AMLA\SqrBundle\Form\QuittanceType', $quittance);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) 
        {
            $em = $this->getDoctrine()->getManager();
            $quittance->setSender($this->getUser());           

            $frnisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['niu'=>$quittance->getReceiverNiu()]);
                
            if(!empty($frnisseur))
            {
                /**************Add Notification for received  */
                $notificationO = New Notification();
                $notificationO->setTitle('Reception Quittance sécurisée');
                $notificationO->setDescription('Une quittance sécurisée a été émis à votre endroit par le contribuable '.$this->getUser()->getFournisseurs()[0]->getRaisonSociale().' - '.$this->getUser()->getFournisseurs()[0]->getNiu().' la référence de paiement est'.$quittance->getReference(). '. Vous pouvez consulter le détail dans la section quittances reçues');
                $notificationO->setFournisseur($frnisseur); 
                $em->persist($notificationO);
                /**************End Add Notification */
            }

             /**************Add Notification for sent Bill */
             $notificationI = New Notification();
             $notificationI->setTitle('Emission Quittance sécurisée');
             $notificationI->setDescription('Vous avez émis une nouvelle Quittance sécurisée au contribuable '.$quittance->getReceiverSocialReason().' '. $quittance->getReceiverNiu().'. La référence pour la quittance est '.$quittance->getReference());
             $notificationI->setFournisseur($this->getUser()->getFournisseurs()[0]); 
             $em->persist($notificationI);
             /**************End Add Notification */
           

            $cle = $this->getParameter('api_key');
            $piece = 'Quittance sécurisée';
            $proprietaire = 'Emetteur: '.$this->getUser()->getFournisseurs()[0]->getRaisonSociale().' '.'Destinataire: '.$quittance->getReceiverSocialReason().' '. $quittance->getReceiverNiu();

            $post = array(
                'cle' => $cle,
                'pieceqr'=> $piece, 
                'proprietaire' => $proprietaire, 
            );

            $container = $this->container;
            $api = new SqrApi($container);
            $res = $api->callAPI($post);
            
            if($res[0]){

                $qr = $res[0]->qr;
                $num = $res[0]->niu; 
            }
            
            $newname = 'QUITTANCE_Securisee_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
            //Génération du facture avec MPDF
            $name = 'QUITTANCE_Securisee_'.$num.'.pdf';
            $target = __DIR__.'/../../../../web/Production_documentaire/quittances/';
            //$checkqr = new CheckQr();
            $checkqr = $api->generateQr($qr,$num,$newname);
            $checkqr->setChemin($newname);
            $quittance->setTransactionNumber($checkqr); 

            $quittance->setPdf('Production_documentaire/quittances/'.$name);
           
            $pdf = $this->renderView('print/quittances.html.twig', array(
                // 'imageqr'=> $impotVerif->getQrCode()->getChemin(),
                //'impotVerif' => $impotVerif,   
                'imageqr'=> $quittance->getTransactionNumber()->getChemin(),
                'factureSpontane'=>$quittance,
                'base_dir' => $this->get('kernel')->getRootDir() . '/../web',
            ));

            try{

                $mpdf = new \Mpdf\Mpdf();
                $mpdf->WriteHtml($pdf);
                if (file_exists($target) != 1)
                {
                    mkdir($target,0777,true);
                    $mpdf->Output($target.$name, 'F');
                }else
                {
                    $mpdf->Output($target.$name, 'F');
                }

            }catch(MpdfException $e)
            {
                $this->get('session')->getFlashBag()->add('danger', 'Erreur lors de l\'émission de la quittance');
                die($e->getMessage());
            }


            $em->persist($checkqr);
            $em->persist($quittance);
            $em->flush(); 

            /*$factureSpontaneArticles = $em->getRepository('AMLASqrBundle:FactureSpontaneArticle')->findBy(['factureSpontane'=>$factureSpontane]);
            //dump($factureSpontaneArticles);die;
            $msg = (new \Swift_Message('CHECKTATOO - Facture sécurisé'))
            ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
            ->setTo($factureSpontane->getBeneficiaireEmail())
            ->setBody(
                $this->renderView(
                    'emails/emissionFactureSecurise.html.twig',array(
                        'factureSpontane' =>$factureSpontane,
                        'factureSpontaneArticles' => $factureSpontaneArticles,
                    )
                ),
                'text/html'
            )
            ->attach(\Swift_Attachment::fromPath($target.$name));
            $this->get('mailer')->send($msg);  
            */

            $quittance = $this->generateFactureSecuriseFromQuittance($quittance);
            //dump($quittance);die;

            return $this->redirectToRoute('quittance_show', array('id' => $quittance->getId()));
        }

        return $this->render('quittance/new.html.twig', array(
            'quittance' => $quittance,
            'form' => $form->createView(),
        ));
    }

    /**
     * Creates a new quittance entity.
     *
     * @Route("/facture/{id}/new", name="quittance_new_from_facture")
     * @Method({"GET", "POST"})
     */
    public function newFromFactureeAction(FactureSpontane $factureSpontane, Request $request)
    {
       // dump($factureSpontane);die;
        if ($this->getUser() && !empty($this->getUser()->getRole()))
        {
            $quittance = new Quittance();

            $quittance->setMontant($factureSpontane->getMontantTotalTtc());
            $quittance->setFactureSpontane($factureSpontane);
            $quittance->setSender($this->getUser());

            $form = $this->createForm('AMLA\SqrBundle\Form\QuittanceFromFactureType', $quittance);
            $form->handleRequest($request);

            //update quittance object with facture values as initial values for quittance
            if ($form->isSubmitted() && $form->isValid())
            {
                $em = $this->getDoctrine()->getManager();
                if ($quittance->getMontant() <= $factureSpontane->getResteAPayer() && $quittance->getMontant() != 0)
                {
                    // mettre à jour le montant de la facture à payer
                    $factureSpontane->setResteAPayer($factureSpontane->getResteAPayer() - $quittance->getMontant());

                    if($factureSpontane->getResteAPayer()==0)
                    {
                        $factureSpontane->setStatut(1);
                    }

                    $cle = $this->getParameter('api_key');
                    $piece = 'Quittance';
                    $proprietaire = 'Emetteur: '.$this->getUser()->getFournisseurs()[0]->getRaisonSociale().' '.'Destinataire: '.$factureSpontane->getBeneficiaireNiu().'-'.$factureSpontane->getBeneficiaireSocialReason();

                    $post = array(
                        'cle' => $cle,
                        'pieceqr'=> $piece, 
                        'proprietaire' => $proprietaire, 
                        'montant' => $quittance->getMontant(), 
                    );

                    $container = $this->container;
                    $api = new SqrApi($container);
                    $res = $api->callAPI($post);
                    
                    if($res[0])
                    {

                        $qr = $res[0]->qr;
                        $num = $res[0]->niu; 

                        $newname = 'Quittance_securise'.date('YmdHis',time()).mt_rand(0,1000).'.png';
                        //$checkqr = new CheckQr();
                        $checkqr = $api->generateQr($qr,$num,$newname);
                        $checkqr->setChemin($newname);
                        $quittance->setTransactionNumber($checkqr); 
                       
                        //Génération du Bordereau avec MPDF
                        $target = __DIR__.'/../../../../web/generated/FacturesSecurise/';
                        
                        $name = $num.'.pdf';
                       
                        $quittance->setPdf('generated/FacturesSecurise/'.$name);
                        $factureSpontaneArticles = $em->getRepository('AMLASqrBundle:FactureSpontaneArticle')->findBy(['factureSpontane'=>$factureSpontane]);
                         $pdf = $this->renderView('print/facture_instantane.html.twig', array(
                            'factureSpontane' =>$factureSpontane,
                            'factureSpontaneArticles' => $factureSpontaneArticles,                
                            'imageqr'=> $factureSpontane->getQrCode()->getChemin(),
                            'base_dir' => $this->get('kernel')->getRootDir().'/../web'.$request->getBasePath(),
                        ));
                         
                        try{
                            $mpdf = new \Mpdf\Mpdf();
                            $mpdf->WriteHtml($pdf);
                            if (file_exists($target) != 1) {

                                mkdir($target,0777,true);
                                $mpdf->Output($target.$name, 'F');
                            }else{
                                $mpdf->Output($target.$name, 'F');
                            }

                        }catch(MpdfException $e){

                            $this->get('session')->getFlashBag()->add('danger', 'Erreur lors de la génération du document de la quittance');
                            die($e->getMessage());
                            
                        }


                        $em->persist($checkqr);
                        $em->persist($factureSpontane);
                        $em->persist($quittance);
                        $em->flush(); 

                        return $this->redirectToRoute('quittance_show', array('id' => $quittance->getId()));

                    }else
                    {
                        $this->get('session')->getFlashBag()->add('danger', "Erreur lors de l'enregistrement de la quittance. SQR est indisponible !!!");
                    }
                }else
                {
                    $this->get('session')->getFlashBag()->add('danger', "Le montant de la quittance n'est pas correct ");
                }                               
               
            }

            return $this->render('quittance/new_from_facture.html.twig', array(
                'factureSpontane' => $factureSpontane,
                'quittance' => $quittance,
                'form' => $form->createView(),
            ));

        }else
        {
            $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
            return $this->redirectToRoute('dashboard_index');
        }
        
    }



    /**
     * Creates a new quittance entity.
     *
     * @Route("/new", name="quittance_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $quittance = new Quittance();
        $form = $this->createForm('AMLA\SqrBundle\Form\QuittanceType', $quittance);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($quittance);
            $em->flush();

            return $this->redirectToRoute('quittance_show', array('id' => $quittance->getId()));
        }

        return $this->render('quittance/new.html.twig', array(
            'quittance' => $quittance,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a quittance entity.
     *
     * @Route("/{id}", name="quittance_show")
     * @Method("GET")
     */
    public function showAction(Quittance $quittance)
    {
        $deleteForm = $this->createDeleteForm($quittance);

        return $this->render('quittance/show.html.twig', array(
            'quittance' => $quittance,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing quittance entity.
     *
     * @Route("/{id}/edit", name="quittance_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Quittance $quittance)
    {
        $deleteForm = $this->createDeleteForm($quittance);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\QuittanceType', $quittance);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('quittance_edit', array('id' => $quittance->getId()));
        }

        return $this->render('quittance/edit.html.twig', array(
            'quittance' => $quittance,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a quittance entity.
     *
     * @Route("/{id}", name="quittance_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Quittance $quittance)
    {
        $form = $this->createDeleteForm($quittance);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($quittance);
            $em->flush();
        }

        return $this->redirectToRoute('quittance_index');
    }

    /**
     * Creates a form to delete a quittance entity.
     *
     * @param Quittance $quittance The quittance entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Quittance $quittance)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('quittance_delete', array('id' => $quittance->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }

    private function generateFactureSecuriseFromQuittance (Quittance $quittance)
    {

        $em = $this->getDoctrine()->getManager();
        $factureSecurise = new FactureSpontane();

        $factureSecurise->setAttn($quittance->getReceiverSocialReason());

        $factureSecurise->setBeneficiaireNiu($quittance->getSender());
        $factureSecurise->setAccount($quittance->getSender());
        $factureSecurise->setBeneficiaireNiu($quittance->getReceiverNiu());
        $factureSecurise->setBeneficiaireEmail($quittance->getReceiverEmail());
        $factureSecurise->setBeneficiaireSocialReason($quittance->getReceiverSocialReason());
        $factureSecurise->setBeneficiaireTelephone($quittance->getPhoneNumber());
        $factureSecurise->setEmetteurTelephone($quittance->getSender()->getTelephone());
        $factureSecurise->setObjet($quittance->getReason());
        $factureSecurise->setMontantTotalTtc($quittance->getMontant());
        $factureSecurise->setResteAPayer(0);
        $factureSecurise->setNetApayer($quittance->getMontant());
        $factureSecurise->setStatut(1);

        $quittance->setFactureSpontane($factureSecurise);

        $cle = $this->getParameter('api_key');
            $piece = 'Facture sécurisée';
            $proprietaire = 'Emetteur: '.$this->getUser()->getFournisseurs()[0]->getRaisonSociale().' '.'Destinataire: '.$quittance->getReceiverSocialReason().' '. $quittance->getReceiverNiu();

            $post = array(
                'cle' => $cle,
                'pieceqr'=> $piece, 
                'proprietaire' => $proprietaire, 
            );

            $container = $this->container;
            $api = new SqrApi($container);
            $res = $api->callAPI($post);
            
            if($res[0]){

                $qr = $res[0]->qr;
                $num = $res[0]->niu; 
            }
            
            $newname = 'FACTURE_securise_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
            //Génération du facture avec MPDF
            $name = 'FACTURE_securise_'.$num.'.pdf';
            $target = __DIR__.'/../../../../web/Production_documentaire/factures/';
            //$checkqr = new CheckQr();
            $checkqr = $api->generateQr($qr,$num,$newname);
            $checkqr->setChemin($newname);
            $factureSecurise->setQrCode($checkqr); 

            $factureSecurise->setPdf('Production_documentaire/factures/'.$name);
           
            $pdf = $this->renderView('api/bill.html.twig', array(
                // 'imageqr'=> $impotVerif->getQrCode()->getChemin(),
                //'impotVerif' => $impotVerif,   
                'imageqr'=> $factureSecurise->getQrCode()->getChemin(),
                'factureSpontane'=>$factureSecurise,
                'base_dir' => $this->get('kernel')->getRootDir() . '/../web',
            ));

            try{

                $mpdf = new \Mpdf\Mpdf();
                $mpdf->WriteHtml($pdf);
                if (file_exists($target) != 1)
                {
                    mkdir($target,0777,true);
                    $mpdf->Output($target.$name, 'F');
                }else
                {
                    $mpdf->Output($target.$name, 'F');
                }

            }catch(MpdfException $e)
            {
                $this->get('session')->getFlashBag()->add('danger', 'Erreur lors de l\'émission de la facture');
                die($e->getMessage());
            }

            $em->persist($checkqr);
            $em->persist($factureSecurise);
            $em->persist($quittance);
            $em->flush(); 

            $factureSpontaneArticles = $em->getRepository('AMLASqrBundle:FactureSpontaneArticle')->findBy(['factureSpontane'=>$factureSecurise]);
            //dump($factureSpontaneArticles);die;
            $msg = (new \Swift_Message('CHECKTATOO - Facture sécurisé'))
            ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
            ->setTo($factureSecurise->getBeneficiaireEmail())
            ->setBody(
                $this->renderView(
                    'emails/emissionFactureSecurise.html.twig',array(
                        'factureSpontane' =>$factureSecurise,
                        'factureSpontaneArticles' => $factureSpontaneArticles,
                    )
                ),
                'text/html'
            )
            ->attach(\Swift_Attachment::fromPath($target.$name));
            $this->get('mailer')->send($msg); 


        return $quittance;

    }
}
