<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\ProcesVerbal;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Procesverbal controller.
 *
 * @Route("procesverbal/{_locale}", defaults = {"_locale" = "fr"})
 */
class ProcesVerbalController extends Controller
{
    /**
     * Lists all procesVerbal entities.
     *
     * @Route("/", name="procesverbal_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $procesVerbals = $em->getRepository('AMLASqrBundle:ProcesVerbal')->findAll();

        return $this->render('procesverbal/index.html.twig', array(
            'procesVerbals' => $procesVerbals,
        ));
    }

    /**
     * Creates a new procesVerbal entity.
     *
     * @Route("/new", name="procesverbal_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $procesVerbal = new Procesverbal();
        $form = $this->createForm('AMLA\SqrBundle\Form\ProcesVerbalType', $procesVerbal);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($procesVerbal);
            $em->flush();

            return $this->redirectToRoute('procesverbal_show', array('id' => $procesVerbal->getId()));
        }

        return $this->render('procesverbal/new.html.twig', array(
            'procesVerbal' => $procesVerbal,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a procesVerbal entity.
     *
     * @Route("/{id}", name="procesverbal_show")
     * @Method("GET")
     */
    public function showAction(ProcesVerbal $procesVerbal)
    {
        $deleteForm = $this->createDeleteForm($procesVerbal);

        return $this->render('procesverbal/show.html.twig', array(
            'procesVerbal' => $procesVerbal,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing procesVerbal entity.
     *
     * @Route("/{id}/edit", name="procesverbal_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, ProcesVerbal $procesVerbal)
    {
        $deleteForm = $this->createDeleteForm($procesVerbal);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\ProcesVerbalType', $procesVerbal);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('procesverbal_edit', array('id' => $procesVerbal->getId()));
        }

        return $this->render('procesverbal/edit.html.twig', array(
            'procesVerbal' => $procesVerbal,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a procesVerbal entity.
     *
     * @Route("/{id}", name="procesverbal_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, ProcesVerbal $procesVerbal)
    {
        $form = $this->createDeleteForm($procesVerbal);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($procesVerbal);
            $em->flush();
        }

        return $this->redirectToRoute('procesverbal_index');
    }

    /**
     * Creates a form to delete a procesVerbal entity.
     *
     * @param ProcesVerbal $procesVerbal The procesVerbal entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(ProcesVerbal $procesVerbal)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('procesverbal_delete', array('id' => $procesVerbal->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
