<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Offre;
use AMLA\SqrBundle\Entity\Fournissseur;
use AMLA\SqrBundle\Entity\Preselection;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;

/**
 * Preselection controller.
 *
 * @Route("preselection/{_locale}", defaults = {"_locale" = "fr"})
 */
class PreselectionController extends Controller
{
    /**
     * Lists all preselection entities.
     *
     * @Route("/", name="preselection_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $preselections = $em->getRepository('AMLASqrBundle:Preselection')->findAll();

        return $this->render('preselection/index.html.twig', array(
            'preselections' => $preselections,
        ));
    }

     /**
     * Lists all preselection entities.
     *
     * @Route("/list/list", name="preselection_list")
     * @Method("GET")
     */
    public function listAction(Request $request)
    {
       
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);

        $preselectionnes = $em->getRepository('AMLASqrBundle:Preselection')->getPreselectionUser($fournisseur);
        
        $propositions = array();

        foreach ($preselectionnes as $preselectionne) {
            $propositions[] = (object)array(
                'propos' => $preselectionne,
                'valide' => $this->hasValidateAnr($preselectionne->getFournisseur())
            );
        }

        return $this->render('preselection/index.html.twig', array(
            'preselections' => $propositions,
        ));
    }

    /**
     * Lists all preselection entities.
     *
     * @Route("/list/offre", name="preselection_offre")
     * @Method("GET")
     */
    public function offreAction()
    {
        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);

        $offrePreselects = $em->getRepository('AMLASqrBundle:offre')->findBy(['fournisseur'=>$fournisseur]);

        return $this->render('offre/offrepresec.html.twig', array(
            'offres' => $offrePreselects,
        ));
    }

    

    /**
     * 
     * @Route("/select/select",name="preselection_select")
     * @Method({"GET","POST"})
     */
    public function selectAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $id = $request->get('id');
        $offreid = $request->get('offre');
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneById($id);
        $offre = $em->getRepository('AMLASqrBundle:Offre')->findOneById($offreid);
        $preselection = new Preselection();
        $preselection->setFournisseur($fournisseur);
        $preselection->setOffre($offre);
        $em->persist($preselection);
        $em->flush();

        $this->addFlash('info','Fournisseur slectionn avec succs!');
        $this->get('session')->getFlashBag()->add('success', 'Fournisseur slectionn avec succs!');
        //$this->get('session')->getFlashBag()->add('danger', 'Impossible de mettre cette entreprise en recouvrement car elle est dj mis en recouvrement');
        // Add notification in app and email
        return $this->redirectToRoute('dashboard_index');
    }

    /**
     * Creates a new preselection entity.
     *
     * @Route("/new", name="preselection_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $preselection = new Preselection();
        $form = $this->createForm('AMLA\SqrBundle\Form\PreselectionType', $preselection);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($preselection);
            $em->flush();

            return $this->redirectToRoute('preselection_show', array('id' => $preselection->getId()));
        }

        return $this->render('preselection/new.html.twig', array(
            'preselection' => $preselection,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a preselection entity.
     *
     * @Route("/{id}", name="preselection_show")
     * @Method("GET")
     */
    public function showAction(Preselection $preselection)
    {
        $deleteForm = $this->createDeleteForm($preselection);

        return $this->render('preselection/show.html.twig', array(
            'preselection' => $preselection,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing preselection entity.
     *
     * @Route("/{id}/edit", name="preselection_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Preselection $preselection)
    {
        $deleteForm = $this->createDeleteForm($preselection);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\PreselectionType', $preselection);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('preselection_edit', array('id' => $preselection->getId()));
        }

        return $this->render('preselection/edit.html.twig', array(
            'preselection' => $preselection,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a preselection entity.
     *
     * @Route("/{id}", name="preselection_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Preselection $preselection)
    {
        $form = $this->createDeleteForm($preselection);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($preselection);
            $em->flush();
        }

        return $this->redirectToRoute('preselection_index');
    }

    public function hasValidateAnr(Fournissseur $fournisseur){

        $em = $this->getDoctrine()->getManager();
        $anrs = $em->getRepository('AMLASqrBundle:Anr')->findBy(['fournisseur'=>$fournisseur]);

        $verif = false;
        $datejour = new \Datetime("now");

            foreach ($anrs as $anr) {
            
                if($anr->getDateFin() < $datejour){
                    $verif = false;
                }else{
                    $verif = true; 
                }

            }
        return $verif;
    }

    /**
     * Creates a form to delete a preselection entity.
     *
     * @param Preselection $preselection The preselection entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Preselection $preselection)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('preselection_delete', array('id' => $preselection->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
