<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\FactureSpontane;
use AMLA\SqrBundle\Entity\PlanifierPaiement; 
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;

/**
 * Planifierpaiement controller.
 *
 * @Route("planifierpaiement/{_locale}", defaults = {"_locale" = "fr"})
 */
class PlanifierPaiementController extends Controller
{
    /**
     * Lists all planifierPaiement entities.
     *
     * @Route("/", name="planifierpaiement_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $planifierPaiements = $em->getRepository('AMLASqrBundle:PlanifierPaiement')->findAll();

        return $this->render('planifierpaiement/index.html.twig', array(
            'planifierPaiements' => $planifierPaiements,
        ));
    }

    /**
     * Creates a new planifierPaiement entity.
     *
     * @Route("/{id}/new", name="planifierpaiement_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(FactureSpontane $factureSpontane, Request $request)
    {
        if ($this->getUser() && !empty($this->getUser()->getRole())) 
        {
            $planifierPaiement = new Planifierpaiement();
            $form = $this->createForm('AMLA\SqrBundle\Form\PlanifierPaiementType', $planifierPaiement);
            $form->handleRequest($request);

            if ($form->isSubmitted() && $form->isValid()) 
            {
                $em = $this->getDoctrine()->getManager();

                $planifierPaiement->setAccount($this->getUser());
                $planifierPaiement->setFactureSpontane($factureSpontane);
                $em->persist($planifierPaiement);
                $em->flush();

                return $this->redirectToRoute('planifierpaiement_show', array('id' => $planifierPaiement->getId()));
            }

            return $this->render('planifierpaiement/new.html.twig', array(
                'planifierPaiement' => $planifierPaiement,
                'form' => $form->createView(),
                'factureSpontane'=>$factureSpontane,
            ));

        }else
        {
            $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
            return $this->redirectToRoute('dashboard_index');
        }
    }

    /**
     * Finds and displays a planifierPaiement entity.
     *
     * @Route("/{id}", name="planifierpaiement_show")
     * @Method("GET")
     */
    public function showAction(PlanifierPaiement $planifierPaiement)
    {
        $deleteForm = $this->createDeleteForm($planifierPaiement);

        return $this->render('planifierpaiement/show.html.twig', array(
            'planifierPaiement' => $planifierPaiement,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing planifierPaiement entity.
     *
     * @Route("/{id}/edit", name="planifierpaiement_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, PlanifierPaiement $planifierPaiement)
    {
        $deleteForm = $this->createDeleteForm($planifierPaiement);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\PlanifierPaiementType', $planifierPaiement);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('planifierpaiement_edit', array('id' => $planifierPaiement->getId()));
        }

        return $this->render('planifierpaiement/edit.html.twig', array(
            'planifierPaiement' => $planifierPaiement,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a planifierPaiement entity.
     *
     * @Route("/{id}", name="planifierpaiement_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, PlanifierPaiement $planifierPaiement)
    {
        $form = $this->createDeleteForm($planifierPaiement);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($planifierPaiement);
            $em->flush();
        }

        return $this->redirectToRoute('planifierpaiement_index');
    }

    /**
     * Creates a form to delete a planifierPaiement entity.
     *
     * @param PlanifierPaiement $planifierPaiement The planifierPaiement entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(PlanifierPaiement $planifierPaiement)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('planifierpaiement_delete', array('id' => $planifierPaiement->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
