<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\PaiementValidation;
use AMLA\SqrBundle\Entity\Facture;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Paiementvalidation controller.
 *
 * @Route("paiementvalidation/{_locale}", defaults = {"_locale" = "fr"})
 */
class PaiementValidationController extends Controller
{
    /**
     * Lists all paiementValidation entities.
     *
     * @Route("/", name="paiementvalidation_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $paiementValidations = $em->getRepository('AMLASqrBundle:PaiementValidation')->findAll();

        return $this->render('paiementvalidation/index.html.twig', array(
            'paiementValidations' => $paiementValidations,
        ));
    }
    
    /**
     * Lists all paiementValidation entities.
     *
     * @Route("/recus", name="paiementvalidation_recus")
     * @Method("GET")
     */
    public function paiementsRecusAction()
    {
        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
        $paiementValidations = $em->getRepository('AMLASqrBundle:PaiementValidation')->getPaiementReceive($fournisseur);

        return $this->render('paiementvalidation/paiementsrecus.html.twig', array(
            'paiementValidations' => $paiementValidations,
        ));
    }
    
    /**
     * Lists all paiementValidation entities.
     *
     * @Route("/emis", name="paiementvalidation_emis") 
     * @Method("GET")
     */
    public function paiementsEmisAction()
    {
        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
        $paiementValidations = $em->getRepository('AMLASqrBundle:PaiementValidation')->getPaiementSent($fournisseur);

        return $this->render('paiementvalidation/paiementsemis.html.twig', array(
            'paiementValidations' => $paiementValidations,
        ));
    }

    /**
     * Lists all paiementValidation entities.
     *
     * @Route("/factures", name="paiementvalidation_liste_facture") 
     * @Method("GET")
     */
    public function paiementsListeFactureAction()
    {
        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
        //$factures = $em->getRepository('AMLASqrBundle:Facture')->findAll();
        $factures = $em->getRepository('AMLASqrBundle:Facture')->getFactureToValidatePay($fournisseur);

        return $this->render('paiementvalidation/factureattentepaiement.html.twig', array(
            'factures' => $factures,
        ));
    }

    /**
     * Creates a new paiementValidation entity.
     *
     * @Route("/{id}/rejeter", name="paiementvalidation_rejeter")
     * @Method({"GET", "POST"})
     */
    public function rejeterFactureAction(Request $request, Facture $facture)
    {
        $em = $this->getDoctrine()->getManager();
        $facture->setStatut(2);
        $em->persist($facture);
        $em->flush();
        
        $this->get('session')->getFlashBag()->add('info', 'Le paiement a été rejeté avec succès');

        return $this->redirectToRoute('paiementvalidation_liste_facture');
        //paiementvalidation_liste_facture
        //return $this->redirectToRoute('paiementvalidation_show', array('id' => $paiementValidation->getId()));
    }

    /**
     * Creates a new paiementValidation entity.
     *
     * @Route("/{id}/new", name="paiementvalidation_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request, Facture $facture)
    {
        
        //$form = $this->createForm('AMLA\SqrBundle\Form\PaiementValidationType', $paiementValidation);
        //$form->handleRequest($request);
        
        //calcule du montant

        //$facture->setMontant($montantFacture);
        //dump($facture);die;
        $bc= $facture->getReceptionTravaux()->getBonCommande();
        $bcRestePaye = $bc->getRestePaye();
        //$billAmount= $facture->getAmount();
        $billAmount= $facture->getMontant();
        $newBcAmount= $bcRestePaye+$billAmount; 
        
        if($newBcAmount <= $bc->getMontant())
        {
            $bc->setRestePaye($newBcAmount);
        }
        
        $facture->setStatut(1);

        $paiementValidation = new Paiementvalidation();
        $paiementValidation->setFacture($facture);

        $em = $this->getDoctrine()->getManager();
        $em->persist($facture);
        $em->persist($paiementValidation);
        $em->flush();
        
        $this->get('session')->getFlashBag()->add('info', 'Le paiement a été validé avec succès');

        return $this->redirectToRoute('paiementvalidation_liste_facture');
        /*return $this->render('paiementvalidation/new.html.twig', array(
            'paiementValidation' => $paiementValidation,
            'form' => $form->createView(),
        ));*/
    }

    /**
     * Finds and displays a paiementValidation entity.
     *
     * @Route("/{id}", name="paiementvalidation_show")
     * @Method("GET")
     */
    public function showAction(PaiementValidation $paiementValidation)
    {
        $deleteForm = $this->createDeleteForm($paiementValidation);

        return $this->render('paiementvalidation/show.html.twig', array(
            'paiementValidation' => $paiementValidation,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing paiementValidation entity.
     *
     * @Route("/{id}/edit", name="paiementvalidation_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, PaiementValidation $paiementValidation)
    {
        $deleteForm = $this->createDeleteForm($paiementValidation);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\PaiementValidationType', $paiementValidation);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) 
        {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('paiementvalidation_edit', array('id' => $paiementValidation->getId()));
        }

        return $this->render('paiementvalidation/edit.html.twig', array(
            'paiementValidation' => $paiementValidation,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a paiementValidation entity.
     *
     * @Route("/{id}", name="paiementvalidation_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, PaiementValidation $paiementValidation)
    {
        $form = $this->createDeleteForm($paiementValidation);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) 
        {
            $em = $this->getDoctrine()->getManager();
            $em->remove($paiementValidation);
            $em->flush();
        }

        return $this->redirectToRoute('paiementvalidation_index');
    }

    /**
     * Creates a form to delete a paiementValidation entity.
     *
     * @param PaiementValidation $paiementValidation The paiementValidation entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(PaiementValidation $paiementValidation)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('paiementvalidation_delete', array('id' => $paiementValidation->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
