<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\OrganismeFinancement;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * Organismefinancement controller.
 *
 * @Route("organismefinancement/{_locale}", defaults = {"_locale" = "fr"})
 */
class OrganismeFinancementController extends Controller
{
    /**
     * Lists all organismeFinancement entities.
     *
     * @Route("/", name="organismefinancement_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $organismeFinancements = $em->getRepository('AMLASqrBundle:OrganismeFinancement')->findAll();

        return $this->render('organismefinancement/index.html.twig', array(
            'organismeFinancements' => $organismeFinancements,
        ));
    }

    /**
     * Creates a new organismeFinancement entity.
     *
     * @Route("/new", name="organismefinancement_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $organismeFinancement = new Organismefinancement();
        $form = $this->createForm('AMLA\SqrBundle\Form\OrganismeFinancementType', $organismeFinancement);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($organismeFinancement);
            $em->flush();

            return $this->redirectToRoute('organismefinancement_show', array('id' => $organismeFinancement->getId()));
        }

        return $this->render('organismefinancement/new.html.twig', array(
            'organismeFinancement' => $organismeFinancement,
            'form' => $form->createView(),
        ));
    }


    /**
     * Get new organismefinancement from impot API entity.
     *
     * @Route("/new/from/impot", name="organismefinancement_new_from_impot")
     * @Method({"GET", "POST"})
     */
    public function newFromApiAction(Request $request)
    {
        
        $ret = 0;
        $url = $this->getParameter('api_organisme_financement');

        $ch = curl_init();
        $options = [
            CURLOPT_URL => $url,
            CURLOPT_POST => 0,
            //CURLOPT_POSTFIELDS => '',
            CURLOPT_HTTPHEADER => array('Content-Type: multipart/form-data'),
            CURLOPT_RETURNTRANSFER => true,
        ];
        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);
        $response = json_decode($response,true);
        curl_close($ch);

        //dump($response);die;
        
        $em = $this->getDoctrine()->getManager();
        foreach ($response as $reply) 
        {
            # code...
            $organismeFinancement = $em->getRepository('AMLASqrBundle:OrganismeFinancement')->findOneBy(['idorganisme'=>$reply['idorganisme'], 'sigle'=>$reply['sigle'], 'libelle'=>$reply['libelle']]);
            if (!$organismeFinancement) 
            {
                # code...
                $organismeFinancement = new Organismefinancement();
                $organismeFinancement->setSigle($reply['sigle']);
                $organismeFinancement->setIdorganisme($reply['idorganisme']);
                $organismeFinancement->setLibelle($reply['libelle']);

                $em->persist($organismeFinancement);
                $ret = 1;                
            }
        }
        $em->flush();
        //dump($response);die;
        
        $ret = new JsonResponse($ret);
        return $ret;
    }

    /**
     * Finds and displays a organismeFinancement entity.
     *
     * @Route("/{id}", name="organismefinancement_show")
     * @Method("GET")
     */
    public function showAction(OrganismeFinancement $organismeFinancement)
    {
        $deleteForm = $this->createDeleteForm($organismeFinancement);

        return $this->render('organismefinancement/show.html.twig', array(
            'organismeFinancement' => $organismeFinancement,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing organismeFinancement entity.
     *
     * @Route("/{id}/edit", name="organismefinancement_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, OrganismeFinancement $organismeFinancement)
    {
        $deleteForm = $this->createDeleteForm($organismeFinancement);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\OrganismeFinancementType', $organismeFinancement);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('organismefinancement_edit', array('id' => $organismeFinancement->getId()));
        }

        return $this->render('organismefinancement/edit.html.twig', array(
            'organismeFinancement' => $organismeFinancement,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a organismeFinancement entity.
     *
     * @Route("/{id}", name="organismefinancement_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, OrganismeFinancement $organismeFinancement)
    {
        $form = $this->createDeleteForm($organismeFinancement);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($organismeFinancement);
            $em->flush();
        }

        return $this->redirectToRoute('organismefinancement_index');
    }

    /**
     * Creates a form to delete a organismeFinancement entity.
     *
     * @param OrganismeFinancement $organismeFinancement The organismeFinancement entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(OrganismeFinancement $organismeFinancement)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('organismefinancement_delete', array('id' => $organismeFinancement->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
