<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\OperateurConformiteCategoryElement;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * Operateurconformitecategoryelement controller.
 *
 * @Route("operateurconformitecategoryelement/{_locale}", defaults = {"_locale" = "fr"})
 */
class OperateurConformiteCategoryElementController extends Controller
{
    /**
     * Lists all operateurConformiteCategoryElement entities.
     *
     * @Route("/", name="operateurconformitecategoryelement_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $operateurConformiteCategoryElements = $em->getRepository('AMLASqrBundle:OperateurConformiteCategoryElement')->findAll();

        return $this->render('operateurconformitecategoryelement/index.html.twig', array(
            'operateurConformiteCategoryElements' => $operateurConformiteCategoryElements,
        ));
    }

    /**
     * Lists all operateurConformiteCategoryElement entities.
     *
     * @Route("/for/conformite/form", name="operateurconformitecategoryelement_index_category")
     * @Method("GET")
     */
    public function indexFromCategoryAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $categoryFormId = $request->get('categoryFormId');
        $cat =  $em->getRepository('AMLASqrBundle:OperateurConformiteCategory')->findBy(['id'=>$categoryFormId]);
        $opElements = $em->getRepository('AMLASqrBundle:OperateurConformiteCategoryElement')->findBy(['operateurConformiteCategory'=>$cat]);
        $tabRet=array();

        foreach($opElements as $opElement){
            $tabRet[] = [
                'id'=>$opElement->getId(),
                'name'=>$opElement->getName(),
            ];
        }

        $response = new JsonResponse($tabRet);
        return $response;


    }

    /**
     * Creates a new operateurConformiteCategoryElement entity.
     *
     * @Route("/new", name="operateurconformitecategoryelement_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $operateurConformiteCategoryElement = new Operateurconformitecategoryelement();
        $form = $this->createForm('AMLA\SqrBundle\Form\OperateurConformiteCategoryElementType', $operateurConformiteCategoryElement);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($operateurConformiteCategoryElement);
            $em->flush();

            return $this->redirectToRoute('operateurconformitecategoryelement_show', array('id' => $operateurConformiteCategoryElement->getId()));
        }

        return $this->render('operateurconformitecategoryelement/new.html.twig', array(
            'operateurConformiteCategoryElement' => $operateurConformiteCategoryElement,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a operateurConformiteCategoryElement entity.
     *
     * @Route("/{id}", name="operateurconformitecategoryelement_show")
     * @Method("GET")
     */
    public function showAction(OperateurConformiteCategoryElement $operateurConformiteCategoryElement)
    {
        $deleteForm = $this->createDeleteForm($operateurConformiteCategoryElement);

        return $this->render('operateurconformitecategoryelement/show.html.twig', array(
            'operateurConformiteCategoryElement' => $operateurConformiteCategoryElement,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing operateurConformiteCategoryElement entity.
     *
     * @Route("/{id}/edit", name="operateurconformitecategoryelement_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, OperateurConformiteCategoryElement $operateurConformiteCategoryElement)
    {
        $deleteForm = $this->createDeleteForm($operateurConformiteCategoryElement);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\OperateurConformiteCategoryElementType', $operateurConformiteCategoryElement);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('operateurconformitecategoryelement_index');
            //return $this->redirectToRoute('operateurconformitecategoryelement_edit', array('id' => $operateurConformiteCategoryElement->getId()));
        }

        return $this->render('operateurconformitecategoryelement/edit.html.twig', array(
            'operateurConformiteCategoryElement' => $operateurConformiteCategoryElement,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a operateurConformiteCategoryElement entity.
     *
     * @Route("/{id}", name="operateurconformitecategoryelement_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, OperateurConformiteCategoryElement $operateurConformiteCategoryElement)
    {
        $form = $this->createDeleteForm($operateurConformiteCategoryElement);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($operateurConformiteCategoryElement);
            $em->flush();
        }

        return $this->redirectToRoute('operateurconformitecategoryelement_index');
    }

    /**
     * Creates a form to delete a operateurConformiteCategoryElement entity.
     *
     * @param OperateurConformiteCategoryElement $operateurConformiteCategoryElement The operateurConformiteCategoryElement entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(OperateurConformiteCategoryElement $operateurConformiteCategoryElement)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('operateurconformitecategoryelement_delete', array('id' => $operateurConformiteCategoryElement->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
