<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\OperateurConformiteCategory;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Operateurconformitecategory controller.
 *
 * @Route("operateurconformitecategory/{_locale}", defaults = {"_locale" = "fr"})
 */
class OperateurConformiteCategoryController extends Controller
{
    /**
     * Lists all operateurConformiteCategory entities.
     *
     * @Route("/", name="operateurconformitecategory_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $operateurConformiteCategories = $em->getRepository('AMLASqrBundle:OperateurConformiteCategory')->findAll();

        return $this->render('operateurconformitecategory/index.html.twig', array(
            'operateurConformiteCategories' => $operateurConformiteCategories,
        ));
    }

    /**
     * Creates a new operateurConformiteCategory entity.
     *
     * @Route("/new", name="operateurconformitecategory_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $operateurConformiteCategory = new Operateurconformitecategory();
        $form = $this->createForm('AMLA\SqrBundle\Form\OperateurConformiteCategoryType', $operateurConformiteCategory);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($operateurConformiteCategory);
            $em->flush();

            return $this->redirectToRoute('operateurconformitecategory_show', array('id' => $operateurConformiteCategory->getId()));
        }

        return $this->render('operateurconformitecategory/new.html.twig', array(
            'operateurConformiteCategory' => $operateurConformiteCategory,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a operateurConformiteCategory entity.
     *
     * @Route("/{id}", name="operateurconformitecategory_show")
     * @Method("GET")
     */
    public function showAction(OperateurConformiteCategory $operateurConformiteCategory)
    {
        $deleteForm = $this->createDeleteForm($operateurConformiteCategory);

        return $this->render('operateurconformitecategory/show.html.twig', array(
            'operateurConformiteCategory' => $operateurConformiteCategory,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing operateurConformiteCategory entity.
     *
     * @Route("/{id}/edit", name="operateurconformitecategory_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, OperateurConformiteCategory $operateurConformiteCategory)
    {
        $deleteForm = $this->createDeleteForm($operateurConformiteCategory);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\OperateurConformiteCategoryType', $operateurConformiteCategory);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('operateurconformitecategory_edit', array('id' => $operateurConformiteCategory->getId()));
        }

        return $this->render('operateurconformitecategory/edit.html.twig', array(
            'operateurConformiteCategory' => $operateurConformiteCategory,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a operateurConformiteCategory entity.
     *
     * @Route("/{id}", name="operateurconformitecategory_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, OperateurConformiteCategory $operateurConformiteCategory)
    {
        $form = $this->createDeleteForm($operateurConformiteCategory);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($operateurConformiteCategory);
            $em->flush();
        }

        return $this->redirectToRoute('operateurconformitecategory_index');
    }

    /**
     * Creates a form to delete a operateurConformiteCategory entity.
     *
     * @param OperateurConformiteCategory $operateurConformiteCategory The operateurConformiteCategory entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(OperateurConformiteCategory $operateurConformiteCategory)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('operateurconformitecategory_delete', array('id' => $operateurConformiteCategory->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
