<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\OffreFournisseur;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Offrefournisseur controller.
 *
 * @Route("offrefournisseur/{_locale}", defaults = {"_locale" = "fr"})
 */
class OffreFournisseurController extends Controller
{
    /**
     * Lists all offreFournisseur entities.
     *
     * @Route("/", name="offrefournisseur_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $offreFournisseurs = $em->getRepository('AMLASqrBundle:OffreFournisseur')->findAll();

        return $this->render('offrefournisseur/index.html.twig', array(
            'offreFournisseurs' => $offreFournisseurs,
        ));
    }


    /**
     * Lists all offre entities.
     *
     * @Route("/mine", name="offrefournisseur_mine")
     * @Method("GET")
     */
    public function mineAction()
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);

        $ofournisseurs = $em->getRepository('AMLASqrBundle:OffreFournisseur')->findBy(['fournisseur'=>$fournisseur->getId()]);
        $offres = array();
        foreach ($ofournisseurs as $ofournisseur) {
            if ($ofournisseur->getOffre() != NULL) {
 
                $offres[] = $ofournisseur->getOffre();
            }
            
        }

        return $this->render('offrefournisseur/index.html.twig', array(
            'offres' => $offres,
        ));
    }

    /**
     * Creates a new offreFournisseur entity.
     *
     * @Route("/new", name="offrefournisseur_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $offreFournisseur = new Offrefournisseur();
        $form = $this->createForm('AMLA\SqrBundle\Form\OffreFournisseurType', $offreFournisseur);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($offreFournisseur);
            $em->flush();

            return $this->redirectToRoute('offrefournisseur_show', array('id' => $offreFournisseur->getId()));
        }

        return $this->render('offrefournisseur/new.html.twig', array(
            'offreFournisseur' => $offreFournisseur,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a offreFournisseur entity.
     *
     * @Route("/{id}", name="offrefournisseur_show")
     * @Method("GET")
     */
    public function showAction(OffreFournisseur $offreFournisseur)
    {
        $deleteForm = $this->createDeleteForm($offreFournisseur);

        return $this->render('offrefournisseur/show.html.twig', array(
            'offreFournisseur' => $offreFournisseur,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing offreFournisseur entity.
     *
     * @Route("/{id}/edit", name="offrefournisseur_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, OffreFournisseur $offreFournisseur)
    {
        $deleteForm = $this->createDeleteForm($offreFournisseur);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\OffreFournisseurType', $offreFournisseur);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('offrefournisseur_edit', array('id' => $offreFournisseur->getId()));
        }

        return $this->render('offrefournisseur/edit.html.twig', array(
            'offreFournisseur' => $offreFournisseur,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a offreFournisseur entity.
     *
     * @Route("/{id}", name="offrefournisseur_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, OffreFournisseur $offreFournisseur)
    {
        $form = $this->createDeleteForm($offreFournisseur);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($offreFournisseur);
            $em->flush();
        }

        return $this->redirectToRoute('offrefournisseur_index');
    }

    /**
     * Creates a form to delete a offreFournisseur entity.
     *
     * @param OffreFournisseur $offreFournisseur The offreFournisseur entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(OffreFournisseur $offreFournisseur)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('offrefournisseur_delete', array('id' => $offreFournisseur->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
