<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Notification;
use AMLA\SqrBundle\Entity\Offre;
use AMLA\SqrBundle\Entity\Document;
use AMLA\SqrBundle\Entity\OffreFournisseur;
use AMLA\SqrBundle\Entity\SoummissionOffre;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;

/**
 * Offre controller.
 *
 * @Route("appeloffre/{_locale}", defaults = {"_locale" = "fr"})
 */
class OffreController extends Controller
{
    /**
     * Lists all offre entities.
     *
     * @Route("/", name="offre_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $offres = $em->getRepository('AMLASqrBundle:Offre')->findAll();

        return $this->render('offre/index.html.twig', array(
            'offres' => $offres,
        ));
    }

    /**
     * Lists all offre entities.
     *
     * @Route("/mine", name="offre_mine")
     * @Method("GET")
     */
    public function mineAction()
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);

        $offres = $em->getRepository('AMLASqrBundle:Offre')->findBy(['fournisseur'=>$fournisseur->getId()]);

        return $this->render('offre/index.html.twig', array(
            'offres' => $offres,
        ));
    }


    /**
     * Lists all offre entities.
     *
     * @Route("/market/place", name="offre_market_place")
     * @Method("GET")
     */
    public function marketPlaceAction() 
    {
        $em = $this->getDoctrine()->getManager();
        /*$user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
        */
        $offres = $em->getRepository('AMLASqrBundle:Offre')->findBy(array('restreint'=>0));

        return $this->render('offre/marketplace.html.twig', array(
            'offres' => $offres,
        ));
    }

    /**
     * Creates a new offre entity.
     *
     * @Route("/new", name="offre_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        
        $offre = new Offre();
        $form = $this->createForm('AMLA\SqrBundle\Form\OffreType', $offre,['user' => $this->getUser()]);
        $form->handleRequest($request);
        $em = $this->getDoctrine()->getManager();

        if ($form->isSubmitted())
        {
            //dump($request);die;
            if(isset($request->get('amla_sqrbundle_offre')['fournisseur']))
            {
                
                $fournseurs = $request->get('amla_sqrbundle_offre')['fournisseur'];
                $fournisseurs = array();
                foreach($fournseurs as $fournseur)
                {

                    $fournisseurs[] = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneById($fournseur);
                }
            }
            $file = $request->files->get("amla_sqrbundle_offre")["cahierCharge"];
            $doc = new Document();
            $path = sha1(uniqid(mt_rand(), true)).'.'.$file->guessExtension();
            $doc->setPath($path);
            $doc->setSize($file->getClientSize());
            $doc->setName(date('YmdHis',time()).mt_rand(0,10000).'.'.$file->guessExtension());
            $doc->setThumb(date('YmdHis',time()).mt_rand(0,10000).'.'.$file->guessExtension());
            $file->move($doc->getUploadRootDir(), $path);
            $offre->addCahierCharge($doc);
            $doc->setOffre($offre);
            $em->persist($doc);

             //Si c'est national
             if (isset($request->get("amla_sqrbundle_offre")['categorieB']))
             {

                $categorie = $em->getRepository('AMLASqrBundle:Categorie')->findOneById(1);
                $offre->setCategorie($categorie);
                //Si c'est restreint
                if ($request->get("type") == 'restreint')
                {

                    //fournisseurs choisi pour la publication de l'offre.
                    $user = $this->getUser();
                    $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
                    $offre->setFournisseur($fournisseur);
                    $offre->setRestreint(1);
                    $commune = $fournisseur->getCommune();
                    $ville = $commune->getVille();
                    $paysF = $ville->getPays();
                    $pays = $paysF->getAlpha3();
                    if ($fournisseurs != NULL)
                    {
                        foreach ($fournisseurs as $fourn)
                        {
                            $offreFournisseur = new OffreFournisseur();
                            $offreFournisseur->setOffre($offre);
                            $offreFournisseur->setFournisseur($fourn);
                            $em->persist($offreFournisseur);
                        }
                    }else
                    {
                        $user = $this->getUser();
                        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
                        $offre->setFournisseur($fournisseur);
                        $fmoas = $em->getRepository('AMLASqrBundle:FournisseurMoa')->getFournisseurPays($fournisseur, $pays);
                        $fournissseurs = array();
                        foreach ($fmoas as $fmoa) 
                        {
                            $offreFournisseur = new OffreFournisseur();
                            $offreFournisseur->setOffre($offre);
                            $offreFournisseur->setFournisseur($fmoa->getFournisseur());
                            $em->persist($offreFournisseur);
                        }
                    }

                } elseif($request->get("type") == 'ouvert')
                {
                    $user = $this->getUser();
                    $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
                    $offre->setFournisseur($fournisseur);
                    $offre->setRestreint(0);
                    $fmoas = $em->getRepository('AMLASqrBundle:FournisseurMoa')->getFournisseurPays($fournisseur, $pays);
                    $fournissseurs = array();
                    foreach ($fmoas as $fmoa)
                    {
                        $offreFournisseur = new OffreFournisseur();
                        $offreFournisseur->setOffre($offre);
                        $offreFournisseur->setFournisseur($fmoa->getFournisseur());
                        $em->persist($offreFournisseur);
                    }
                }else
                {
                    $user = $this->getUser();
                    $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
                    $offre->setFournisseur($fournisseur);
                    $offre->setRestreint(2);
                    $commune = $fournisseur->getCommune();
                    $ville = $commune->getVille();
                    $paysF = $ville->getPays();
                    $pays = $paysF->getAlpha3();
                    if ($fournisseurs != NULL)
                    {
                        foreach ($fournisseurs as $fourn) 
                        {
                            $offreFournisseur = new OffreFournisseur();
                            $offreFournisseur->setOffre($offre);
                            $offreFournisseur->setFournisseur($fourn);
                            $em->persist($offreFournisseur);
                        }
                    }else
                    {
                        $user = $this->getUser();
                        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
                        $offre->setFournisseur($fournisseur);
                        $offre->setRestreint(2);
                        $fmoas = $em->getRepository('AMLASqrBundle:FournisseurMoa')->getFournisseurPays($fournisseur, $pays);
                        $fournissseurs = array();
                        foreach ($fmoas as $fmoa) 
                        {
                            $offreFournisseur = new OffreFournisseur();
                            $offreFournisseur->setOffre($offre);
                            $offreFournisseur->setFournisseur($fmoa->getFournisseur());
                            $em->persist($offreFournisseur);
                        }
                    }
                }
            } else /*Sinon*/
            {
                if ($request->get("type") == 'restreint') 
                {
                    $categorie = $em->getRepository('AMLASqrBundle:Categorie')->findOneById(2);
                    $offre->setCategorie($categorie);
                    $user = $this->getUser();
                    $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
                    $offre->setFournisseur($fournisseur);
                    $offre->setRestreint(1);
                    $fmoas = $em->getRepository('AMLASqrBundle:FournisseurMoa')->findBy(['moa'=>$fournisseur]);
                    foreach ($fmoas as $fmoa) 
                    {
                        $offreFournisseur = new OffreFournisseur();
                        $offreFournisseur->setOffre($offre);
                        $offreFournisseur->setFournisseur($fmoa->getFournisseur());
                        $em->persist($offreFournisseur);
                    }
                }
                elseif ($request->get("type") == 'ouvert') 
                {
                    $categorie = $em->getRepository('AMLASqrBundle:Categorie')->findOneById(2);
                    $offre->setCategorie($categorie);
                    $user = $this->getUser();
                    $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
                    $offre->setFournisseur($fournisseur);
                    $offre->setRestreint(0);
                    $fmoas = $em->getRepository('AMLASqrBundle:FournisseurMoa')->findBy(['moa'=>$fournisseur]);
                    foreach ($fmoas as $fmoa) 
                    {
                        $offreFournisseur = new OffreFournisseur();
                        $offreFournisseur->setOffre($offre);
                        $offreFournisseur->setFournisseur($fmoa->getFournisseur());
                        $em->persist($offreFournisseur);
                    }
                }else
                {
                    $categorie = $em->getRepository('AMLASqrBundle:Categorie')->findOneById(2);
                    $offre->setCategorie($categorie);
                    $user = $this->getUser();
                    $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
                    $offre->setFournisseur($fournisseur);
                    $offre->setRestreint(2);
                    $fmoas = $em->getRepository('AMLASqrBundle:FournisseurMoa')->findBy(['moa'=>$fournisseur]);
                    foreach ($fmoas as $fmoa) 
                    {
                        $offreFournisseur = new OffreFournisseur();
                        $offreFournisseur->setOffre($offre);
                        $offreFournisseur->setFournisseur($fmoa->getFournisseur());
                        $em->persist($offreFournisseur);
                    }
                }
            }

            /**************Add Notification */
            $notification = New Notification();
            $notification->setTitle('Nouvel appel d\'offre');
            $notification->setDescription('Un appel d\'offre a été émis.');
            $notification->setFournisseur($offre->getfournisseur()); 
            $em->persist($notification);
            /**************End Add Notification */

            $offre->setStatut(1);
            $em->persist($offre);
            $em->flush();
            $this->addFlash('success','Appel d\'offre émis avec succès');
            $offreFournisseurs = $em->getRepository('AMLASqrBundle:OffreFournisseur')->findBy(['offre' => $offre->getId()]);
            foreach ($offreFournisseurs as $offreFournisseur) 
            {
                //$emailsFournisseurs[] = $offreFournisseur->getFournisseur()->getAdresseEmail();
                $emailarray[$offreFournisseur->getFournisseur()->getRaisonSociale()]= $offreFournisseur->getFournisseur()->getAdresseEmail();
            }
            //$emailarray = implode(',',$emailarray);

                try 
                {
                    foreach ($emailarray as $email) 
                    {
                        $message = (new \Swift_Message('CHECKTATOO - Nouvel Appel d\'offre'))
                        ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
                        ->setTo($email)
                        ->setBody(
                            $this->renderView(
                                'emails/aonotification.html.twig', array(
                                'offre' => $offre, )
                            ),
                            'text/html'
                        );

                        $this->get('mailer')->send($message);
                    }

                }catch (\Exception $e)
                {
                    //dump($e);die;
                    $this->addFlash('danger','une erreur est survenue lors de l\'envoie du mail');
                    return $this->redirectToRoute('dashboard_index');
                }
            return $this->redirectToRoute('offre_new');
        }

        return $this->render('offre/new.html.twig', array(
            'offre' => $offre,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a offre entity.
     *
     * @Route("/{id}", name="offre_show")
     * @Method("GET")
     */
    public function showAction(Offre $offre)
    {
        $deleteForm = $this->createDeleteForm($offre);

        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);

        $soumissionoffre = $em->getRepository('AMLASqrBundle:SoummissionOffre')->findOneBy(['offre'=>$offre,'fournisseur'=>$fournisseur]);

        $offreFournisseur = $em->getRepository('AMLASqrBundle:OffreFournisseur')->findOneBy(['offre'=>$offre,'fournisseur'=>$fournisseur]);

        $fournissseurs = $em->getRepository('AMLASqrBundle:SoummissionOffre')->findBy(array('offre'=>$offre));
        $datejour = new \Datetime("now");
        $interest = false;
        $verif = false;
        $soumis = false;
        if($offre->getFournisseur()->getId() != $fournisseur->getId())
        {
            //vérification de la validité de l'offre
            if($offre->getDateLimite() < $datejour)
            {
                $verif = false;
            }else
            {
                
                if ($offreFournisseur->getStatut() == 0 ) 
                {
                    //Si l'user n'a pas encore manifesté son interet
                    $interest = false;
                    $verif = true;
                }else
                {
                        $interest = true;
                    if($soumissionoffre == NULL)
                    {
                        //Si l'user a déja soumissioné
                        $soumis = false;
                        $verif = true;
                    }else
                    {
                        $soumis = true; 
                        $verif = true;
                    }
                }
            }
            //dump($fournissseurs);die;    
        }
        

        return $this->render('offre/show.html.twig', array(
            'offre' => $offre,
            'soumis' =>$soumis,
            'interest' => $interest,
            'verif'=>$verif,
            'fournissseurs' => $fournissseurs,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Finds and displays a offre entity.
     *
     * @Route("/{id}/download", name="offre_download")
     * @Method("GET")
     */
    public function downloadAction(Offre $offre)
    {
        $em = $this->getDoctrine()->getManager();
        $document = $em->getRepository('AMLASqrBundle:Document')->findOneBy(['offre'=>$offre->getId()]);

        if(file_exists($document->getPath()))
        {
            header('Content-type: application/'.pathinfo($document->getPath(), PATHINFO_EXTENSION));

            // It will be called downloaded.zip
            header('Content-Disposition: attachment; filename="cahierdescharges_'.$offre->getReference().'.'.pathinfo($document->getPath(), PATHINFO_EXTENSION));

            // The PDF source is in original.zip
            readfile($document->getPath());

            $this->addFlash('info','Vous venez de télécharger le cahier de charge de l\'offre '.$offre->getReference());
            
        }else
        {
            $this->addFlash('danger','Impossible de télécharger car le cahier des charges est inexistant!!!');
        }
        
        return $this->redirectToRoute('dashboard_index');
    }



    /**
     * Manifester intérêt
     * @Route("/{id}/interest",name="offre_interest")
     * @Method({"GET","POST"})
     */
    public function interestAction(Request $request, Offre $offre)
    {
    
        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);

        $offreF = $em->getRepository('AMLASqrBundle:OffreFournisseur')->findOneBy(['fournisseur'=>$fournisseur->getId(),'offre'=>$offre->getId()]);

        if($offreF != NULL && $fournisseur != $offre->getFournisseur()){

            $offreF->setStatut(1);
            $em->persist($offreF);
            $em->flush();
            $this->addFlash('info','Votre intérêt pour cet appel d\'offre a bien été pris en compte');

            try {
                $message = (new \Swift_Message('CHECKTATOO - Manifestation d\'intérêt'))
                ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
                ->setTo($offre->getFournisseur()->getAdresseEmail())
                ->setBody(
                    $this->renderView(
                        'emails/interest.html.twig', array(
                        'offre' => $offre, 
                        'sender' =>$fournisseur,)
                    ),
                    'text/html'
                );

                $this->get('mailer')->send($message);

            } catch (\Exception $e) {

                $this->addFlash('danger','une erreur est survenue lors de l\'envoie du mail');
                return $this->redirectToRoute('dashboard_index');

            }
            return $this->redirectToRoute('dashboard_index');

        }elseif ($fournisseur == $offre->getFournisseur()) {

            $this->addFlash('danger','Vous ne pouvez pas manifester un intérêt pour votre propre offre');
            return $this->redirectToRoute('dashboard_index');

        }elseif ($offreF != NULL) {

           $this->addFlash('danger','une erreur c\'est produite cet appel d\'offre ne vous était pas destiné !!!');
           return $this->redirectToRoute('dashboard_index');

        }
        
        return $this->redirectToRoute('offre_show', array('id' => $offre->getId()));
    }

    /**
     * 
     * @Route("/valid/valid",name="offre_valid")
     * @Method({"GET","POST"})
     */
    public function validateAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $id = $request->get('id');
        $offreid = $request->get('offre');
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneById($id);
        $offre = $em->getRepository('AMLASqrBundle:Offre')->findOneById($offreid);
        //not yet finished
    }

    /**
     * Displays a form to edit an existing offre entity.
     *
     * @Route("/{id}/edit", name="offre_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Offre $offre)
    {
        $deleteForm = $this->createDeleteForm($offre);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\OffreType', $offre);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('offre_edit', array('id' => $offre->getId()));
        }

        return $this->render('offre/edit.html.twig', array(
            'offre' => $offre,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a offre entity.
     *
     * @Route("/{id}", name="offre_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Offre $offre)
    {
        $form = $this->createDeleteForm($offre);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($offre);
            $em->flush();
        }

        return $this->redirectToRoute('offre_index');
    }

    /**
     * Creates a form to delete a offre entity.
     *
     * @param Offre $offre The offre entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Offre $offre)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('offre_delete', array('id' => $offre->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
