<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Notification;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Notification controller.
 *
 * @Route("notification/{_locale}", defaults = {"_locale" = "fr"})
 */
class NotificationController extends Controller
{
    /**
     * Lists all notification entities.
     *
     * @Route("/", name="notification_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        //$notifications = $em->getRepository('AMLASqrBundle:Notification')->findAll();
        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
        $notifications = $em->getRepository('AMLASqrBundle:Notification')->getMyNotifications($fournisseur);
        
        //$notifications = $em->getRepository('AMLASqrBundle:Notification')->findBy(['fournisseur'=>$fournisseur],['id'=>'DESC']);
          

        return $this->render('notification/index.html.twig', array(
            'notifications' => $notifications,
        ));
    }

    

    /**
     * Lists all notification entities.
     *
     * @Route("/numberecu", name="notification_numberecu")
     * @Method("GET")
     */
    public function numberecuAction()
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();

        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);

       $notifications = count($em->getRepository('AMLASqrBundle:Notification')->findBy(['fournisseur'=>$fournisseur, 'isRead'=>0]));
        
        //$notifications = $em->getRepository('AMLASqrBundle:Notification')->findAll();
        //dump($notifications);die;

       return new Response($notifications);
    }

     /**
     * Finds and displays a Notification entity.
     *
     * @Route("/notif/infos", name="infos_notif")
     * @Method("GET")
     */
    public function infoNotif(Request $request)
    {
        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);

        $notifications = $em->getRepository('AMLASqrBundle:Notification')->findBy(['fournisseur'=>$fournisseur, 'isRead'=>0]);
           
        $rep = array();
        foreach ($notifications as $notification) 
        {            
            $rep[] = array(
                'id'=>$notification->getId(),
                'title'=>$notification->getTitle(),
                'description'=>$notification->getDescription(),
            );            
        }
        //dump($rep);die;
        //$this->get('session')->getFlashBag()->add('notice', 'Vous venez de Valider une commande');
        $rep = new JsonResponse($rep);

        return $rep;
        
    }

    /**
     * Creates a new notification entity.
     *
     * @Route("/new", name="notification_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $notification = new Notification();
        $form = $this->createForm('AMLA\SqrBundle\Form\NotificationType', $notification);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($notification);
            $em->flush();

            return $this->redirectToRoute('notification_show', array('id' => $notification->getId()));
        }

        return $this->render('notification/new.html.twig', array(
            'notification' => $notification,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a notification entity.
     *
     * @Route("/{id}", name="notification_show")
     * @Method("GET")
     */
    public function showAction(Notification $notification)
    {
        $deleteForm = $this->createDeleteForm($notification);

        if($notification->getIsRead()==0)
        {
            $em = $this->getDoctrine()->getManager();
            $notification->setIsRead(1);
            $em->persist($notification);
            $em->flush();
        }            

        return $this->render('notification/show.html.twig', array(
            'notification' => $notification,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing notification entity.
     *
     * @Route("/{id}/edit", name="notification_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Notification $notification)
    {
        $deleteForm = $this->createDeleteForm($notification);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\NotificationType', $notification);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('notification_edit', array('id' => $notification->getId()));
        }

        return $this->render('notification/edit.html.twig', array(
            'notification' => $notification,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a notification entity.
     *
     * @Route("/{id}", name="notification_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Notification $notification)
    {
        $form = $this->createDeleteForm($notification);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($notification);
            $em->flush();
        }

        return $this->redirectToRoute('notification_index');
    }

    /**
     * Creates a form to delete a notification entity.
     *
     * @param Notification $notification The notification entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Notification $notification)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('notification_delete', array('id' => $notification->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
