<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\NoteAvoir;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Noteavoir controller.
 *
 * @Route("noteavoir/{_locale}", defaults = {"_locale" = "fr"})
 */
class NoteAvoirController extends Controller
{
    /**
     * Lists all noteAvoir entities.
     *
     * @Route("/", name="noteavoir_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $noteAvoirs = $em->getRepository('AMLASqrBundle:NoteAvoir')->findAll();

        return $this->render('noteavoir/index.html.twig', array(
            'noteAvoirs' => $noteAvoirs,
        ));
    }
    /**
     * Lists all noteAvoir entities.
     *
     * @Route("/mine", name="noteavoir_index_mine")
     * @Method("GET")
     */
    public function indexMineAction()
    {
        $em = $this->getDoctrine()->getManager();

        $noteAvoirs = $em->getRepository('AMLASqrBundle:NoteAvoir')->findAll();

        return $this->render('noteavoir/index.html.twig', array(
            'noteAvoirs' => $noteAvoirs,
        ));
    }

    /**
     * Creates a new noteAvoir entity.
     *
     * @Route("/new", name="noteavoir_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $noteAvoir = new Noteavoir();
        $form = $this->createForm('AMLA\SqrBundle\Form\NoteAvoirType', $noteAvoir);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($noteAvoir);
            $em->flush();

            return $this->redirectToRoute('noteavoir_show', array('id' => $noteAvoir->getId()));
        }

        return $this->render('noteavoir/new.html.twig', array(
            'noteAvoir' => $noteAvoir,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a noteAvoir entity.
     *
     * @Route("/{id}", name="noteavoir_show")
     * @Method("GET")
     */
    public function showAction(NoteAvoir $noteAvoir)
    {
        $deleteForm = $this->createDeleteForm($noteAvoir);

        return $this->render('noteavoir/show.html.twig', array(
            'noteAvoir' => $noteAvoir,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing noteAvoir entity.
     *
     * @Route("/{id}/edit", name="noteavoir_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, NoteAvoir $noteAvoir)
    {
        $deleteForm = $this->createDeleteForm($noteAvoir);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\NoteAvoirType', $noteAvoir);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('noteavoir_edit', array('id' => $noteAvoir->getId()));
        }

        return $this->render('noteavoir/edit.html.twig', array(
            'noteAvoir' => $noteAvoir,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a noteAvoir entity.
     *
     * @Route("/{id}", name="noteavoir_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, NoteAvoir $noteAvoir)
    {
        $form = $this->createDeleteForm($noteAvoir);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($noteAvoir);
            $em->flush();
        }

        return $this->redirectToRoute('noteavoir_index');
    }

    /**
     * Creates a form to delete a noteAvoir entity.
     *
     * @param NoteAvoir $noteAvoir The noteAvoir entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(NoteAvoir $noteAvoir)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('noteavoir_delete', array('id' => $noteAvoir->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
