<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\MouvementAtd;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Mouvementatd controller.
 *
 * @Route("mouvementatd/{_locale}", defaults = {"_locale" = "fr"})
 */
class MouvementAtdController extends Controller
{
    /**
     * Lists all mouvementAtd entities.
     *
     * @Route("/", name="mouvementatd_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $mouvementAtds = $em->getRepository('AMLASqrBundle:MouvementAtd')->findAll();

        return $this->render('mouvementatd/index.html.twig', array(
            'mouvementAtds' => $mouvementAtds,
        ));
    }

    /**
     * Lists all mouvementAtd entities.
     *
     * @Route("/index/impot", name="mouvementatd_impot_index")
     * @Method("GET")
     */
    public function indexImpotAction()
    {
        $em = $this->getDoctrine()->getManager();

        $mouvementAtds = $em->getRepository('AMLASqrBundle:MouvementAtd')->findAll();

        return $this->render('mouvementatd/index_impot.html.twig', array(
            'mouvementAtds' => $mouvementAtds,
        ));
    }

    /**
     * Creates a new mouvementAtd entity.
     *
     * @Route("/new", name="mouvementatd_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $mouvementAtd = new Mouvementatd();
        $form = $this->createForm('AMLA\SqrBundle\Form\MouvementAtdType', $mouvementAtd);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($mouvementAtd);
            $em->flush();

            return $this->redirectToRoute('mouvementatd_show', array('id' => $mouvementAtd->getId()));
        }

        return $this->render('mouvementatd/new.html.twig', array(
            'mouvementAtd' => $mouvementAtd,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a mouvementAtd entity.
     *
     * @Route("/{id}", name="mouvementatd_show")
     * @Method("GET")
     */
    public function showAction(MouvementAtd $mouvementAtd)
    {
        $deleteForm = $this->createDeleteForm($mouvementAtd);

        return $this->render('mouvementatd/show.html.twig', array(
            'mouvementAtd' => $mouvementAtd,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing mouvementAtd entity.
     *
     * @Route("/{id}/edit", name="mouvementatd_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, MouvementAtd $mouvementAtd)
    {
        $deleteForm = $this->createDeleteForm($mouvementAtd);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\MouvementAtdType', $mouvementAtd);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('mouvementatd_edit', array('id' => $mouvementAtd->getId()));
        }

        return $this->render('mouvementatd/edit.html.twig', array(
            'mouvementAtd' => $mouvementAtd,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a mouvementAtd entity.
     *
     * @Route("/{id}", name="mouvementatd_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, MouvementAtd $mouvementAtd)
    {
        $form = $this->createDeleteForm($mouvementAtd);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($mouvementAtd);
            $em->flush();
        }

        return $this->redirectToRoute('mouvementatd_index');
    }

    /**
     * Creates a form to delete a mouvementAtd entity.
     *
     * @param MouvementAtd $mouvementAtd The mouvementAtd entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(MouvementAtd $mouvementAtd)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('mouvementatd_delete', array('id' => $mouvementAtd->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
