<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Atd;
use AMLA\SqrBundle\Entity\Moratoire;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Moratoire controller.
 *
 * @Route("moratoire/{_locale}", defaults = {"_locale" = "fr"})
 */
class MoratoireController extends Controller
{
    /**
     * Lists all moratoire entities.
     *
     * @Route("/", name="moratoire_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $moratoires = $em->getRepository('AMLASqrBundle:Moratoire')->findAll();

        return $this->render('moratoire/index.html.twig', array(
            'moratoires' => $moratoires,
        ));
    }
    /**
     * Lists all moratoire entities.
     *
     * @Route("/accepte", name="moratoire_accepte_index")
     * @Method("GET")
     */
    public function accepteIndexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $moratoires = $em->getRepository('AMLASqrBundle:Moratoire')->findBy(['decision'=>1]);

        return $this->render('moratoire/accepte.html.twig', array(
            'moratoires' => $moratoires,
        ));
    }
    /**
     * Lists all moratoire entities.
     *
     * @Route("/en/attente", name="moratoire_en_attente_index")
     * @Method("GET")
     */
    public function enAttenteIndexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $moratoires = $em->getRepository('AMLASqrBundle:Moratoire')->findBy(['decision'=>0]);

        return $this->render('moratoire/en_attente.html.twig', array(
            'moratoires' => $moratoires,
        ));
    }
    /**
     * Lists all moratoire entities.
     *
     * @Route("/rejete", name="moratoire_rejete_index")
     * @Method("GET")
     */
    public function rejeteIndexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $moratoires = $em->getRepository('AMLASqrBundle:Moratoire')->findBy(['decision'=>0]);

        return $this->render('moratoire/rejete.html.twig', array(
            'moratoires' => $moratoires,
        ));
    }

    /**
     * Creates a new moratoire entity.
     *
     * @Route("/{id}/new", name="moratoire_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(ATD $atd, Request $request)
    {
        $moratoire = new Moratoire();
        $form = $this->createForm('AMLA\SqrBundle\Form\MoratoireType', $moratoire);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid())
        {
            $em = $this->getDoctrine()->getManager();

            $moratoireExist = $em->getRepository('AMLASqrBundle:Moratoire')->findOneBy(['atd'=>$atd, 'decision'=>0]);
            if(!$moratoireExist)
            {
                $moratoire->setAtd($atd);
                $moratoire->setAuteurDemandeur($this->getUser());
                $em->persist($moratoire);
                $em->flush();

                $this->get('session')->getFlashBag()->add('success', 'Moratoire enregistré et transmis avec succèss.');

                return $this->redirectToRoute('moratoire_show', array('id' => $moratoire->getId()));
            }else{
                $this->get('session')->getFlashBag()->add('danger', 'Impossible de transmettre ce moratoire car il existe déjà une demande de moratoire pour cet ATD');
            }

        }

        return $this->render('moratoire/new.html.twig', array(
            'moratoire' => $moratoire,
            'atd'=>$atd,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a moratoire entity.
     *
     * @Route("/{id}", name="moratoire_show")
     * @Method("GET")
     */
    public function showAction(Moratoire $moratoire)
    {
        $deleteForm = $this->createDeleteForm($moratoire);

        return $this->render('moratoire/show.html.twig', array(
            'moratoire' => $moratoire,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Finds and displays a moratoire entity.
     *
     * @Route("/{id}/decision/final", name="moratoire_decision_take")
     * @Method({"GET", "POST"})
     */
    public function decisionTakeAction(Moratoire $moratoire, Request $request)
    {
        $form = $this->createForm('AMLA\SqrBundle\Form\MoratoireDecisionType', $moratoire);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid())
        {
            $em = $this->getDoctrine()->getManager();

            $moratoire->setAuteurDecision($this->getUser());
            //$moratoire->setStatus(1);
            $moratoire->setDateDecision(new \Datetime());
            $em->persist($moratoire);
            $em->flush();

            $this->get('session')->getFlashBag()->add('success', 'Moratoire traité et transmis avec succèss.');
            return $this->redirectToRoute('moratoire_show', array('id' => $moratoire->getId()));

            $moratoireExist = $em->getRepository('AMLASqrBundle:Moratoire')->findOneBy(['atd'=>$atd, 'statut'=>1]);

        }

        return $this->render('moratoire/decision.html.twig', array(
            'moratoire' => $moratoire,
            'form' => $form->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing moratoire entity.
     *
     * @Route("/{id}/edit", name="moratoire_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Moratoire $moratoire)
    {
        $deleteForm = $this->createDeleteForm($moratoire);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\MoratoireType', $moratoire);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('moratoire_edit', array('id' => $moratoire->getId()));
        }

        return $this->render('moratoire/edit.html.twig', array(
            'moratoire' => $moratoire,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a moratoire entity.
     *
     * @Route("/{id}", name="moratoire_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Moratoire $moratoire)
    {
        $form = $this->createDeleteForm($moratoire);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($moratoire);
            $em->flush();
        }

        return $this->redirectToRoute('moratoire_index');
    }

    /**
     * Creates a form to delete a moratoire entity.
     *
     * @param Moratoire $moratoire The moratoire entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Moratoire $moratoire)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('moratoire_delete', array('id' => $moratoire->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
