<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Notification;
use AMLA\SqrBundle\Entity\Messagerie;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Messagerie controller.
 *
 * @Route("messagerie/{_locale}", defaults = {"_locale" = "fr"})
 */
class MessagerieController extends Controller
{
    /**
     * Lists all messagerie entities.
     *
     * @Route("/", name="messagerie_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $messageries = $em->getRepository('AMLASqrBundle:Messagerie')->findAll();

        $title='test';
        $desc='test';
        Notification :: newAction($title, $desc);


        return $this->render('messagerie/index.html.twig', array(
            'messageries' => $messageries,
        ));
    }

    /**
     * Lists all messagerie entities.
     *
     * @Route("/received/all", name="messagerie_received")
     * @Method("GET")
     */
    public function receivedAction()
    {
        $em = $this->getDoctrine()->getManager();

        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]); 
        
        $messageries = $em->getRepository('AMLASqrBundle:Messagerie')->findBy(array('fournisseurReceiver'=>$fournisseur));

        return $this->render('messagerie/receive.html.twig', array(
            'messageries' => $messageries,
        ));
    }

    /**
     * Lists all messagerie entities.
     *
     * @Route("/send/all", name="messagerie_sent")
     * @Method("GET")
     */
    public function sentAction()
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]); 
        
        $messageries = $em->getRepository('AMLASqrBundle:Messagerie')->findBy(array('fournisseurSend'=>$fournisseur));

        return $this->render('messagerie/send.html.twig', array(
            'messageries' => $messageries,
        ));
    }

    /**
     * Creates a new messagerie entity.
     *
     * @Route("/new", name="messagerie_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $messagerie = new Messagerie();
        $form = $this->createForm('AMLA\SqrBundle\Form\MessagerieType', $messagerie);
        $form->handleRequest($request);
        
        dump($request);die;
        if ($form->isSubmitted() && $form->isValid()) 
        {
            $em = $this->getDoctrine()->getManager();

            $em->persist($messagerie);
            $em->flush();
            $this->addFlash('info','Message envoyé avec succès');

            return $this->redirectToRoute('messagerie_show', array('id' => $messagerie->getId()));
        }

        return $this->render('messagerie/new.html.twig', array(
            'messagerie' => $messagerie,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a messagerie entity.
     *
     * @Route("/{id}", name="messagerie_show")
     * @Method("GET")
     */
    public function showAction(Messagerie $messagerie)
    {
        $deleteForm = $this->createDeleteForm($messagerie);
        
        return $this->render('messagerie/show.html.twig', array(
            'messagerie' => $messagerie,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing messagerie entity.
     *
     * @Route("/{id}/edit", name="messagerie_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Messagerie $messagerie)
    {
        $deleteForm = $this->createDeleteForm($messagerie);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\MessagerieType', $messagerie);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('messagerie_edit', array('id' => $messagerie->getId()));
        }

        return $this->render('messagerie/edit.html.twig', array(
            'messagerie' => $messagerie,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a messagerie entity.
     *
     * @Route("/{id}", name="messagerie_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Messagerie $messagerie)
    {
        $form = $this->createDeleteForm($messagerie);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($messagerie);
            $em->flush();
        }

        return $this->redirectToRoute('messagerie_index');
    }

    /**
     * Creates a form to delete a messagerie entity.
     *
     * @param Messagerie $messagerie The messagerie entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Messagerie $messagerie)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('messagerie_delete', array('id' => $messagerie->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
