<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\MaitreOuvrage;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * Maitreouvrage controller.
 *
 * @Route("maitreouvrage/{_locale}", defaults = {"_locale" = "fr"})
 */
class MaitreOuvrageController extends Controller
{
    /**
     * Lists all maitreOuvrage entities.
     *
     * @Route("/", name="maitreouvrage_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $maitreOuvrages = $em->getRepository('AMLASqrBundle:MaitreOuvrage')->findAll();

        return $this->render('maitreouvrage/index.html.twig', array(
            'maitreOuvrages' => $maitreOuvrages,
        ));
    }

    /**
     * Creates a new maitreOuvrage entity.
     *
     * @Route("/new", name="maitreouvrage_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $maitreOuvrage = new Maitreouvrage();
        $form = $this->createForm('AMLA\SqrBundle\Form\MaitreOuvrageType', $maitreOuvrage);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) 
        {
            $em = $this->getDoctrine()->getManager();
            $em->persist($maitreOuvrage);
            $em->flush();

            return $this->redirectToRoute('maitreouvrage_show', array('id' => $maitreOuvrage->getId()));
        }

        return $this->render('maitreouvrage/new.html.twig', array(
            'maitreOuvrage' => $maitreOuvrage,
            'form' => $form->createView(),
        ));
    }


    /**
     * Get new maitreouvrage from impot API entity.
     *
     * @Route("/new/from/impot", name="maitreouvrage_new_from_impot")
     * @Method({"GET", "POST"})
     */
    public function newFromApiAction(Request $request)
    {
        
        $ret = 0;
        $url = $this->getParameter('api_maitre_ouvrage');

        $ch = curl_init();
        $options = [
            CURLOPT_URL => $url,
            CURLOPT_POST => 0,
            //CURLOPT_POSTFIELDS => '',
            CURLOPT_HTTPHEADER => array('Content-Type: multipart/form-data'),
            CURLOPT_RETURNTRANSFER => true,
        ];
        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);
        $response = json_decode($response,true);
        curl_close($ch);

        //dump($response);die;
        
        $em = $this->getDoctrine()->getManager();
        foreach ($response as $reply) 
        {
            # code...
            $maitreOuvrage = $em->getRepository('AMLASqrBundle:MaitreOuvrage')->findOneBy(['idstructure'=>$reply['idstructure'], 'sigle'=>$reply['sigle'], 'libelle'=>$reply['libelle']]);
            if (!$maitreOuvrage) 
            {
                # code...
                $maitreOuvrage = new Maitreouvrage();
                $maitreOuvrage->setSigle($reply['sigle']);
                $maitreOuvrage->setIdstructure($reply['idstructure']);
                $maitreOuvrage->setLibelle($reply['libelle']);

                $em->persist($maitreOuvrage);
                $ret = 1;
                
            }
        }
        $em->flush();
        //dump($response);die;
        
        $ret = new JsonResponse($ret);
        return $ret;
    }

    /**
     * Finds and displays a maitreOuvrage entity.
     *
     * @Route("/{id}", name="maitreouvrage_show")
     * @Method("GET")
     */
    public function showAction(MaitreOuvrage $maitreOuvrage)
    {
        $deleteForm = $this->createDeleteForm($maitreOuvrage);

        return $this->render('maitreouvrage/show.html.twig', array(
            'maitreOuvrage' => $maitreOuvrage,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing maitreOuvrage entity.
     *
     * @Route("/{id}/edit", name="maitreouvrage_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, MaitreOuvrage $maitreOuvrage)
    {
        $deleteForm = $this->createDeleteForm($maitreOuvrage);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\MaitreOuvrageType', $maitreOuvrage);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('maitreouvrage_edit', array('id' => $maitreOuvrage->getId()));
        }

        return $this->render('maitreouvrage/edit.html.twig', array(
            'maitreOuvrage' => $maitreOuvrage,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a maitreOuvrage entity.
     *
     * @Route("/{id}", name="maitreouvrage_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, MaitreOuvrage $maitreOuvrage)
    {
        $form = $this->createDeleteForm($maitreOuvrage);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($maitreOuvrage);
            $em->flush();
        }

        return $this->redirectToRoute('maitreouvrage_index');
    }

    /**
     * Creates a form to delete a maitreOuvrage entity.
     *
     * @param MaitreOuvrage $maitreOuvrage The maitreOuvrage entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(MaitreOuvrage $maitreOuvrage)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('maitreouvrage_delete', array('id' => $maitreOuvrage->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
