<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\MTN;
use AMLA\SqrBundle\Entity\CheckQr;
use AMLA\SqrBundle\Entity\MouvementAtd;
use AMLA\SqrBundle\Entity\Atd;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use AMLA\SqrBundle\API\SqrApi as SqrApi;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Mtn controller.
 *
 * @Route("mtn/{_locale}", defaults = {"_locale" = "fr"})
 */
class MTNController extends Controller
{
    /**
     * Lists all mTN entities.
     *
     * @Route("/", name="mtn_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $mTNs = $em->getRepository('AMLASqrBundle:MTN')->findAll();

        return $this->render('mtn/index.html.twig', array(
            'mTNs' => $mTNs,
        ));
    }

    
    /**
     * Pay object.
     *
     * @Route("/pay/om", name="mtn_om_pay")
     * @Method({"GET", "POST"})
     */
    public function initiatePaymentAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();

        $cle =  $cle = $this->getParameter('api_key');
        $numero = $request->get('telephone');
        $amount = $request->get('amount');
        $atdId = $request->get('atdId');
        $payerMessage = 'Test';        
        $payeeNote = 'Test';
        $reply = 0;

        $atd = $em->getRepository('AMLASqrBundle:Atd')->findOneBy(['id'=>$atdId]);
        if($atd->getResteAPayer() >= $amount)
        {
            $cle = $this->getParameter('api_key');
            $piece = 'Cantonnement ATD';
            $proprietaire = $this->getUser()->getFournisseurs()[0]->getRaisonSociale();

            $post = array(
                'cle' => $cle,
                'pieceqr'=> $piece, 
                'proprietaire' => $proprietaire, 
                'montant' => $amount,
                'atd reference' => $atd->getQrCode()->getNumero(),
            );
            
            $flag = false;
            $time_start = microtime(true);
            // Attend pendant un moment
            //usleep(100);

            $container = $this->container;  
            while ($flag == false) 
            {
                $api = new SqrApi($container);
                $res = $api->callAPI($post);
                if ($res != null) 
                {
                    # code...
                    $flag=true;
                }else
                {
                    $time_end = microtime(true);
                    $time = $time_end - $time_start;
                    if ($time >= 10) 
                    {
                        # code...
                        throw new \ Exception("Error Processing Request", 1);                    
                    }
                }
            }
            
            if($res[0])
            {
                $qr = $res[0]->qr;
                $num = $res[0]->niu; 

                $newname = 'verification_terminal_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
                $mtn = new Mtn();
                $checkQr = new CheckQr();
                $checkQr = $api->generateQr($qr,$num,$newname);
                $checkQr->setChemin($newname);

                $mtn->setQrCode($checkQr);               
                $mtn->setAtd($atd);
                $mtn->setPhonenumber($numero);
                $mtn->setAmount($amount);

                $clientEId =$atd->getQrCode()->getNumero();
                //dump($factureSpontane->getQrCode()->getNumero());die;
                $client = new \GuzzleHttp\Client([ 'timeout'=> 10.0, 'verify' =>$this->get('kernel')->getRootDir().'/../web/SSL/cacert.pem']);
                try 
                {   
                    $em = $this->getDoctrine()->getManager();
        
                    $response = $client->request('POST', $this->getParameter('epayment_base_url').'/initiate/payment/MTN', [
                       'form_params'=> [ 
                            "cle"=>$cle,
                            "amount"=>$amount,
                            "currency"=>"XAF",
                            "clientEId"=>$num,
                            "partyId"=> $numero,
                            /*"payer"=> [
                                "partyIdType"=>"MSISDN",
                                //"partyId"=> "237673126161",
                                "partyId"=> $numero,
                            ],*/
                            "payerMessage"=>$payerMessage,
                            "payeeNote"=>$payeeNote,
                        ]
                    ]);
        
                     /*$code =  $response->getStatusCode(); # 200
                    $header =  $response->getHeaderLine('content-type'); # 'application/json; charset=utf8'*/
                    $body =  (string)$response->getBody(); # '{"id": 1420053, "name": "guzzle", ...}'
                    
                    $ret = json_decode($body, true);  
                    if($ret['uuid'] == 'null' || $ret['status_code'] =='Application non autorisé ou Clé API incorrecte')
                    {
                        $reply = 0;                                     
                        $mtn->setStatus(0);
                    }else
                    {
                        $uuid = $num;
                        $reply = 1;
                        $mtn->setStatus(1);
                    }
                    //dump($ret);die;
                   
                     
                } catch (\GuzzleHttp\Exception\ConnectException $th)
                {
                   //die('bam');
                   throw $th;
                  // $rep ='ERREUR';
                  //die();
                  $reply = 0;
                }
                
                $em->persist($checkQr);
                $em->persist($mtn);
                $em->flush();    

           }
        }
       
        $tabRetour = array(
            'uuid' => (empty($uuid)) ? 'null' : $uuid,
            'status_code' => (empty($reply)) ? '0' : $reply,
        );
        //$response = $tabRetour;
        $response = new JsonResponse($tabRetour);
        return $response;
    }

    
    /**
     * Pay and update object.
     *
     * @Route("/payment/status/om", name="mtn_om_pay_status")
     * @Method({"GET", "POST"})
     */
    public function getPaymentStatusAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        
        $cle =  $cle = $this->getParameter('api_key');
        $clientEId = $request->get('niu');
       // $reply = 0;

    //dump($clientEId);die;
        
        //dump($factureSpontane->getQrCode()->getNumero());die;
        $client = new \GuzzleHttp\Client([ 'timeout'=> 10.0, 'verify' =>$this->get('kernel')->getRootDir().'/../web/SSL/cacert.pem']);
        try 
        {   
            $em = $this->getDoctrine()->getManager();

            $response = $client->request('POST', $this->getParameter('epayment_base_url').'/client/request/status', [
                'form_params'=> [
                    "cle"=>$cle,
                    "clientEId"=>$clientEId,
                ]
            ]);
            /*$code =  $response->getStatusCode(); # 200
            $header =  $response->getHeaderLine('content-type'); # 'application/json; charset=utf8'*/
            $body =  (string)$response->getBody(); # '{"id": 1420053, "name": "guzzle", ...}'
            
            $ret = json_decode($body, true);  
                 
            /*dump($ret);      
            die('here');*/
            if($ret['status_message'] == 'KO' || $ret['status_message'] =='Identifiant ne correspond à aucun enregistrement' || $ret['status_message'] =='Application non autorisé ou Clé API incorrecte'){
                $reply = 0; 
            }elseif($ret['status_message'] == 'OK' &&  $ret['status']=='SUCCESSFUL')
            {
                $reply = 1; 
                    // Succès Paiement encaissé
                    // traitemement sur l'ATD
                    
                    $mtnCam = $em->getRepository('AMLASqrBundle:MTN')->getMtnFromCheckQr($clientEId);
                    //$mtnCam = $em->getRepository('AMLASqrBundle:MTN')->getMtnFromCheckQr($num);
                    //dump($mtnCam[0]);
                    if($mtnCam[0])
                    {   
                        $mtnCam = $mtnCam[0];
                        $montantApprovisionne = $mtnCam->getAtd()->getResteAPayer() - $mtnCam->getAmount();
                        $user = $this->getUser();
                        $emeteur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]); 
                        $atd = $mtnCam->getAtd();
                        //dump($emeteur);die;            
                        $mouvementAtd = new MouvementAtd();

                        $mouvementAtd->setAtd($mtnCam->getAtd());
                        $mouvementAtd->setEmetteur($emeteur);                    
                        $mouvementAtd->setMontantInit($mtnCam->getAmount());
                        $mouvementAtd->setMontantCurrent($montantApprovisionne);
                        $mouvementAtd->setStatut(1);

                        $atd->setStatut(2);//0=EMIS, 1 = Provisionné, 2=En cours 3 suspendu
                        $atd->setResteAPayer($montantApprovisionne);

                        // Génération du document ATD MPDF***********            
                        $cle = $this->container->getParameter('api_key');
                        $piece = 'ATD_Provision';
                        $proprietaire = $emeteur->getRaisonSociale();

                        $post = array(
                            'cle' => $cle,
                            'pieceqr'=> $piece, 
                            'proprietaire' => $proprietaire, 

                            'NIU Mis en cause' => $mtnCam->getAtd()->getMisEnCause(),
                            'Nom Mis en cause' => $mtnCam->getAtd()->getNomMisEnCause(),
                            'Montant' => $mtnCam->getAtd()->getMontant(),
                            //'Reférence ATD' => $mtnCam->getAtd()->getReference(),
                            'Emis par' => $mtnCam->getAtd()->getMisEnCause(),
                            'provisionné par'=>$mouvementAtd->getEmetteur()->getRaisonSociale(),
                        );

                        $container = $this->container;
                        $api = new SqrApi($container);
                        $res = $api->callAPI($post);
                        
                        if($res[0])
                        {
                            $qr = $res[0]->qr;
                            $num = $res[0]->niu; 
                        }
                        
                        $newname = 'ATD_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
                        //$checkqr = new CheckQr();
                        $checkqr = $api->generateQr($qr,$num,$newname);
                        $checkqr->setChemin($newname);
                        $mouvementAtd->setQrCode($checkqr); 

                        //Génération du Bordereau avec MPDF
                        $target = __DIR__.'/../../../../web/generated/Atd/provision/';
                        $name = 'provision'.date('is',time()).mt_rand(0,1000).$atd->getQrCode()->getNumero().'.pdf';
                        /* dump($this->get('kernel')->getRootDir().'/web/'.$request->getBasePath().$boncommande->getQrCode()->getChemin());
                        die; */
                        $pdf = $this->renderView('atd/docProvision.html.twig', array(
                            'atd' => $atd,
                            'emeteur'=>$emeteur,
                            'mouvementAtd'=>$mouvementAtd,
                            'imageqr'=> $atd->getQrCode()->getChemin(),
                            'base_dir' => $this->get('kernel')->getRootDir().'/../web'.$request->getBasePath(),
                        ));

                        try
                        {
                            $mpdf = new \Mpdf\Mpdf();
                            $mpdf->WriteHtml($pdf);
                            if (file_exists($target) != 1) 
                            {
                                mkdir($target,0777,true);
                                $mpdf->Output($target.$name, 'F');
                            }else
                            {
                                $mpdf->Output($target.$name, 'F');
                            }
                        }catch(MpdfException $e)
                        {
                            die($e->getMessage());
                            $this->get('session')->getFlashBag()->add('danger', 'Erreur lors de la génération de l\'ATD');
                        }
                            // fIN Génération du document ATD MPDF*******************************
                            $mouvementAtd->setPdf('generated/Atd/provision/'.$name);
                            //$atd->setQrCode($checkqr);
                            $em->persist($checkqr);
                            $em->persist($atd);
                            $em->persist($mouvementAtd);
                            $em->flush();

                            $this->addFlash('info', 'ATD Provisionné avec succès');
                            $this->addFlash('info','ATD Provisionné avec succès');
                    }
                    
                    //}           
                    //dump($atd);die;
                    //return $this->redirectToRoute('atd_show', array('id' => $atd->getId()));
               //$this->get('session')->getFlashBag()->add('success', 'Votre paiement a été confirmé et encaissé avec succèss !!!.');
                //$this->addFlash('success', 'Votre paiement a été confirmé et encaissé avec succèss !!!.'); 

            }elseif($ret['status_message'] == 'OK' &&  $ret['status']=='PENDING')
            {
                $reply = 2; //en atente
            }  
            elseif($ret['status_message'] == 'OK' &&  $ret['status']=='FAILED')
            {
                $reply = 3; //Failed
                $this->addFlash('danger', 'Votre paiement n\'a pas été validé. Veuillez essayer à nouveau.');   
                //$this->get('session')->getFlashBag()->add('danger', 'Votre paiement n\'a pas été validé. Veuillez essayer à nouveau.');
            }            
                
        } catch (\GuzzleHttp\Exception\ConnectException $th)
        {
            throw $th;
            $reply = 4;// catch
        }        
       
        $response = $reply;
        $response = new JsonResponse($reply);
        return $response;
    }

    /**
     * Creates a new mTN entity.
     *
     * @Route("/new", name="mtn_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $mTN = new Mtn();
        $form = $this->createForm('AMLA\SqrBundle\Form\MTNType', $mTN);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($mTN);
            $em->flush();

            return $this->redirectToRoute('mtn_show', array('id' => $mTN->getId()));
        }

        return $this->render('mtn/new.html.twig', array(
            'mTN' => $mTN,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a mTN entity.
     *
     * @Route("/{id}", name="mtn_show")
     * @Method("GET")
     */
    public function showAction(MTN $mTN)
    {
        $deleteForm = $this->createDeleteForm($mTN);

        return $this->render('mtn/show.html.twig', array(
            'mTN' => $mTN,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing mTN entity.
     *
     * @Route("/{id}/edit", name="mtn_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, MTN $mTN)
    {
        $deleteForm = $this->createDeleteForm($mTN);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\MTNType', $mTN);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('mtn_edit', array('id' => $mTN->getId()));
        }

        return $this->render('mtn/edit.html.twig', array(
            'mTN' => $mTN,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a mTN entity.
     *
     * @Route("/{id}", name="mtn_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, MTN $mTN)
    {
        $form = $this->createDeleteForm($mTN);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($mTN);
            $em->flush();
        }

        return $this->redirectToRoute('mtn_index');
    }

    /**
     * Creates a form to delete a mTN entity.
     *
     * @param MTN $mTN The mTN entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(MTN $mTN)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('mtn_delete', array('id' => $mTN->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
