<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Invitation;
use AMLA\SqrBundle\Entity\FournisseurMoa;
use AMLA\SqrBundle\Entity\RelationAffaire;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Invitation controller.
 *
 * @Route("invitation/{_locale}", defaults = {"_locale" = "fr"})
 */
class InvitationController extends Controller
{
    /**
     * Lists all invitation entities.
     *
     * @Route("/", name="invitation_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();

        $invitations = $em->getRepository('AMLASqrBundle:Invitation')->getAllInvitation($user);
        return $this->render('invitation/index.html.twig', array(
            'invitations' => $invitations,
        ));
    }

    /**
     * Lists all invitation entities.
     *
     * @Route("/mine", name="invitation_mine")
     * @Method("GET")
     */
    public function sentAction()
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $invitations = $em->getRepository('AMLASqrBundle:Invitation')->getAllSentInvitation($user);

        return $this->render('invitation/sent.html.twig', array(
            'invitations' => $invitations,
        ));
    }

    /**
     * Lists all invitation entities.
     *
     * @Route("/pending", name="invitation_pending")
     * @Method("GET")
     */
    public function pendingAction()
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $invitations = $em->getRepository('AMLASqrBundle:Invitation')->getPendingInvitation($user);

        return $this->render('invitation/pending.html.twig', array(
            'invitations' => $invitations,
        ));
    }

    /**
     * Lists all invitation entities.
     *
     * @Route("/accept", name="invitation_accept")
     * @Method("GET")
     */
    public function acceptAction()
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $invitations = $em->getRepository('AMLASqrBundle:Invitation')->getAcceptInvitation($user);

        return $this->render('invitation/accept.html.twig', array(
            'invitations' => $invitations,
        ));
    }

    /**
     * Lists all invitation entities.
     *
     * @Route("/receive", name="invitation_receive")
     * @Method("GET")
     */
    public function receiptAction()
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $invitations = $em->getRepository('AMLASqrBundle:Invitation')->getReceiptInvitation($user);

        return $this->render('invitation/receive.html.twig', array(
            'invitations' => $invitations,
        ));
    }

    /**
     * Lists all invitation entities.
     *
     * @Route("/{id}/valid", name="invitation_valid")
     * @Method({"GET","POST"})
     */
    public function validAction(Invitation $invitation)
    {
        $user = $this->getUser();

        $em = $this->getDoctrine()->getManager();
        if ($invitation->getStatut() == 0) 
        {

            $invitation->setStatut(1);
            $fournisseurMOA = new FournisseurMoa();
            $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
            $moa  = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$invitation->getSender()->getId()]);
            $fournisseurMOA->setMoa($moa);
            $fournisseurMOA->setFournisseur($fournisseur);
            $em->persist($invitation);
            $em->persist($fournisseurMOA);
            $em->flush();

            try
            {

                $message = (new \Swift_Message('CHECKTATOO - Invitation'))
                ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
                //->setTo($moa->getAdresseEmail())
                ->setTo($fournisseur->getAdresseEmail())
                ->setBody(
                    $this->renderView(
                        'emails/invitationvalidation.html.twig',array(
                        'sender' => $moa, )
                    ),
                    'text/html'
                );

                $this->get('mailer')->send($message);

            } catch (\Exception $e)
            {
                //dump($e);die;
                $this->addFlash('danger','une erreur est survenue lors de l\'envoie du mail');
                return $this->redirectToRoute('dashboard_index');
            }

            try {

                $message = (new \Swift_Message('CHECKTATOO - Invitation'))
                ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
                //->setTo($fournisseur->getAdresseEmail())
                ->setTo($moa->getAdresseEmail())
                ->setBody(
                    $this->renderView(
                        'emails/invitvalidsender.html.twig',array(
                        'receiver' => $fournisseur, )
                    ),
                    'text/html'
                );

                $this->get('mailer')->send($message);
            } catch (\Exception $e) {
                //dump($e);die;
                $this->addFlash('danger','une erreur est survenue lors de l\'envoie du mail');
                return $this->redirectToRoute('dashboard_index');
            } 
        }
        $invitations = $em->getRepository('AMLASqrBundle:Invitation')->findAll();

        return $this->redirectToRoute('invitation_pending');
    }

    /**
     * Creates a new invitation entity.
     *
     * @Route("/new", name="invitation_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $invitation = new Invitation();
        $form = $this->createForm('AMLA\SqrBundle\Form\InvitationType', $invitation);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {

            //set receiver et sender à partir des repository 
            //Faire un swiftmailer si bon 
            //Lien dépendant de l'existence du fournisseur

            $email = $invitation->getEmail();
            $sender = $this->getUser();
            $invitation->setSender($sender);
            $receiver = $em->getRepository('AMLASqrBundle:Account')->findOneBy(['email' => $email]);

            if ($receiver != NULL) 
            {
                //$invitSelf = $em->getRepository('AMLASqrBundle:Invitation')->findOneBy(['sender'=>$sender->getId(),'receiver'=>$sender->getId()]);
                if($sender->getId() != $receiver->getId())
                {
                    $invit = $em->getRepository('AMLASqrBundle:Invitation')->findOneBy(['sender'=>$sender->getId(),'receiver'=>$receiver->getId()]);

                    if($invit != NULL)
                    {
                        $this->addFlash('danger','Vous avez déjà envoyé une invitation à cette addresse');
                        return $this->redirectToRoute('dashboard_index');
    
                    }else
                    {
    
                        $invitation->setReceiver($receiver);
                        $em->persist($invitation);
                        $em->flush();
                        $this->addFlash('info','invitation envoyée');
                        //return $this->redirectToRoute('dashboard_index');
                        try {
    
                            $message = (new \Swift_Message('CHECKTATOO - Invitation'))
                            ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
                            ->setTo($email)
                            ->setBody(
                                $this->renderView(
                                    'emails/invitation.html.twig',array(
                                    'sender' => $sender, )
                                ),
                                'text/html'
                            );
    
                            $this->get('mailer')->send($message);
                            $this->addFlash('info','Mail envoyé avec succès');
                            return $this->redirectToRoute('invitation_new');
    
                        } catch (\Exception $e) 
                        {
                            
                            $this->addFlash('danger','une erreur est survenue lors de l\'envoie du mail');
                            return $this->redirectToRoute('invitation_new');
                        }
                    }      
                }else
                {
                    $this->addFlash('danger','Impossible de vous envoyer une invitation !');
                    return $this->redirectToRoute('invitation_new');
                }
                 
            }else
            {

                $this->addFlash('danger','invitation non envoyée, vérifiez l\'adresse email.');
                return $this->redirectToRoute('invitation_new');

                /* try {

                    $message = (new \Swift_Message('CHECKTATOO - Invitation'))
                    ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
                    ->setTo($email)
                    ->setBody(
                        $this->renderView(
                            'emails/invitationnew.html.twig'
                        ),
                        'text/html'
                    );
                
                    $this->get('mailer')->send($message);
                    $this->addFlash('info','Mail envoyé avec succès');
                    return redirectToRoute('invitation_new');

                } catch (\Exception $e) {
                    
                    $this->addFlash('danger','une erreur est survenue lors de l\'envoie du mail');
                    return redirectToRoute('invitation_new');
                }*/
            }
            return $this->redirectToRoute('invitation_show', array('id' => $invitation->getId()));
        }

        return $this->render('invitation/new.html.twig', array(
            'invitation' => $invitation,
            'form' => $form->createView(),
        ));
    }

    /**
     * Creates a new invitation entity.
     *
     * @Route("/relation/affaire", name="invitation_relation_affaire")
     * @Method({"GET", "POST"})
     */
    public function relationAffaireAction(Request $request)
    {
        $user = $this->getUser();
        if ($this->getUser() && !empty($this->getUser()->getRole())) 
        {
            $em = $this->getDoctrine()->getManager();
            $invitation = new Invitation();
            $form = $this->createForm('AMLA\SqrBundle\Form\RelationAffaireInvitationType', $invitation);
            $form->handleRequest($request);

            if ($form->isSubmitted() && $form->isValid()) 
            {

                //set receiver et sender à partir des repository 
                //Faire un swiftmailer si bon 
                //Lien dépendant de l'existence du fournisseur

                $email = $invitation->getEmail();
                $fournisseurRelation = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['niu' => $email]);                       

                if ($fournisseurRelation != NULL) 
                {

                    if($user->getCompagnyId()->getId() != $fournisseurRelation->getId())
                    {
                        $invit = $em->getRepository('AMLASqrBundle:RelationAffaire')->findOneBy(['fournisseurInitial'=>$user->getCompagnyId(),'fournisseurEnAffaire'=>$fournisseurRelation]);
                        if (empty($invit)) 
                        {
                            // code...
                            $invit = $em->getRepository('AMLASqrBundle:RelationAffaire')->findOneBy(['fournisseurInitial'=>$fournisseurRelation,'fournisseurEnAffaire'=>$user->getCompagnyId()]);
                        }

                        if($invit != NULL)
                        {
                            $this->addFlash('danger',"Vous avez déjà une relation d'affaire avec ce contribuable");
                            return $this->redirectToRoute('relationaffaire_mine');
        
                        }else
                        {
                            $relationAffaire = new RelationAffaire();

                            $relationAffaire->setFournisseurInitial($user->getCompagnyId());
                            $relationAffaire->setFournisseurEnAffaire($fournisseurRelation);
                            $em->persist($relationAffaire);
                            $em->flush();

                            $this->addFlash('info','invitation envoyée');

                            //return $this->redirectToRoute('dashboard_index');
                            try 
                            {
        
                                $message = (new \Swift_Message('CHECKTATOO - Invitation'))
                                ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
                                ->setTo($email)
                                ->setBody(
                                    $this->renderView(
                                        'emails/invitation.html.twig',array(
                                        'sender' => $sender, )
                                    ),
                                    'text/html'
                                );
        
                                $this->get('mailer')->send($message);
                                $this->addFlash('info','Mail envoyé avec succès');
                                return $this->redirectToRoute('invitation_relation_affaire');
        
                            } catch (\Exception $e) 
                            {
                                
                                $this->addFlash('danger','une erreur est survenue lors de l\'envoie du mail');
                                //return $this->redirectToRoute('invitation_relation_affaire');
                            }
                        }      
                    }else
                    {
                        $this->addFlash('danger','Impossible de vous envoyer une invitation !');
                        //return $this->redirectToRoute('invitation_relation_affaire');
                    }
                     
                }else
                {

                    $this->addFlash('danger',"Ce NIU n'est associé à aucun compte CHECKTATOO.");
                    //return $this->redirectToRoute('invitation_relation_affaire');
                }
                //return $this->redirectToRoute('invitation_show', array('id' => $invitation->getId()));
            }

            return $this->render('invitation/new_relation_affaire.html.twig', array(
                'invitation' => $invitation,
                'form' => $form->createView(),
            ));

        }else
        {
            $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
            return $this->redirectToRoute('dashboard_index');
        }
    }

    /**
     * Finds and displays a invitation entity.
     *
     * @Route("/{id}", name="invitation_show")
     * @Method("GET")
     */
    public function showAction(Invitation $invitation)
    {
        $deleteForm = $this->createDeleteForm($invitation);

        return $this->render('invitation/show.html.twig', array(
            'invitation' => $invitation,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing invitation entity.
     *
     * @Route("/{id}/edit", name="invitation_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Invitation $invitation)
    {
        $deleteForm = $this->createDeleteForm($invitation);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\InvitationType', $invitation);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('invitation_edit', array('id' => $invitation->getId()));
        }

        return $this->render('invitation/edit.html.twig', array(
            'invitation' => $invitation,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a invitation entity.
     *
     * @Route("/{id}", name="invitation_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Invitation $invitation)
    {
        $form = $this->createDeleteForm($invitation);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($invitation);
            $em->flush();
        }

        return $this->redirectToRoute('invitation_index');
    }

    /**
     * Creates a form to delete a invitation entity.
     *
     * @param Invitation $invitation The invitation entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Invitation $invitation)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('invitation_delete', array('id' => $invitation->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
