<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\InstitutionBancaire;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Institutionbancaire controller.
 *
 * @Route("institutionbancaire/{_locale}", defaults = {"_locale" = "fr"})
 */
class InstitutionBancaireController extends Controller
{
    /**
     * Lists all institutionBancaire entities.
     *
     * @Route("/", name="institutionbancaire_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $institutionBancaires = $em->getRepository('AMLASqrBundle:InstitutionBancaire')->findAll();

        return $this->render('institutionbancaire/index.html.twig', array(
            'institutionBancaires' => $institutionBancaires,
        ));
    }

    /**
     * Creates a new institutionBancaire entity.
     *
     * @Route("/new", name="institutionbancaire_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $institutionBancaire = new Institutionbancaire();
        $form = $this->createForm('AMLA\SqrBundle\Form\InstitutionBancaireType', $institutionBancaire);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($institutionBancaire);
            $em->flush();

            return $this->redirectToRoute('institutionbancaire_show', array('id' => $institutionBancaire->getId()));
        }

        return $this->render('institutionbancaire/new.html.twig', array(
            'institutionBancaire' => $institutionBancaire,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a institutionBancaire entity.
     *
     * @Route("/{id}", name="institutionbancaire_show")
     * @Method("GET")
     */
    public function showAction(InstitutionBancaire $institutionBancaire)
    {
        $deleteForm = $this->createDeleteForm($institutionBancaire);

        return $this->render('institutionbancaire/show.html.twig', array(
            'institutionBancaire' => $institutionBancaire,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing institutionBancaire entity.
     *
     * @Route("/{id}/edit", name="institutionbancaire_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, InstitutionBancaire $institutionBancaire)
    {
        $deleteForm = $this->createDeleteForm($institutionBancaire);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\InstitutionBancaireType', $institutionBancaire);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('institutionbancaire_edit', array('id' => $institutionBancaire->getId()));
        }

        return $this->render('institutionbancaire/edit.html.twig', array(
            'institutionBancaire' => $institutionBancaire,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a institutionBancaire entity.
     *
     * @Route("/{id}", name="institutionbancaire_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, InstitutionBancaire $institutionBancaire)
    {
        $form = $this->createDeleteForm($institutionBancaire);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($institutionBancaire);
            $em->flush();
        }

        return $this->redirectToRoute('institutionbancaire_index');
    }

    /**
     * Creates a form to delete a institutionBancaire entity.
     *
     * @param InstitutionBancaire $institutionBancaire The institutionBancaire entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(InstitutionBancaire $institutionBancaire)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('institutionbancaire_delete', array('id' => $institutionBancaire->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
