<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\InBill;
use AMLA\SqrBundle\Entity\SubscriptionInBill;
use AMLA\SqrBundle\Entity\FactureSpontane;
use AMLA\SqrBundle\Entity\FactureSpontaneArticle;
use AMLA\SqrBundle\Entity\FactureSpontaneService;
use AMLA\SqrBundle\Entity\Notification;
use AMLA\SqrBundle\Entity\Fournissseur;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;
use AMLA\SqrBundle\API\SqrApi as SqrApi; 


// Import the class
use Numbers_Words;

/**
 * Inbill controller.
 *
 * @Route("inbill/{_locale}", defaults = {"_locale" = "fr"})
 */
class InBillController extends Controller
{
    /**
     * Lists all inBill entities.
     *
     * @Route("/", name="inbill_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $inBills = $em->getRepository('AMLASqrBundle:InBill')->findAll();

        return $this->render('inbill/index.html.twig', array(
            'inBills' => $inBills,
        ));
    }

    /**
     * Lists all inBill entities.
     *
     * @Route("/mine", name="inbill_index_mine")
     * @Method({"GET", "POST"})
     */
    public function indexMineAction(Request $request)
    {
        if($this->getUser() && !empty($this->getUser()->getRole())) 
        {
            $em = $this->getDoctrine()->getManager();

            $fournisseur = $this->getUser()->getCompagnyId();
            //$inBill = $em->getRepository('AMLASqrBundle:InBill')->findOneBy(['fournisseur'=>$fournisseur]);
            $inBill = $fournisseur->getInBill();
            if($inBill)
            {
                $subscriptionInBill = new Subscriptioninbill();
                $form = $this->createForm('AMLA\SqrBundle\Form\SubscriptionInBillType', $subscriptionInBill);
                $form->handleRequest($request);

                if ($form->isSubmitted() && $form->isValid()) 
                {
                    $user = $this->getUser();
                    $em = $this->getDoctrine()->getManager();
                    $fournisseur = $user->getCompagnyId();

                    
                    $dateDebut = new \Datetime();
                    $interval = new \DateInterval('P'.$subscriptionInBill->getMonths().'M');

                    $inBill = $em->getRepository('AMLASqrBundle:InBill')->findOneBy(['fournisseur'=>$fournisseur]);
                    if ($inBill) 
                    {
                        // calcule des dates de validité du cours souscrit
                        $dateFinAncien = new \Datetime($inBill->getDateFin()->format('Y-m-d'));
                        $dateFinNouveau = $dateFinAncien->add($interval);

                        $inBill->setDateDebut($dateFinAncien);
                        $inBill->setDateFin($dateFinNouveau);
                        
                    }else
                    {

                        $dateFinAncien = new \Datetime(date("Y-m-d"));
                        $dateFinNouveau = $dateFinAncien->add($interval);

                        $inBill = new InBill();
                        $inBill->setDateFin($interval);
                        $inBill->setFournisseur($fournisseur);
                        $inBill->setDateDebut($dateFinAncien);
                        $inBill->setDateFin($dateFinNouveau);
                    }

                    //update fournisseur set inbill available
                    $fournisseur->setIsInbill(1);

                    $subscriptionInBill->setInBill($inBill);
                    $subscriptionInBill->setAccount($user);
                    $subscriptionInBill->setDateStart($dateFinAncien);
                    $subscriptionInBill->setDateEnd($dateFinNouveau);
                    //dump($inBill);dump($subscriptionInBill);die;
                    
                    $em->persist($inBill);
                    $em->persist($subscriptionInBill);
                    $em->flush();
                        

                    $this->get('session')->getFlashBag()->add('success', 'Votre souscription au service IB BILL a été renouvellé avec succès !!!');
                    return $this->redirectToRoute('inbill_index_mine');
                    //return $this->redirectToRoute('subscriptioninbill_show', array('id' => $subscriptionInBill->getId()));
                }

                return $this->render('inbill/index_mine.html.twig', array(
                    'inBill' => $inBill,
                    'subscriptionInBill' => $subscriptionInBill,
                    'form' => $form->createView(),
                ));
            }else
            {
                $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
                return $this->redirectToRoute('dashboard_index');
            }
        }else
        {
            $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
            return $this->redirectToRoute('dashboard_index');
        }
    }



    /**
     * Lists all inBill entities.
     *
     * @Route("/preview/partners", name="inbill_preview_partners")
     * @Method({"GET", "POST"})
     */
    public function previewPartnersAction(Request $request)
    {
        $action = $request->get('action'); // DEVIS FACTURE
        $tabAction = ["DEVIS", "FACTURE"];
        $fournisseur = null;
        $result = null;
        $numb = null;
        
        if($action && in_array($action, $tabAction, true) )
        {
            if($this->getUser() && !empty($this->getUser()->getRole())) 
            {
                if ($_POST) 
                {
                    // code...
                     $nomRaison = $request->get('raisonSociale');
                    $niu =  $request->get('niu');

                    $em = $this->getDoctrine()->getManager();

                    if(!empty($niu) || !empty($nomRaison))
                    {
                        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['niu'=>$niu]);
                        if(empty($fournisseur))
                        {
                            $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['raisonSociale'=>$nomRaison]);
                        }

                        if(!empty($fournisseur) && $fournisseur !=  $this->getUser()->getCompagnyId())
                        {
                            // traitement des différents cas d'accès au IN BILL $result=3 ;
                            if(empty($fournisseur) || $fournisseur->getIsInBill() !=1)
                            {
                                $result=3 ;
                                $this->get('session')->getFlashBag()->add('danger', "L'entité que vous recherchez n'a pas été retrouvée ou n'a pas encore souscrit au service IN BILL");

                            }elseif (!empty($fournisseur) || $fournisseur->getIsInBill() ==1) 
                            {
                                $rechercheur = $this->getUser()->getCompagnyId();
                                if($fournisseur->getInBill()->getIsInbillAccess() ==3)// ma sélection uniquement
                                {
                                    $access = $em->getRepository('AMLASqrBundle:AccessInBill')->findOneBy(['inBill'=>$fournisseur->getInBill()]);

                                    foreach ($access as $acces) 
                                    {
                                        $accessRaison = $access->getRepertoire()->getRaisonSociale();
                                        $accessNiu = $access->getRepertoire()->getNiu();

                                        if($rechercheur->getNiu() === $accessNiu || $rechercheur->getRaisonSociale() === $accessRaison)
                                        {
                                            $numb == 1;
                                        }
                                    }

                                    if($numb ==1 )
                                    {
                                        $result=1;                                    
                                    }else
                                    {
                                        $this->get('session')->getFlashBag()->add('danger', "Désolé, vous n'avez pas accès à ce IN BILL");
                                    }

                                }elseif($fournisseur->getInBill()->getIsInbillAccess() ==2) // mon repertoire uniquement
                                {
                                    $repertoires = $em->getRepository('AMLASqrBundle:Repertoire')->findBy(['fournisseur'=>$fournisseur]);

                                    foreach ($repertoires as $repertoire) 
                                    {
                                        $repertoireRaison = $repertoire->getRepertoire()->getRaisonSociale();
                                        $repertoireNiu = $repertoire->getRepertoire()->getNiu();

                                        if($rechercheur->getNiu() === $repertoireNiu || $rechercheur->getRaisonSociale() === $repertoireRaison)
                                        {
                                            $numb == 1;
                                        }
                                    }

                                    if($numb == 1)
                                    {
                                        $result=1;                                   
                                    }else
                                    {
                                         $this->get('session')->getFlashBag()->add('danger', "Désolé, vous n'avez pas accès à ce IN BILL");
                                    }
                                }elseif($fournisseur->getInBill()->getIsInbillAccess() ==1) // Tous le monde
                                {
                                    
                                    $result=1 ;                                   
                                    
                                }
                                // code...
                                // if in bill is found and in bill gives no access to user $result=2 ;
                                //$this->get('session')->getFlashBag()->add('danger', "Désolé, vous n'avez pas accès à ce IN BILL");

                                // if in bill is found and in bill gives access to user  $result=1 ;// if in bill is found and in bill gives no access to user $result=2 ;
                                //$this->get('session')->getFlashBag()->add('danger', "Désolé, vous n'avez pas accès à ce IN BILL");

                                // if in bill is found and in bill gives access to user  $result=1 ;

                            }   

                        }
                        elseif(!empty($fournisseur) && $fournisseur ==  $this->getUser()->getCompagnyId())
                        {
                            $this->get('session')->getFlashBag()->add('danger', "Impossible d'accéder au résultat. La recherche correspond à votre compte. ");
                        }
                        else
                        {
                            $this->get('session')->getFlashBag()->add('danger', "Compte IN BILL introuvable ou non valide...");
                        }
                                          

                        //$fournisseur = $this->getUser()->getCompagnyId();
                        //$relationAffaires = $em->getRepository('AMLASqrBundle:RelationAffaire')->getAcceptedOutRelation($fournisseur);
                        //$fournisseurs = $em->getRepository('AMLASqrBundle:Fournissseur')->findBy(['isInBill'=>1]);

                    }else
                    {
                        $this->get('session')->getFlashBag()->add('danger', 'Veuillez renseigner soit le nom / raison sociale ou le NIU pour effectuer la recherche');
                    }
                }

                 
                return $this->render('inbill/index_view_partners.html.twig', array(
                    //'relationAffaires' => $relationAffaires,
                    'action'=>$action,
                    'fournisseur'=>$fournisseur,
                    'result'=>$result,
                ));
                
            }else
            {
                $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
                return $this->redirectToRoute('dashboard_index');
            }
        }else
        {
            $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
            return $this->redirectToRoute('dashboard_index');
        }
            
    }


    /**
     * Creates a new factureSpontane entity.
     *
     * @Route("/new/{id}/secure", name="inbill_new_secure")
     * @Method({"GET", "POST"})
     */
    public function newSecureAction(Fournissseur $fournisseur, Request $request)
    {        
        if($this->getUser() && !empty($this->getUser()->getRole())) 
        {
            $action = $request->get('action'); // DEVIS FACTURE
            $tabAction = ["DEVIS", "FACTURE"];

            if($action && in_array($action, $tabAction, true) )
            {
                $em = $this->getDoctrine()->getManager();
                //$inBill = $em->getRepository('AMLASqrBundle:InBill')->findOneBy(['fournisseur'=>$fournisseur]);
                $inBill =  $this->getUser()->getCompagnyId()->getInBill();

                if($inBill)
                {
                    $factureSpontane = new FactureSpontane();
                    $form = $this->createForm('AMLA\SqrBundle\Form\FactureSecuriseInBillType', $factureSpontane);
                    $form->handleRequest($request);

                    if ($form->isSubmitted() && $form->isValid()) 
                    {
                        $qte = $request->get('qte');
                        $prix = $request->get('prixht'); 
                        $tva = $request->get('tva');
                        $ir = $request->get('ir'); 
                        $designation = $request->get('designation');
                        $numeroEncaissement = $request->get('numeroEncaissement');
                        $banqueAssocie = $request->get('banqueAssocie');
                        $numCompte = $request->get('numCompte');

                        $qteService = $request->get('qteService');
                        $prixhtService = $request->get('prixhtService');
                        $designationService = $request->get('designationService');

                        if(count($designation) > 0 || count($designationService) > 0)
                        {

                        
                            //enrichir l'objet facture avec les données de facturation
                            $factureSpontane->setBeneficiaireEmail($fournisseur->getAdresseEmail());
                            $factureSpontane->setBeneficiaireNiu($fournisseur->getNiu());
                            $factureSpontane->setBeneficiaireSocialReason($fournisseur->getRaisonSociale());
                            $factureSpontane->setBeneficiaireTelephone($fournisseur->getTelephoneMobile());

                            switch ($factureSpontane->getModeReglement()) 
                            {
                                case 'ORANGE':
                                    $factureSpontane->setTelephoneMomoReglement($numeroEncaissement);
                                    break;
                                case 'VIREMENT':
                                    $factureSpontane->setBanqueReglement($banqueAssocie);
                                    $factureSpontane->setNumcomptebanqueReglement($numCompte);                    
                                break;
                                case 'ORABANK':
                                    break;
                                case 'MOMO':                    
                                    $factureSpontane->setTelephoneMomoReglement($numeroEncaissement);
                                    break;
                                case 'TOUT':

                                    break;
                                default:
                                  //...''
                            }

                            /*dump($request); dump($factureSpontane->getModeReglement());
                            dump($factureSpontane);die;*/
                            //dump($request);die;
                            // for products
                            for($i = 0; $i < count($designation); $i++)
                            {
                                $factureSpontaneArticle = new FactureSpontaneArticle();
                                $factureSpontaneArticle->setFactureSpontane($factureSpontane);
                                $factureSpontaneArticle->setNomArticle($designation[$i]);
                                $factureSpontaneArticle->setQuantite($qte[$i]);
                                $factureSpontaneArticle->setPrix($prix[$i]);
                                $factureSpontaneArticle->setPrixHT($qte[$i] * $prix[$i]);
                                $factureSpontaneArticle->setTva(($qte[$i] * $prix[$i]) * $tva / 100);
                                $factureSpontaneArticle->setPrixTtc($factureSpontaneArticle->getPrixHT() + $factureSpontaneArticle->getTva());
                                $em->persist($factureSpontaneArticle);
                                //dump($factureSpontaneArticle);
                                //$em->flush();
                                $factureSpontane->setMontantTotalTva($factureSpontane->getMontantTotalTva() + $factureSpontaneArticle->getTva());
                                $factureSpontane->setMontantTotalHt($factureSpontane->getMontantTotalHt() + $factureSpontaneArticle->getPrixHT());
                                $factureSpontane->setMontantTotalTtc($factureSpontane->getMontantTotalTtc() + $factureSpontaneArticle->getPrixTtc());
                            }
                            
                            // for services
                            for($i = 0; $i < count($designationService); $i++)
                            {
                                $factureSpontaneService = new FactureSpontaneService();
                                $factureSpontaneService->setFactureSpontane($factureSpontane);
                                $factureSpontaneService->setDesignation($designationService[$i]);
                                $factureSpontaneService->setQuantite($qteService[$i]);
                                $factureSpontaneService->setPrix($prixhtService[$i]);
                                $factureSpontaneService->setPrixHT($qteService[$i] * $prixhtService[$i]);
                                $factureSpontaneService->setTva(($qteService[$i] * $prixhtService[$i]) * $tva / 100);
                                $factureSpontaneService->setPrixTtc($factureSpontaneService->getPrixHT() + $factureSpontaneService->getTva());
                                $em->persist($factureSpontaneService);
                                //dump($factureSpontaneService);
                                //$em->flush();
                                $factureSpontane->setMontantTotalTva($factureSpontane->getMontantTotalTva() + $factureSpontaneService->getTva());
                                $factureSpontane->setMontantTotalHt($factureSpontane->getMontantTotalHt() + $factureSpontaneService->getPrixHT());
                                $factureSpontane->setMontantTotalTtc($factureSpontane->getMontantTotalTtc() + $factureSpontaneService->getPrixTtc());
                            }

                            //die;
                            $factureSpontane->setAttn($factureSpontane->getBeneficiaireSocialReason());
                            $factureSpontane->setStatut(0);
                            $factureSpontane->setTva($tva);
                            $factureSpontane->setIr($ir);
                            $factureSpontane->setIrMontant(($factureSpontane->getMontantTotalHt() * $ir) / 100);
                            $factureSpontane->setNetApayer(($factureSpontane->getMontantTotalTtc() - $factureSpontane->getIrMontant()));
                            $factureSpontane->setResteAPayer($factureSpontane->getNetApayer());
                            $factureSpontane->setAccount($this->getUser());           
                            $factureSpontane->setType($action);

                            $frnisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['niu'=>$factureSpontane->getBeneficiaireNiu()]);

                            if (empty($frnisseur)) 
                            {
                                $frnisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['raisonSociale'=>$factureSpontane->getBeneficiaireSocialReason()]);
                            }
                                
                            if(!empty($frnisseur))
                            {

                                $factureSpontane->setFournisseur($frnisseur); 

                                /**************Add Notification for received  */
                                $notificationO = New Notification();
                                $notificationO->setTitle('Reception Facture IN BILL');
                                $notificationO->setDescription('Une facture IN BILL a été émis à votre endroit par le contribuable '.$this->getUser()->getFournisseurs()[0]->getRaisonSociale().' - '.$this->getUser()->getFournisseurs()[0]->getNiu().' dont la référence est'.$factureSpontane->getReference(). '. Vous pouvez consulter le détail dans la section facture sécurisé reçues');
                                $notificationO->setFournisseur($frnisseur); 
                                $em->persist($notificationO);
                                /**************End Add Notification */
                            }
                             /**************Add Notification for sent Bill */
                             $notificationI = New Notification();
                             $notificationI->setTitle('Emission facture instantanée');
                             $notificationI->setDescription('Vous avez émis une nouvelle facture via IN BILL au contribuable '.$factureSpontane->getBeneficiaireSocialReason().' '. $factureSpontane->getBeneficiaireNiu().'. La référence pour la facture est '.$factureSpontane->getReference());
                             $notificationI->setFournisseur($this->getUser()->getFournisseurs()[0]); 
                             $em->persist($notificationI);
                             /**************End Add Notification */
                           

                            $cle = $this->getParameter('api_key');
                            $piece = 'Facture instantanée';
                            $proprietaire = 'Emetteur: '.$this->getUser()->getFournisseurs()[0]->getRaisonSociale().' '.'Destinataire: '.$factureSpontane->getBeneficiaireNiu().'-'.$factureSpontane->getBeneficiaireSocialReason();

                            $post = array(
                                'cle' => $cle,
                                'pieceqr'=> $piece, 
                                'proprietaire' => $proprietaire, 
                            );

                            $container = $this->container;
                            $api = new SqrApi($container);
                            $res = $api->callAPI($post);
                            
                            if($res[0])
                            {
                                $qr = $res[0]->qr;
                                $num = $res[0]->niu; 
                            }
                            
                            $newname = 'FACTURE_instantane_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
                            //Génération du facture avec MPDF
                            $name = 'FACTURE_SECURISE'.$num.'.pdf';
                            $target = __DIR__.'/../../../../web/Production_documentaire/factures/';
                            //$checkqr = new CheckQr();
                            $checkqr = $api->generateQr($qr,$num,$newname);
                            $checkqr->setChemin($newname);
                            $factureSpontane->setQrCode($checkqr); 
                            $factureSpontane->setInBill($inBill);

                            $factureSpontane->setPdf('Production_documentaire/factures/'.$name);
                            $em->persist($checkqr);
                            $em->persist($factureSpontane);
                            $em->flush(); 
                           
                            $pdf = $this->renderView('api/bill.html.twig', array(
                                // 'imageqr'=> $impotVerif->getQrCode()->getChemin(),
                                //'impotVerif' => $impotVerif,   
                                'imageqr'=> $factureSpontane->getQrCode()->getChemin(),
                                'factureSpontane'=>$factureSpontane,
                                'base_dir' => $this->get('kernel')->getRootDir() . '/../web',
                            ));

                            try
                            {
                                $mpdf = new \Mpdf\Mpdf();
                                $mpdf->WriteHtml($pdf);
                                if (file_exists($target) != 1)
                                {
                                    mkdir($target,0777,true);
                                    $mpdf->Output($target.$name, 'F');
                                }else
                                {
                                    $mpdf->Output($target.$name, 'F');
                                }

                            }catch(MpdfException $e)
                            {
                                $this->get('session')->getFlashBag()->add('danger', 'Erreur lors de l\'émission...');
                                die($e->getMessage());
                            }

                            $factureSpontaneArticles = $em->getRepository('AMLASqrBundle:FactureSpontaneArticle')->findBy(['factureSpontane'=>$factureSpontane]);
                            //dump($factureSpontaneArticles);die;
                            $msg = (new \Swift_Message('CHECKTATOO - Facture sécurisé'))
                            ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
                            ->setTo($factureSpontane->getBeneficiaireEmail())
                            ->setBody(
                                $this->renderView(
                                    'emails/emissionFactureSecurise.html.twig',array(
                                        'factureSpontane' =>$factureSpontane,
                                        'factureSpontaneArticles' => $factureSpontaneArticles,
                                    )
                                ),
                                'text/html'
                            )
                            ->attach(\Swift_Attachment::fromPath($target.$name));
                            $this->get('mailer')->send($msg);           
                            
                            return $this->redirectToRoute('facturespontane_show_securise', array('id' => $factureSpontane->getId()));

                        }else
                        {
                            $this->get('session')->getFlashBag()->add('danger', "Renseignez une des sections produits ou service...");
                        }
                    }

                    return $this->render('inbill/facturer.new.html.twig', array(
                        'factureSpontane' => $factureSpontane,
                        'form' => $form->createView(),
                        'inBill'=>$inBill,
                        'action'=>$action,
                        'fournisseur'=>$fournisseur,
                    ));
                }else
                {
                    $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
                    return $this->redirectToRoute('dashboard_index');
                }

            }else
            {
                $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
                return $this->redirectToRoute('dashboard_index');
            }
            
        }else
        {
            $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
            return $this->redirectToRoute('dashboard_index');
        }

    }


    /**
     * Creates a new factureSpontane entity.
     *
     * @Route("/{id}/parameter", name="inbill_parameter")
     * @Method({"GET", "POST"})
     */
    public function parameterAction(Fournissseur $fournisseur, Request $request)
    {
        if($fournisseur/* && !empty($fournisseur->getInBill())*/)
        {
            //dump($fournisseur);die;
            $form = $this->createForm('AMLA\SqrBundle\Form\InBillParamType', $fournisseur->getInBill());
            $form->handleRequest($request);

            if ($form->isSubmitted() && $form->isValid()) 
            {                
                $em = $this->getDoctrine()->getManager();
                $em->persist($fournisseur);
                $em->flush();           
                
                $this->get('session')->getFlashBag()->add('success', 'Vos paramètres ont été enregistrés avec succès...');
                return $this->redirectToRoute('dashboard_index');
                //return $this->redirectToRoute('facturespontane_show_securise', array('id' => $factureSpontane->getId()));
            }

            return $this->render('inbill/parametrer.html.twig', array(
                'form' => $form->createView(),
                'fournisseur'=>$fournisseur,
                'inBill'=>$fournisseur->getInBill(),
            ));
        }else
        {
            $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
            return $this->redirectToRoute('dashboard_index');
        }
    }


    /**
     * Creates a new inBill entity.
     *
     * @Route("/new", name="inbill_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $inBill = new Inbill();
        $form = $this->createForm('AMLA\SqrBundle\Form\InBillType', $inBill);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($inBill);
            $em->flush();

            return $this->redirectToRoute('inbill_show', array('id' => $inBill->getId()));
        }

        return $this->render('inbill/new.html.twig', array(
            'inBill' => $inBill,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a inBill entity.
     *
     * @Route("/{id}", name="inbill_show")
     * @Method("GET")
     */
    public function showAction(InBill $inBill)
    {
        $deleteForm = $this->createDeleteForm($inBill);

        return $this->render('inbill/show.html.twig', array(
            'inBill' => $inBill,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing inBill entity.
     *
     * @Route("/{id}/edit", name="inbill_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, InBill $inBill)
    {
        $deleteForm = $this->createDeleteForm($inBill);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\InBillType', $inBill);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('inbill_edit', array('id' => $inBill->getId()));
        }

        return $this->render('inbill/edit.html.twig', array(
            'inBill' => $inBill,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a inBill entity.
     *
     * @Route("/{id}", name="inbill_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, InBill $inBill)
    {
        $form = $this->createDeleteForm($inBill);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($inBill);
            $em->flush();
        }

        return $this->redirectToRoute('inbill_index');
    }

    /**
     * Creates a form to delete a inBill entity.
     *
     * @param InBill $inBill The inBill entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(InBill $inBill)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('inbill_delete', array('id' => $inBill->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }


    /**
     * Lists all impotQuartier entities.
     *
     * @Route("/amount/to/words", name="inbill_amount_to_words")
     * @Method({"GET", "POST"})
     */
    public function amountToWordsAction(Request $request)
    {
        $amount = $request->get('amount');
        if(!empty($amount))
        {

            $numberToConvert = intVal($amount);
            $localeEnglish = "fr"; // Or en_GB
            
            $wordsFromValue = Numbers_Words::toWords($numberToConvert, $localeEnglish);

            //return new Response($wordsFromValue);
            $post = array( 
                'status' => 'OK',   
                'number' => $amount,  
                'words' => $wordsFromValue,  
                'message' => 'Transcrit avec succès',   
            );

        }
        else
        {
            $post = array( 
                'status' => 'KO',   
                'message' => 'Paramètre manquant',  
                'message' => 'Paramètre manquant',  
                'message' => 'Paramètre manquant',   
            );
        }    

        $ret = new JsonResponse($post);
        return $ret;   
    }
}
