<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\ImpotServerDown;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Psr\Log\LoggerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Impotserverdown controller.
 *
 * @Route("impotserverdown/{_locale}", defaults = {"_locale" = "fr"})
 */
class ImpotServerDownController extends Controller
{
    /**
     * Lists all impotServerDown entities.
     *
     * @Route("/", name="impotserverdown_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $impotServerDowns = $em->getRepository('AMLASqrBundle:ImpotServerDown')->findAll();

        return $this->render('impotserverdown/index.html.twig', array(
            'impotServerDowns' => $impotServerDowns,
        ));
    }

    /**
     * Creates a new impotServerDown entity.
     *
     * @Route("/new", name="impotserverdown_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {   

        $client = new \GuzzleHttp\Client([ 'timeout'=> 2.0]);
        try 
        {
            $response = $client->get($this->getParameter('api_impot_checker'));
            $rep =1;
            $em = $this->getDoctrine()->getManager();
            $impotServerDowns = $em->getRepository('AMLASqrBundle:ImpotServerDown')->findBy(['status'=>0]);
            
            //dump($impotServerDowns);die;
            $emailarray = array();
            foreach($impotServerDowns as $value)
            {
                $emailarray[$value->getAccount()->getEmail()]= $value->getAccount()->getPrenom().' '.$value->getAccount()->getNom();
            }
            
            //dump($emailarray);die;
            if(!empty($emailarray))
            {
                $message = (new \Swift_Message('CHECKTATOO : Notification de disposibilité du serveur.'))
                ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO']) // sender
                ->setTo(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
                ->setBcc($emailarray)      // recipient
                ->setBody(
'Bonjour,
Suite à votre tentative de vérification dans l\'espace vérification de CHECKTATOO lorsque notre serveur étais momentanement indisponible, 
nous vous informons de la disponibilité totale de notre serveur.
Nos équipes travaillent pour éviter la survenance de pareille circonstances.
Nous vous prions de nous excuser pour les désagréments causés 

CHECKTATOO
'
                );
                $this->get('mailer')->send($message); 
            }

            foreach($impotServerDowns as $value)
            {
                $value->setStatus(1);
                $em->persist($value);
                $em->flush($value);
            }

        } catch (\GuzzleHttp\Exception\ConnectException $th) 
        {
           die('bam');
            $rep =0;
        }

        $reply = new JsonResponse($rep);

        return new JsonResponse(1);

    }

    /**
     * Creates a new impotServerDown entity.
     *
     * @Route("/checkkerAction", name="impotserverdown_checkkerAction")
     * @Method({"GET", "POST"})
     */
    public function checkkerAction(Request $request)
    {   

        $client = new \GuzzleHttp\Client([ 'timeout'=> 2.0]);
        try 
        {
            $response = $client->get($this->getParameter('api_impot_checker'));
            $rep =1;
        } catch (\GuzzleHttp\Exception\ConnectException $th) 
        {
            //die('error');
            $em = $this->getDoctrine()->getManager();
            $impotServerDown = new ImpotServerDown();
            $impotServerDown->setAccount($this->getUser());
            $impotServerDown->setStatus(0);

            $em->persist($impotServerDown);
            $em->flush($impotServerDown);
            $rep =0;
        }

        $reply = new JsonResponse($rep);
        return  $reply;

    }

    /**
     * Finds and displays a impotServerDown entity.
     *
     * @Route("/{id}", name="impotserverdown_show")
     * @Method("GET")
     */
    public function showAction(ImpotServerDown $impotServerDown)
    {
        $deleteForm = $this->createDeleteForm($impotServerDown);

        return $this->render('impotserverdown/show.html.twig', array(
            'impotServerDown' => $impotServerDown,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing impotServerDown entity.
     *
     * @Route("/{id}/edit", name="impotserverdown_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, ImpotServerDown $impotServerDown)
    {
        $deleteForm = $this->createDeleteForm($impotServerDown);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\ImpotServerDownType', $impotServerDown);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('impotserverdown_edit', array('id' => $impotServerDown->getId()));
        }

        return $this->render('impotserverdown/edit.html.twig', array(
            'impotServerDown' => $impotServerDown,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a impotServerDown entity.
     *
     * @Route("/{id}", name="impotserverdown_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, ImpotServerDown $impotServerDown)
    {
        $form = $this->createDeleteForm($impotServerDown);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($impotServerDown);
            $em->flush();
        }

        return $this->redirectToRoute('impotserverdown_index');
    }

    /**
     * Creates a form to delete a impotServerDown entity.
     *
     * @param ImpotServerDown $impotServerDown The impotServerDown entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(ImpotServerDown $impotServerDown)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('impotserverdown_delete', array('id' => $impotServerDown->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
